/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.js.utils;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.ml.inline.completion.js.utils.XmlTagsUtils$findClosestTagOnSameLine$;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.DefaultRoleFinder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\b\u0019H\u0082\bJ\n\u0010\u001a\u001a\u00020\u0018*\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/XmlTagsUtils;", "", "()V", "closingXmlTagRoleFinder", "Lcom/intellij/psi/tree/DefaultRoleFinder;", "findClosestTagOnSameLine", "Lcom/intellij/psi/xml/XmlTag;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "getLastOpenedTag", "Lcom/intellij/ml/inline/completion/js/utils/XmlTagsUtils$OpenedTag;", "line", "", "dialectOptionHolder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "advanceUntil", "", "Lcom/intellij/lang/javascript/JSFlexAdapter;", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "isTagClosed", "OpenedTag", "intellij.ml.inline.completion.js"})
@SourceDebugExtension(value={"SMAP\nXmlTagsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagsUtils.kt\ncom/intellij/ml/inline/completion/js/utils/XmlTagsUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n73#1,4:81\n73#1,4:85\n473#2:89\n1#3:90\n*S KotlinDebug\n*F\n+ 1 XmlTagsUtils.kt\ncom/intellij/ml/inline/completion/js/utils/XmlTagsUtils\n*L\n28#1:81,4\n43#1:85,4\n58#1:89\n*E\n"})
public final class XmlTagsUtils {
    @NotNull
    public static final XmlTagsUtils INSTANCE = new XmlTagsUtils();
    @NotNull
    private static final DefaultRoleFinder closingXmlTagRoleFinder;

    private XmlTagsUtils() {
    }

    @Nullable
    public final OpenedTag getLastOpenedTag(@NotNull String line, @NotNull DialectOptionHolder dialectOptionHolder) {
        OpenedTag openedTag;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)dialectOptionHolder, (String)"dialectOptionHolder");
        JSFlexAdapter lexer2 = new JSFlexAdapter(dialectOptionHolder);
        lexer2.start((CharSequence)line);
        Stack stack = new Stack();
        Integer lastClosingAngleBracketOffset = null;
        while (lexer2.getTokenType() != null) {
            IElementType iElementType = lexer2.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_START_TAG_START)) {
                lastClosingAngleBracketOffset = null;
                lexer2.advance();
                if (Intrinsics.areEqual((Object)lexer2.getTokenType(), (Object)JSTokenTypes.XML_TAG_NAME)) {
                    JSFlexAdapter $this$getLastOpenedTag_u24lambda_u240;
                    ((Collection)stack).add(lexer2.getTokenText());
                    XmlTagsUtils xmlTagsUtils = this;
                    $this$advanceUntil$iv = lexer2;
                    $i$f$advanceUntil = false;
                    do {
                        $this$advanceUntil$iv.advance();
                        if ($this$advanceUntil$iv.getTokenType() == null) break;
                        $this$getLastOpenedTag_u24lambda_u240 = $this$advanceUntil$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual((Object)$this$getLastOpenedTag_u24lambda_u240.getTokenType(), (Object)JSTokenTypes.XML_TAG_END) || Intrinsics.areEqual((Object)$this$getLastOpenedTag_u24lambda_u240.getTokenType(), (Object)JSTokenTypes.XML_EMPTY_TAG_END)));
                    if (Intrinsics.areEqual((Object)lexer2.getTokenType(), (Object)JSTokenTypes.XML_TAG_END)) {
                        lastClosingAngleBracketOffset = lexer2.getTokenEnd();
                    }
                    if (Intrinsics.areEqual((Object)lexer2.getTokenType(), (Object)JSTokenTypes.XML_EMPTY_TAG_END)) {
                        CollectionsKt.removeLast((List)stack);
                    }
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)JSTokenTypes.XML_END_TAG_START)) {
                lexer2.advance();
                if (Intrinsics.areEqual((Object)lexer2.getTokenType(), (Object)JSTokenTypes.XML_TAG_NAME)) {
                    JSFlexAdapter $this$getLastOpenedTag_u24lambda_u241;
                    if (!((Collection)stack).isEmpty()) {
                        CollectionsKt.removeLast((List)stack);
                    }
                    XmlTagsUtils this_$iv = this;
                    $this$advanceUntil$iv = lexer2;
                    $i$f$advanceUntil = false;
                    do {
                        $this$advanceUntil$iv.advance();
                        if ($this$advanceUntil$iv.getTokenType() == null) break;
                        $this$getLastOpenedTag_u24lambda_u241 = $this$advanceUntil$iv;
                        boolean bl = false;
                    } while (!Intrinsics.areEqual((Object)$this$getLastOpenedTag_u24lambda_u241.getTokenType(), (Object)JSTokenTypes.XML_TAG_END));
                }
                lastClosingAngleBracketOffset = null;
            }
            lexer2.advance();
        }
        if (!((Collection)stack).isEmpty() && lastClosingAngleBracketOffset != null) {
            Object object = CollectionsKt.last((List)stack);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            openedTag = new OpenedTag((String)object, lastClosingAngleBracketOffset);
        } else {
            openedTag = null;
        }
        return openedTag;
    }

    @Nullable
    public final XmlTag findClosestTagOnSameLine(@NotNull PsiFile file, @NotNull Document document, int offset2) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                psiElement2 = file.findElementAt(offset2);
                if (psiElement2 == null || (psiElement2 = PsiTreeUtilKt.parents((PsiElement)psiElement2, (boolean)true)) == null) break block2;
                PsiElement $this$filterIsInstance$iv = psiElement2;
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findClosestTagOnSameLine$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                psiElement2 = sequence;
                if (sequence != null && (psiElement2 = (XmlTag)SequencesKt.firstOrNull((Sequence)psiElement2)) != null) break block3;
            }
            return null;
        }
        PsiElement candidate = psiElement2;
        int candidateLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)candidate));
        int currentLine = document.getLineNumber(offset2);
        PsiElement it = psiElement = candidate;
        boolean bl = false;
        return candidateLine == currentLine ? psiElement : null;
    }

    public final boolean isTagClosed(@NotNull XmlTag $this$isTagClosed) {
        Intrinsics.checkNotNullParameter((Object)$this$isTagClosed, (String)"<this>");
        return closingXmlTagRoleFinder.findChild($this$isTagClosed.getNode()) != null;
    }

    private final void advanceUntil(JSFlexAdapter $this$advanceUntil, Function1<? super JSFlexAdapter, Boolean> predicate) {
        boolean $i$f$advanceUntil = false;
        do {
            $this$advanceUntil.advance();
        } while ($this$advanceUntil.getTokenType() != null && !((Boolean)predicate.invoke((Object)$this$advanceUntil)).booleanValue());
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.XML_END_TAG_START, JSTokenTypes.XML_EMPTY_TAG_END};
        closingXmlTagRoleFinder = new DefaultRoleFinder(iElementTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/inline/completion/js/utils/XmlTagsUtils$OpenedTag;", "", "name", "", "closingAngleBracketOffset", "", "(Ljava/lang/String;I)V", "getClosingAngleBracketOffset", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.inline.completion.js"})
    public static final class OpenedTag {
        @NotNull
        private final String name;
        private final int closingAngleBracketOffset;

        public OpenedTag(@NotNull String name, int closingAngleBracketOffset) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.closingAngleBracketOffset = closingAngleBracketOffset;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getClosingAngleBracketOffset() {
            return this.closingAngleBracketOffset;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.closingAngleBracketOffset;
        }

        @NotNull
        public final OpenedTag copy(@NotNull String name, int closingAngleBracketOffset) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new OpenedTag(name, closingAngleBracketOffset);
        }

        public static /* synthetic */ OpenedTag copy$default(OpenedTag openedTag, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = openedTag.name;
            }
            if ((n2 & 2) != 0) {
                n = openedTag.closingAngleBracketOffset;
            }
            return openedTag.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "OpenedTag(name=" + this.name + ", closingAngleBracketOffset=" + this.closingAngleBracketOffset + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Integer.hashCode(this.closingAngleBracketOffset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpenedTag)) {
                return false;
            }
            OpenedTag openedTag = (OpenedTag)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)openedTag.name)) {
                return false;
            }
            return this.closingAngleBracketOffset == openedTag.closingAngleBracketOffset;
        }
    }
}

