/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.log.GitExternalLogTabsProperties;
import git4idea.log.GitShowExternalLogAction;
import git4idea.log.GitShowExternalLogActionKt;
import git4idea.log.MyContentComponent;
import git4idea.log.ShowLogTask;
import git4idea.repo.GitRepositoryImpl;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0003\u001aF\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00102\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0003\u001a.\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0003\u001a&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0002\u001a&\u0010!\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001aj\u0010#\u001a\u00020\u001b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00100&2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010'\u001a\u00070\u0001\u00a2\u0006\u0002\b(2\u000b\u0010)\u001a\u00070\u0001\u00a2\u0006\u0002\b*\u001aF\u0010#\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000b\u0010'\u001a\u00070\u0001\u00a2\u0006\u0002\b(2\u000b\u0010)\u001a\u00070\u0001\u00a2\u0006\u0002\b*\u001a*\u0010+\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-2\b\b\u0001\u0010.\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a>\u0010/\u001a\u00020\u001b*\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00100\u001a\u00020-2\u000b\u0010'\u001a\u00070\u0001\u00a2\u0006\u0002\b(2\u000b\u0010)\u001a\u00070\u0001\u00a2\u0006\u0002\b*2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"EXTERNAL", "", "calcLogId", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcTabName", "cm", "Lcom/intellij/ui/content/ContentManager;", "createContent", "Lgit4idea/log/MyContentComponent;", "T", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "manager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "uiFactory", "Lcom/intellij/vcs/log/impl/VcsLogManager$VcsLogUiFactory;", "isToolWindowTab", "", "disposable", "Lcom/intellij/openapi/Disposable;", "createLogManager", "project", "Lcom/intellij/openapi/project/Project;", "vcs", "Lgit4idea/GitVcs;", "doOnProviderRemoval", "", "closeTab", "Lkotlin/Function0;", "getGitRootsFromUser", "selectAlreadyOpened", "", "selectProjectLog", "requestedRoots", "showExternalGitLogInToolwindow", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "Lkotlin/Function1;", "tabTitle", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "tabDescription", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "showLogContentWindow", "content", "Ljavax/swing/JComponent;", "title", "addLogContent", "component", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitShowExternalLogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,266:1\n1549#2:267\n1620#2,3:268\n1855#2,2:278\n12474#3,2:271\n3792#3:273\n4307#3,2:274\n1282#3,2:276\n*S KotlinDebug\n*F\n+ 1 GitShowExternalLogAction.kt\ngit4idea/log/GitShowExternalLogActionKt\n*L\n197#1:267\n197#1:268,3\n198#1:278,2\n219#1:271,2\n229#1:273\n229#1:274,2\n244#1:276,2\n*E\n"})
public final class GitShowExternalLogActionKt {
    @NotNull
    private static final String EXTERNAL = "EXTERNAL";

    public static final void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        GitShowExternalLogActionKt.showExternalGitLogInToolwindow(project, toolWindow, (Function1)new Function1<VcsLogManager, VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi>>(roots){
            final /* synthetic */ List<VirtualFile> $roots;
            {
                this.$roots = $roots;
                super(1);
            }

            @NotNull
            public final VcsLogManager.VcsLogUiFactory<? extends MainVcsLogUi> invoke(@NotNull VcsLogManager it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                VcsLogManager.VcsLogUiFactory vcsLogUiFactory = it.getMainLogUiFactory(GitShowExternalLogActionKt.access$calcLogId(this.$roots), null);
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiFactory, (String)"getMainLogUiFactory(...)");
                return vcsLogUiFactory;
            }
        }, vcs, roots, tabTitle, tabDescription);
    }

    public static final <T extends VcsLogUiEx> void showExternalGitLogInToolwindow(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Function1<? super VcsLogManager, ? extends VcsLogManager.VcsLogUiFactory<T>> uiFactory, @NotNull GitVcs vcs, @NotNull List<? extends VirtualFile> roots, @NotNull String tabTitle, @NotNull String tabDescription) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter(uiFactory, (String)"uiFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)vcs), (String)"vcs");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        Intrinsics.checkNotNullParameter((Object)tabDescription, (String)"tabDescription");
        Function0 showContent2 = (Function0)new Function0<Unit>(project, vcs, roots, toolWindow, uiFactory, tabTitle, tabDescription){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitVcs $vcs;
            final /* synthetic */ List<VirtualFile> $roots;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ Function1<VcsLogManager, VcsLogManager.VcsLogUiFactory<T>> $uiFactory;
            final /* synthetic */ String $tabTitle;
            final /* synthetic */ String $tabDescription;
            {
                this.$project = $project;
                this.$vcs = $vcs;
                this.$roots = $roots;
                this.$toolWindow = $toolWindow;
                this.$uiFactory = $uiFactory;
                this.$tabTitle = $tabTitle;
                this.$tabDescription = $tabDescription;
                super(0);
            }

            public final void invoke() {
                if (!GitShowExternalLogActionKt.access$selectProjectLog(this.$project, this.$vcs, this.$roots)) {
                    ContentManager contentManager = this.$toolWindow.getContentManager();
                    Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
                    if (!GitShowExternalLogActionKt.access$selectAlreadyOpened(contentManager, this.$roots)) {
                        ProgressManager.getInstance().run((Task)new ShowLogTask(this.$project, this.$roots, this.$vcs, false, (Function2<? super VcsLogManager, ? super Disposable, Unit>)((Function2)new Function2<VcsLogManager, Disposable, Unit>(this.$toolWindow, this.$uiFactory, this.$roots, this.$project, this.$tabTitle, this.$tabDescription){
                            final /* synthetic */ ToolWindow $toolWindow;
                            final /* synthetic */ Function1<VcsLogManager, VcsLogManager.VcsLogUiFactory<T>> $uiFactory;
                            final /* synthetic */ List<VirtualFile> $roots;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ String $tabTitle;
                            final /* synthetic */ String $tabDescription;
                            {
                                this.$toolWindow = $toolWindow;
                                this.$uiFactory = $uiFactory;
                                this.$roots = $roots;
                                this.$project = $project;
                                this.$tabTitle = $tabTitle;
                                this.$tabDescription = $tabDescription;
                                super(2);
                            }

                            public final void invoke(@NotNull VcsLogManager $this$$receiver, @NotNull Disposable disposable) {
                                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                                Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
                                boolean isToolWindowTab = Intrinsics.areEqual((Object)this.$toolWindow.getId(), (Object)"Version Control");
                                MyContentComponent component2 = GitShowExternalLogActionKt.access$createContent($this$$receiver, (VcsLogManager.VcsLogUiFactory)this.$uiFactory.invoke((Object)$this$$receiver), this.$roots, isToolWindowTab, disposable);
                                GitShowExternalLogActionKt.access$addLogContent(this.$toolWindow, this.$project, component2, this.$tabTitle, this.$tabDescription, disposable);
                            }
                        })));
                    }
                }
            }
        };
        if (!toolWindow.isVisible()) {
            toolWindow.activate(() -> GitShowExternalLogActionKt.showExternalGitLogInToolwindow$lambda$0(showContent2), true);
        } else {
            showContent2.invoke();
        }
    }

    private static final void addLogContent(ToolWindow $this$addLogContent, Project project, JComponent component2, String tabTitle, String tabDescription, Disposable disposable) {
        Content content = ContentFactory.getInstance().createContent(component2, tabTitle, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setDisposer(disposable);
        content2.setDescription(tabDescription);
        content2.setCloseable(true);
        ContentManager contentManager = $this$addLogContent.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager cm = contentManager;
        cm.addContent(content2);
        cm.setSelectedContent(content2);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)new Function0<Unit>(cm, content2){
            final /* synthetic */ ContentManager $cm;
            final /* synthetic */ Content $content;
            {
                this.$cm = $cm;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                this.$cm.removeContent(this.$content, true);
            }
        }));
    }

    private static final void showLogContentWindow(Project project, JComponent content, @NlsContexts.DialogTitle String title, Disposable disposable) {
        WindowWrapper windowWrapper = new WindowWrapperBuilder(WindowWrapper.Mode.FRAME, content).setProject(project).setTitle(title).setPreferredFocusedComponent(content).setDimensionServiceKey(GitShowExternalLogAction.class.getName()).build();
        Intrinsics.checkNotNullExpressionValue((Object)windowWrapper, (String)"build(...)");
        WindowWrapper window = windowWrapper;
        Disposer.register((Disposable)((Disposable)window), (Disposable)disposable);
        GitShowExternalLogActionKt.doOnProviderRemoval(project, disposable, (Function0<Unit>)((Function0)new Function0<Unit>(window){
            final /* synthetic */ WindowWrapper $window;
            {
                this.$window = $window;
                super(0);
            }

            public final void invoke() {
                this.$window.close();
            }
        }));
        window.show();
    }

    @RequiresEdt
    private static final <T extends VcsLogUiEx> MyContentComponent createContent(VcsLogManager manager2, VcsLogManager.VcsLogUiFactory<T> uiFactory, List<? extends VirtualFile> roots, boolean isToolWindowTab, Disposable disposable) {
        VcsLogUiEx vcsLogUiEx = manager2.createLogUi(uiFactory, isToolWindowTab ? VcsLogTabLocation.TOOL_WINDOW : VcsLogTabLocation.STANDALONE);
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogUiEx, (String)"createLogUi(...)");
        VcsLogUiEx ui = vcsLogUiEx;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)ui));
        return new MyContentComponent((JComponent)new VcsLogPanel(manager2, ui), (Collection<? extends VirtualFile>)roots);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final VcsLogManager createLogManager(Project project, GitVcs vcs, List<? extends VirtualFile> roots, Disposable disposable) {
        Collection<VcsRoot> collection;
        void $this$mapTo$iv$iv;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile virtualFile : roots) {
            repositoryManager.addExternalRepository(virtualFile, GitRepositoryImpl.Companion.createInstance(virtualFile, project, disposable));
        }
        Iterable iterable = roots;
        VcsLogTabsProperties vcsLogTabsProperties = (VcsLogTabsProperties)ApplicationManager.getApplication().getService(GitExternalLogTabsProperties.class);
        Project project2 = project;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new VcsRoot((AbstractVcs)vcs, (VirtualFile)it));
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        VcsLogTabsProperties vcsLogTabsProperties2 = vcsLogTabsProperties;
        Project project3 = project2;
        VcsLogManager manager2 = new VcsLogManager(project3, vcsLogTabsProperties2, collection2);
        Disposer.register((Disposable)disposable, () -> GitShowExternalLogActionKt.createLogManager$lambda$4(manager2, roots, repositoryManager));
        return manager2;
    }

    private static final String calcLogId(List<? extends VirtualFile> roots) {
        Iterable iterable = roots;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        return "EXTERNAL " + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)calcLogId.1.INSTANCE, (int)30, null);
    }

    @Nls
    private static final String calcTabName(ContentManager cm, List<? extends VirtualFile> roots) {
        String name = VcsLogBundle.message((String)"vcs.log.tab.name", (Object[])new Object[0]) + " (" + ((VirtualFile)CollectionsKt.first(roots)).getName() + (roots.size() > 1 ? "+" : "") + ")";
        String candidate = null;
        candidate = name;
        int cnt = 1;
        while (true) {
            boolean bl;
            block2: {
                Content[] contentArray = cm.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$any$iv = contentArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Content content = (Content)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)content.getDisplayName(), (Object)candidate)) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) break;
            candidate = name + "-" + cnt;
            ++cnt;
        }
        return candidate;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getGitRootsFromUser(Project project) {
        void $this$filterTo$iv$iv;
        VirtualFile[] virtualFiles;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, true, false, true);
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        VirtualFile[] $this$filter$iv = virtualFiles = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!GitUtil.isGitRoot(it.toNioPath())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean selectProjectLog(Project project, GitVcs vcs, List<? extends VirtualFile> requestedRoots) {
        VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootsUnderVcs(...)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        List projectRoots = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
        if (!projectRoots.containsAll((Collection)requestedRoots)) {
            return false;
        }
        if (requestedRoots.containsAll(projectRoots)) {
            return VcsLogContentUtil.INSTANCE.selectMainLog(project);
        }
        VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{VcsLogFilterObject.fromRoots((Collection)requestedRoots)};
        VcsLogFilterCollection filters = VcsLogFilterObject.collection((VcsLogFilter[])vcsLogFilterArray);
        return VcsProjectLog.Companion.getInstance(project).openLogTab(filters) != null;
    }

    private static final boolean selectAlreadyOpened(ContentManager cm, Collection<? extends VirtualFile> roots) {
        Object object;
        block2: {
            Content[] contentArray = cm.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JComponent component2;
                Content content = (Content)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)content.getComponent(), (String)"getComponent(...)");
                boolean bl2 = component2 instanceof MyContentComponent ? Comparing.haveEqualElements(roots, ((MyContentComponent)component2).getRoots()) : false;
                if (!bl2) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return false;
        }
        Content content2 = content;
        cm.setSelectedContent(content2);
        return true;
    }

    private static final void doOnProviderRemoval(Project project, Disposable disposable, Function0<Unit> closeTab) {
        VcsLogProvider.LOG_PROVIDER_EP.getPoint((AreaInstance)project).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<VcsLogProvider>(closeTab){
            final /* synthetic */ Function0<Unit> $closeTab;
            {
                this.$closeTab = $closeTab;
            }

            public void extensionRemoved(@NotNull VcsLogProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (Intrinsics.areEqual((Object)extension.getSupportedVcs(), (Object)GitVcs.getKey())) {
                    this.$closeTab.invoke();
                }
            }
        }, false, disposable);
    }

    private static final void showExternalGitLogInToolwindow$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void createLogManager$lambda$4$lambda$3(List $roots, GitRepositoryManager $repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)((Object)$repositoryManager), (String)"$repositoryManager");
        Iterable $this$forEach$iv = $roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            $repositoryManager.removeExternalRepository(it);
        }
    }

    private static final void createLogManager$lambda$4(VcsLogManager $manager, List $roots, GitRepositoryManager $repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)$manager, (String)"$manager");
        Intrinsics.checkNotNullParameter((Object)$roots, (String)"$roots");
        Intrinsics.checkNotNullParameter((Object)((Object)$repositoryManager), (String)"$repositoryManager");
        $manager.dispose(() -> GitShowExternalLogActionKt.createLogManager$lambda$4$lambda$3($roots, $repositoryManager));
    }

    public static final /* synthetic */ List access$getGitRootsFromUser(Project project) {
        return GitShowExternalLogActionKt.getGitRootsFromUser(project);
    }

    public static final /* synthetic */ MyContentComponent access$createContent(VcsLogManager manager2, VcsLogManager.VcsLogUiFactory uiFactory, List roots, boolean isToolWindowTab, Disposable disposable) {
        return GitShowExternalLogActionKt.createContent(manager2, uiFactory, roots, isToolWindowTab, disposable);
    }

    public static final /* synthetic */ String access$calcLogId(List roots) {
        return GitShowExternalLogActionKt.calcLogId(roots);
    }

    public static final /* synthetic */ void access$showLogContentWindow(Project project, JComponent content, String title, Disposable disposable) {
        GitShowExternalLogActionKt.showLogContentWindow(project, content, title, disposable);
    }

    public static final /* synthetic */ String access$calcTabName(ContentManager cm, List roots) {
        return GitShowExternalLogActionKt.calcTabName(cm, roots);
    }

    public static final /* synthetic */ VcsLogManager access$createLogManager(Project project, GitVcs vcs, List roots, Disposable disposable) {
        return GitShowExternalLogActionKt.createLogManager(project, vcs, roots, disposable);
    }

    public static final /* synthetic */ boolean access$selectProjectLog(Project project, GitVcs vcs, List requestedRoots) {
        return GitShowExternalLogActionKt.selectProjectLog(project, vcs, requestedRoots);
    }

    public static final /* synthetic */ boolean access$selectAlreadyOpened(ContentManager cm, Collection roots) {
        return GitShowExternalLogActionKt.selectAlreadyOpened(cm, roots);
    }

    public static final /* synthetic */ void access$addLogContent(ToolWindow $receiver, Project project, JComponent component2, String tabTitle, String tabDescription, Disposable disposable) {
        GitShowExternalLogActionKt.addLogContent($receiver, project, component2, tabTitle, tabDescription, disposable);
    }
}

