/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.AddList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.openapi.vcs.changes.local.EditComment;
import com.intellij.openapi.vcs.changes.local.EditData;
import com.intellij.openapi.vcs.changes.local.EditName;
import com.intellij.openapi.vcs.changes.local.MoveChanges;
import com.intellij.openapi.vcs.changes.local.RemoveList;
import com.intellij.openapi.vcs.changes.local.SetDefault;
import com.intellij.openapi.vcs.changes.local.SetReadOnly;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Modifier {
    private static final Logger LOG = Logger.getInstance(Modifier.class);
    private final ChangeListWorker myWorker;
    private volatile boolean myInsideUpdate;
    private final List<ChangeListCommand> myCommandQueue;
    private final DelayedNotificator myNotificator;

    public Modifier(@NotNull ChangeListWorker worker, @NotNull DelayedNotificator notificator) {
        if (worker == null) {
            Modifier.$$$reportNull$$$0(0);
        }
        if (notificator == null) {
            Modifier.$$$reportNull$$$0(1);
        }
        this.myWorker = worker;
        this.myNotificator = notificator;
        this.myCommandQueue = new ArrayList<ChangeListCommand>();
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data2) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(2);
        }
        AddList command = new AddList(name, comment, data2);
        this.impl(command);
        LocalChangeList newList = command.getNewListCopy();
        LocalChangeList localChangeList = newList != null ? newList : this.myWorker.getDefaultList();
        if (localChangeList == null) {
            Modifier.$$$reportNull$$$0(3);
        }
        return localChangeList;
    }

    public void setDefault(@NotNull String name, boolean automatic) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(4);
        }
        SetDefault command = new SetDefault(name, automatic);
        this.impl(command);
    }

    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(5);
        }
        RemoveList command = new RemoveList(name);
        this.impl(command);
    }

    public void moveChangesTo(@NotNull String name, @NotNull List<Change> changes) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            Modifier.$$$reportNull$$$0(7);
        }
        MoveChanges command = new MoveChanges(name, changes);
        this.impl(command);
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        if (name == null) {
            Modifier.$$$reportNull$$$0(8);
        }
        SetReadOnly command = new SetReadOnly(name, value);
        this.impl(command);
        return command.isResult();
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            Modifier.$$$reportNull$$$0(9);
        }
        if (toName == null) {
            Modifier.$$$reportNull$$$0(10);
        }
        EditName command = new EditName(fromName, toName);
        this.impl(command);
        return command.isResult();
    }

    @Nullable
    public String editComment(@NotNull String fromName, @NotNull String newComment) {
        if (fromName == null) {
            Modifier.$$$reportNull$$$0(11);
        }
        if (newComment == null) {
            Modifier.$$$reportNull$$$0(12);
        }
        EditComment command = new EditComment(fromName, newComment);
        this.impl(command);
        return command.getOldComment();
    }

    public boolean editData(@NotNull String fromName, @Nullable ChangeListData newData) {
        if (fromName == null) {
            Modifier.$$$reportNull$$$0(13);
        }
        EditData command = new EditData(fromName, newData);
        this.impl(command);
        return command.isResult();
    }

    private void impl(@NotNull ChangeListCommand command) {
        if (command == null) {
            Modifier.$$$reportNull$$$0(14);
        }
        if (!this.myWorker.areChangeListsEnabled()) {
            LOG.warn("Changelists are disabled, command ignored", new Throwable());
            return;
        }
        if (this.myInsideUpdate) {
            command.apply(this.myWorker);
            this.myCommandQueue.add(command);
        } else {
            command.apply(this.myWorker);
            this.myNotificator.callNotify(command);
        }
    }

    public boolean isInsideUpdate() {
        return this.myInsideUpdate;
    }

    public void enterUpdate() {
        this.myInsideUpdate = true;
    }

    public void finishUpdate(@Nullable ChangeListWorker updatedWorker) {
        this.myInsideUpdate = false;
        if (!this.myWorker.areChangeListsEnabled()) {
            if (!this.myCommandQueue.isEmpty()) {
                LOG.warn("Changelists are disabled, commands ignored: " + this.myCommandQueue);
            }
            this.myCommandQueue.clear();
            return;
        }
        if (updatedWorker != null) {
            for (ChangeListCommand command : this.myCommandQueue) {
                command.apply(updatedWorker);
            }
        }
        for (ChangeListCommand command : this.myCommandQueue) {
            this.myNotificator.callNotify(command);
        }
        this.myCommandQueue.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificator";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/Modifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newComment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/Modifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "editData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "impl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

