/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryForRevisionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(0);
        }
        boolean visible = TabbedShowHistoryForRevisionAction.isVisible(e);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && TabbedShowHistoryForRevisionAction.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        VcsRevisionNumber revisionNumber;
        String revisionNumberString;
        Project project;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)event.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        AbstractVcs vcs = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS)));
        Pair<FilePath, VcsRevisionNumber> fileAndRevision = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getFileAndRevision(event));
        FilePath file = (FilePath)fileAndRevision.getFirst();
        if (TabbedShowHistoryForRevisionAction.canShowNewFileHistory(project, file, revisionNumberString = (revisionNumber = (VcsRevisionNumber)fileAndRevision.getSecond()).asString())) {
            TabbedShowHistoryForRevisionAction.showNewFileHistory(project, file, revisionNumberString);
        } else {
            VcsHistoryProviderEx vcsHistoryProvider = Objects.requireNonNull((VcsHistoryProviderEx)vcs.getVcsHistoryProvider());
            AbstractVcsHelperImpl helper = Objects.requireNonNull(TabbedShowHistoryForRevisionAction.getVcsHelper(project));
            helper.showFileHistory(vcsHistoryProvider, file, vcs, revisionNumber);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull String revisionNumber) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(4);
        }
        if (revisionNumber == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(5);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)project.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(Collections.singletonList(path2), revisionNumber);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull FilePath path2, @NotNull String revisionNumber) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(7);
        }
        if (revisionNumber == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(8);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)project.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(Collections.singletonList(path2), revisionNumber);
    }

    private static boolean isVisible(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(9);
        }
        if ((project = event.getProject()) == null || project.isDisposed()) {
            return false;
        }
        if (TabbedShowHistoryForRevisionAction.getVcsHelper(project) == null) {
            return false;
        }
        AbstractVcs vcs = TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS));
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
        return vcsHistoryProvider instanceof VcsHistoryProviderEx;
    }

    private static boolean isEnabled(@NotNull AnActionEvent event) {
        Pair<FilePath, VcsRevisionNumber> fileAndRevision;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(10);
        }
        return (fileAndRevision = TabbedShowHistoryForRevisionAction.getFileAndRevision(event)) != null && !((VcsRevisionNumber)fileAndRevision.second).asString().isEmpty();
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getFileAndRevision(@NotNull AnActionEvent event) {
        Change[] changes;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(11);
        }
        if ((changes = (Change[])event.getData(VcsDataKeys.SELECTED_CHANGES)) == null || changes.length != 1) {
            return null;
        }
        Change change = changes[0];
        Pair<FilePath, VcsRevisionNumber> fileAndRevision = TabbedShowHistoryForRevisionAction.getFileAndRevision(change);
        if (fileAndRevision == null || change.getType() != Change.Type.DELETED && !((VcsRevisionNumber)fileAndRevision.second).asString().isEmpty()) {
            return fileAndRevision;
        }
        Project project = event.getProject();
        if (project == null || !TabbedShowHistoryForRevisionAction.canShowNewFileHistory(project, (FilePath)fileAndRevision.getFirst(), ((VcsRevisionNumber)fileAndRevision.getSecond()).asString())) {
            return fileAndRevision;
        }
        VcsRevisionNumber revisionNumber = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revisionNumber == null) {
            return fileAndRevision;
        }
        return Pair.create((Object)((FilePath)fileAndRevision.getFirst()), (Object)revisionNumber);
    }

    @Nullable
    private static Pair<FilePath, VcsRevisionNumber> getFileAndRevision(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(12);
        }
        ContentRevision contentRevision = revision = change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return null;
        }
        return Pair.create((Object)revision.getFile(), (Object)revision.getRevisionNumber());
    }

    @Nullable
    private static AbstractVcs getVcs(@NotNull Project project, @Nullable VcsKey vcsKey) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(13);
        }
        return vcsKey == null ? null : ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName());
    }

    @Nullable
    private static AbstractVcsHelperImpl getVcsHelper(@NotNull Project project) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(14);
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        return (AbstractVcsHelperImpl)((Object)ObjectUtils.tryCast((Object)helper, AbstractVcsHelperImpl.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryForRevisionAction";
                break;
            }
            case 3: 
            case 6: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryForRevisionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showNewFileHistory";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canShowNewFileHistory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileAndRevision";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVcs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVcsHelper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

