/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.process.InterruptibleProcess;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.StreamGobbler;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceProcessWaiter;

public abstract class AbstractP4Connection
implements P4Connection {
    private static final Logger LOG = Logger.getInstance(AbstractP4Connection.class);
    public static final int TIMEOUT_EXIT_CODE = -2;
    public static final String CONNECT_REFUSED = "Connect to server failed";
    private volatile boolean myNotConnected = false;
    private static Map<String, String> ourTestEnvironment = new HashMap<String, String>();
    private static Consumer<? super String> ourCommandCallback = EmptyConsumer.getInstance();

    @Override
    public ExecResult runP4CommandLine(PerforceSettings settings, String[] strings, StringBuffer stringBuffer) throws VcsException {
        ExecResult result = new ExecResult();
        try {
            this.runP4Command(settings, strings, result, stringBuffer);
        }
        catch (IOException | InterruptedException | PerforceTimeoutException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    @Override
    public ExecResult runP4CommandLine(PerforceSettings settings, String[] conArgs, String[] p4args, StringBuffer stringBuffer) throws VcsException {
        ExecResult result = new ExecResult();
        try {
            this.runP4CommandImpl(settings, conArgs, p4args, result, stringBuffer);
        }
        catch (RuntimeException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    protected void runP4CommandImpl(PerforcePhysicalConnectionParametersI parameters, String[] connArgs, String[] p4args, ExecResult retVal, StringBuffer inputStream) {
        try {
            this.runCmdLine(parameters, connArgs, p4args, retVal, inputStream);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            String message;
            if (e instanceof ProcessNotCreatedException && (message = e.getMessage()) != null && message.contains("No such file or directory")) {
                retVal.setException((Throwable)new ProcessNotCreatedException(PerforceBundle.message("dialog.message.invalid.perforce.executable.name", e.getMessage()), e.getCause(), ((ProcessNotCreatedException)e).getCommandLine()));
                return;
            }
            retVal.setException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCmdLine(PerforcePhysicalConnectionParametersI perforceSettings, String[] connArgs, @NonNls String[] p4args, ExecResult retVal, StringBuffer inputData) throws Exception {
        ProgressManager.checkCanceled();
        Project project = perforceSettings.getProject();
        if (!project.isDefault() && !TrustedProjects.isTrusted((Project)project)) {
            throw new IllegalStateException("Shouldn't be possible to run a P4 command in the safe mode");
        }
        File cwd = this.getWorkingDirectory();
        Charset charset = perforceSettings.getConsoleCharset();
        retVal.setCharset(charset);
        GeneralCommandLine cmd = AbstractP4Connection.fillCmdLine(perforceSettings, connArgs, p4args);
        cmd.setWorkDirectory(cwd);
        cmd.setCharset(charset);
        AbstractP4Connection.setEnvironment(cwd, cmd.getEnvironment());
        CommandDebugInfoWrapper debugInfoWrapper = new CommandDebugInfoWrapper(cmd);
        Tracer tracer = new Tracer(project, p4args.length > 0 ? p4args[0] : "", debugInfoWrapper);
        this.debugCmd(cwd, debugInfoWrapper, cmd.getEnvironment());
        int rc = -42;
        Process proc = null;
        MyInterruptibleProcess worker = null;
        PerforceProcessWaiter processWaiter = null;
        String processList = null;
        try {
            tracer.start();
            proc = cmd.createProcess();
            if (inputData != null) {
                AbstractP4Connection.passInputToProcess(inputData.toString(), proc, perforceSettings);
            }
            worker = new MyInterruptibleProcess(project, proc, perforceSettings.getServerTimeout());
            processWaiter = new PerforceProcessWaiter();
            worker.setOnBeforeInterrupt(() -> ((PerforceProcessWaiter)processWaiter).cancelListeners());
            rc = processWaiter.execute(worker, perforceSettings.getServerTimeout());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            rc = -2;
        }
        finally {
            if (rc == -2 && ApplicationManager.getApplication().isUnitTestMode()) {
                processList = ProcessHandle.allProcesses().map(h -> h.pid() + ": " + h.info()).collect(Collectors.joining("\n"));
            }
            tracer.stop();
            if (worker != null) {
                worker.closeProcess();
            } else if (proc != null) {
                InterruptibleProcess.close((Process)proc);
            }
        }
        if (rc == 0) {
            retVal.setExitCode(worker.getExitCode());
            retVal.setOutputGobbler((StreamGobbler)processWaiter.getInStreamListener());
            retVal.setErrorGobbler((StreamGobbler)processWaiter.getErrStreamListener());
            if (worker.getExitCode() != 0 && retVal.getException() == null && retVal.getStderr().contains(CONNECT_REFUSED)) {
                this.notConnected();
                return;
            }
        } else {
            if (rc == -2) {
                retVal.setOutputGobbler((StreamGobbler)processWaiter.getInStreamListener());
                retVal.setErrorGobbler((StreamGobbler)processWaiter.getErrStreamListener());
                LOG.info("Perforce real timeout: " + perforceSettings.getServerTimeout());
                LOG.info("stdout: " + retVal.getStdout());
                LOG.info("stderr: " + retVal.getStderr());
                retVal.setStdout("");
                retVal.setStderr(PerforceBundle.message("exception.text.perforce.integration.disconnected", new Object[0]));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("process list:\n" + processList);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    System.out.println("======================");
                    GeneralCommandLine sysInfo = new GeneralCommandLine(new String[]{SystemInfo.isWindows ? "systeminfo" : (SystemInfo.isMac ? "vm_stat" : "free")}).withRedirectErrorStream(true);
                    System.out.println("system info:\n" + ExecUtil.execAndGetOutput((GeneralCommandLine)sysInfo).getStdout());
                    Path dumpPath = FileUtil.createTempFile((File)new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir"))), (String)"perforce", (String)".hprof.zip", (boolean)false, (boolean)false).toPath();
                    MemoryDumpHelper.captureMemoryDumpZipped((Path)dumpPath);
                    System.out.println("Captured " + dumpPath);
                }
                processWaiter.clearGobblers();
                throw new PerforceTimeoutException();
            }
            LOG.info("Perforce unreal timeout: " + perforceSettings.getServerTimeout() + "; rc=" + rc);
            this.notConnected();
            perforceSettings.disable();
            processWaiter.clearGobblers();
            throw new PerforceTimeoutException();
        }
        this.connected();
    }

    @TestOnly
    public static void setTestEnvironment(Map<String, String> env, Disposable parentDisposable) {
        if (!ourTestEnvironment.isEmpty()) {
            ourTestEnvironment.putAll(env);
            return;
        }
        ourTestEnvironment = new HashMap<String, String>(env);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestEnvironment = Collections.emptyMap();
            }
        });
    }

    public static Map<String, String> getTestEnvironment() {
        return ourTestEnvironment;
    }

    @TestOnly
    public static List<String> dumpCommands(Disposable parentDisposable) {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        AbstractP4Connection.setCommandCallback((Consumer<? super String>)((Consumer)list::add), parentDisposable);
        return list;
    }

    @TestOnly
    public static void setCommandCallback(Consumer<? super String> callback, Disposable parentDisposable) {
        assert (ourCommandCallback == EmptyConsumer.getInstance());
        ourCommandCallback = callback;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourCommandCallback = EmptyConsumer.getInstance();
            }
        });
    }

    private static GeneralCommandLine fillCmdLine(PerforcePhysicalConnectionParametersI perforceSettings, String[] connArgs, String[] p4args) {
        boolean addZProg;
        String cmdName;
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{perforceSettings.getPathToExec()});
        String string = cmdName = p4args.length == 0 ? null : p4args[0];
        if (ourCommandCallback != EmptyConsumer.getInstance()) {
            ourCommandCallback.consume((Object)StringUtil.join((String[])p4args, (String)" "));
        }
        if (addZProg = "true".equals(System.getProperty("perforce.specify.zprog", "true"))) {
            cmd.addParameter("-zprog=IntelliJ_IDEA_" + cmdName);
        }
        cmd.addParameters(connArgs);
        cmd.addParameters(p4args);
        if (perforceSettings.getPathToIgnore() != null) {
            cmd.withEnvironment(P4ConfigFields.P4IGNORE.getName(), perforceSettings.getPathToIgnore());
        }
        return cmd;
    }

    private static void setEnvironment(File cwd, Map<String, String> env) {
        env.put("PWD", cwd.getAbsolutePath());
        env.putAll(ourTestEnvironment);
    }

    private static void passInputToProcess(String inputData, Process proc, PerforcePhysicalConnectionParametersI perforceSettings) throws IOException {
        byte[] bytes;
        OutputStream outputStream = proc.getOutputStream();
        String charsetName = perforceSettings.getCharsetName();
        try {
            bytes = !PerforcePhysicalConnectionParametersI.getCharsetNone().equals(charsetName) ? inputData.getBytes(charsetName) : inputData.getBytes(StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            LOG.info((Throwable)e);
            bytes = inputData.getBytes(StandardCharsets.UTF_8);
        }
        outputStream.write(bytes);
        outputStream.close();
    }

    private void debugCmd(File cwd, CommandDebugInfoWrapper wrapper, Map<String, String> env) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[Perf Execute:] " + wrapper.getPresentation() + "\n [cwd] " + cwd + "\n env=" + env + "\n connection=" + this);
        }
    }

    public void notConnected() {
        this.myNotConnected = true;
    }

    public void connected() {
        this.myNotConnected = false;
    }

    @Override
    public boolean isConnected() {
        return !this.myNotConnected;
    }

    private static final class CommandDebugInfoWrapper {
        private final GeneralCommandLine myCmd;
        private String myPresentation;

        private CommandDebugInfoWrapper(GeneralCommandLine cmd) {
            this.myCmd = cmd;
        }

        String getPresentation() {
            if (this.myPresentation == null) {
                StringBuilder presentation = new StringBuilder();
                String option = P4ConfigFields.P4PASSWD.getFlag();
                List args = this.myCmd.getParametersList().getList();
                for (int i = 0; i < args.size(); ++i) {
                    String s = (String)args.get(i);
                    presentation.append(" ").append(s);
                    if (!option.equals(s.trim()) || i + 1 >= args.size()) continue;
                    presentation.append(" *****");
                    ++i;
                }
                this.myPresentation = presentation.toString();
            }
            return this.myPresentation;
        }
    }

    private static class Tracer {
        private final PerforceManager myPm;
        @NotNull
        private final P4Command myCommand;
        private final CommandDebugInfoWrapper myWrapper;
        private Object myContext;

        Tracer(Project project, String commandName, CommandDebugInfoWrapper wrapper) {
            this.myPm = PerforceManager.getInstance(project);
            this.myCommand = P4Command.getInstance(commandName);
            this.myWrapper = wrapper;
        }

        void start() {
            if (this.myPm.isTraceEnabled()) {
                this.myContext = this.myPm.traceEnter(this.myCommand, this.myWrapper.getPresentation());
            }
        }

        void stop() {
            if (this.myPm.isTraceEnabled()) {
                if (this.myContext == null) {
                    LOG.info("Tracing problem: no enter was registered for " + this.myWrapper.getPresentation());
                    return;
                }
                this.myPm.traceExit(this.myContext, this.myCommand, this.myWrapper.getPresentation());
            }
        }
    }

    private static final class MyInterruptibleProcess
    extends InterruptibleProcess {
        private final boolean myNeedStallDialog;
        private final Project myProject;
        private Runnable myOnBeforeInterrupt;

        private MyInterruptibleProcess(Project project, Process process, long timeout) {
            super(process, timeout, TimeUnit.MILLISECONDS);
            this.myProject = project;
            this.myNeedStallDialog = SwingUtilities.isEventDispatchThread() || ProgressManager.getInstance().hasModalProgressIndicator();
        }

        public void closeProcess() {
            if (this.myOnBeforeInterrupt != null) {
                this.myOnBeforeInterrupt.run();
            }
            super.closeProcess();
        }

        public void setOnBeforeInterrupt(Runnable onBeforeInterrupt) {
            this.myOnBeforeInterrupt = onBeforeInterrupt;
        }

        protected int processTimeout() {
            if (this.myProject.isDisposed()) {
                return -2;
            }
            PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
            if (!ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive((AbstractVcs)vcs)) {
                return -2;
            }
            return Messages.showOkCancelDialog((Project)this.myProject, (String)PerforceBundle.message("confirmation.text.perforce.server.not.responding.disable.integration", new Object[0]), (String)PerforceBundle.message("dialog.title.perforce", new Object[0]), (String)PerforceBundle.message("button.text.wait.more", new Object[0]), (String)PerforceBundle.message("button.text.resent.and.disable.integration", new Object[0]), (Icon)Messages.getQuestionIcon());
        }

        protected int processTimeoutInEDT() {
            if (!this.myNeedStallDialog || this.myProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
                return -2;
            }
            return super.processTimeoutInEDT();
        }
    }
}

