/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.properties.GradleProperties;
import org.jetbrains.plugins.gradle.properties.GradlePropertiesFile;
import org.jetbrains.plugins.gradle.properties.models.Property;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleJvmProviderId;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionContext;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u00020\u0012H\u0002\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0001*\u00020\u0006H\u0000\u00a8\u0006\u0017"}, d2={"findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "getGradleJvmLookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "setupGradleJvm", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "updateGradleJvm", "externalProjectPath", "", "canUseGradleJavaHomeJdk", "", "Lorg/jetbrains/plugins/gradle/util/GradleJvmResolutionContext;", "canUseJavaHomeJdk", "canUseProjectSdk", "findGradleJvm", "resolveProjectJdk", "intellij.gradle"})
@JvmName(name="GradleJvmResolutionUtil")
@ApiStatus.Internal
public final class GradleJvmResolutionUtil {
    @NotNull
    public static final SdkLookupProvider getGradleJvmLookupProvider(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        return SdkLookupProvider.Companion.getInstance(project2, (SdkLookupProvider.Id)new GradleJvmProviderId(projectSettings));
    }

    public static final void setupGradleJvm(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings, @NotNull GradleVersion gradleVersion2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)gradleVersion2, (String)"gradleVersion");
        Path path = Paths.get(projectSettings.getExternalProjectPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        GradleJvmResolutionContext resolutionContext = new GradleJvmResolutionContext(project2, path, gradleVersion2);
        projectSettings.setGradleJvm(GradleJvmResolutionUtil.findGradleJvm(resolutionContext));
        if (projectSettings.getGradleJvm() != null) {
            return;
        }
        if (GradleJvmResolutionUtil.canUseProjectSdk(resolutionContext)) {
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        } else if (GradleJvmResolutionUtil.canUseGradleJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#GRADLE_JAVA_HOME");
        } else if (GradleJvmResolutionUtil.canUseJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#JAVA_HOME");
        } else {
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project2, projectSettings).newLookupBuilder().withProject(project2).withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion2){
                final /* synthetic */ GradleVersion $gradleVersion;
                {
                    this.$gradleVersion = $gradleVersion;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JavaVersion javaVersion = JavaVersion.tryParse((String)it);
                    return javaVersion != null && GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion) && GradleJvmSupportMatrix.Companion.isSupported(this.$gradleVersion, javaVersion);
                }
            });
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
            sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter((Function1)setupGradleJvm.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;
                {
                    this.$projectSettings = $projectSettings;
                    super(1);
                }

                public final void invoke(@Nullable Sdk sdk) {
                    Sdk fakeSdk;
                    Sdk sdk2 = sdk;
                    if (sdk2 != null) {
                        Sdk p0 = sdk2;
                        boolean bl = false;
                        v1 = GradleJvmResolutionUtil.access$findRegisteredSdk(p0);
                    } else {
                        v1 = fakeSdk = null;
                    }
                    if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                        this.$projectSettings.setGradleJvm(fakeSdk.getName());
                    }
                }
            }).onSdkResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;
                {
                    this.$projectSettings = $projectSettings;
                    super(1);
                }

                public final void invoke(@Nullable Sdk sdk) {
                    if (this.$projectSettings.getGradleJvm() == null) {
                        Sdk sdk2 = sdk;
                        this.$projectSettings.setGradleJvm(sdk2 != null ? sdk2.getName() : null);
                    }
                }
            }).executeLookup();
        }
    }

    public static final void updateGradleJvm(@NotNull Project project2, @NotNull String externalProjectPath2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(externalProjectPath2);
        if (gradleProjectSettings == null) {
            return;
        }
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string2 = projectSettings.getGradleJvm();
        if (string2 == null) {
            return;
        }
        String gradleJvm = string2;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return;
        }
        Sdk projectSdk = sdk;
        if (!Intrinsics.areEqual((Object)projectSdk.getName(), (Object)gradleJvm)) {
            return;
        }
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
    }

    private static final boolean canUseGradleJavaHomeJdk(GradleJvmResolutionContext $this$canUseGradleJavaHomeJdk) {
        GradleProperties properties = GradlePropertiesFile.getProperties($this$canUseGradleJavaHomeJdk.getProject(), $this$canUseGradleJavaHomeJdk.getExternalProjectPath());
        Property<String> property2 = properties.getJavaHomeProperty();
        String javaHome = property2 != null ? property2.getValue() : null;
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseGradleJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final boolean canUseJavaHomeJdk(GradleJvmResolutionContext $this$canUseJavaHomeJdk) {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final String findGradleJvm(GradleJvmResolutionContext $this$findGradleJvm) {
        GradleSettings gradleSettings = GradleSettings.getInstance($this$findGradleJvm.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)findGradleJvm.1.INSTANCE));
    }

    private static final boolean canUseProjectSdk(GradleJvmResolutionContext $this$canUseProjectSdk) {
        return GradleJvmResolutionUtil.resolveProjectJdk($this$canUseProjectSdk.getProject()) != null;
    }

    @Nullable
    public static final Sdk resolveProjectJdk(@NotNull Project $this$resolveProjectJdk) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveProjectJdk, (String)"<this>");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)$this$resolveProjectJdk);
        Sdk sdk = projectRootManager.getProjectSdk();
        if (sdk == null) {
            return null;
        }
        Sdk projectSdk = sdk;
        Sdk sdk2 = ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"resolveDependentJdk(...)");
        Sdk resolvedSdk = sdk2;
        if (ExternalSystemJdkUtil.isValidJdk((Sdk)resolvedSdk)) {
            return resolvedSdk;
        }
        return null;
    }

    private static final Sdk findRegisteredSdk(Sdk sdk) {
        return (Sdk)ActionsKt.runReadAction((Function0)((Function0)new Function0<Sdk>(sdk){
            final /* synthetic */ Sdk $sdk;
            {
                this.$sdk = $sdk;
                super(0);
            }

            @Nullable
            public final Sdk invoke() {
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                return projectJdkTable.findJdk(this.$sdk.getName(), this.$sdk.getSdkType().getName());
            }
        }));
    }

    public static final /* synthetic */ Sdk access$findRegisteredSdk(Sdk sdk) {
        return GradleJvmResolutionUtil.findRegisteredSdk(sdk);
    }
}

