/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.proxy;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/InetAddresses;", "", "()V", "loopback", "", "Ljava/net/InetAddress;", "getLoopback", "()Ljava/util/List;", "remote", "getRemote", "analyzeNetworkInterface", "", "networkInterface", "Ljava/net/NetworkInterface;", "analyzeNetworkInterfaces", "Companion", "intellij.gradle.toolingProxy"})
public final class InetAddresses {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<InetAddress> loopback = new ArrayList();
    @NotNull
    private final List<InetAddress> remote = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(InetAddresses.class);
    private static final int REACHABLE_TIMEOUT_MS = 50;

    public InetAddresses() {
        this.analyzeNetworkInterfaces();
    }

    @NotNull
    public final List<InetAddress> getLoopback() {
        return this.loopback;
    }

    @NotNull
    public final List<InetAddress> getRemote() {
        return this.remote;
    }

    private final void analyzeNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Intrinsics.checkNotNull((Object)networkInterface, (String)"null cannot be cast to non-null type java.net.NetworkInterface");
                this.analyzeNetworkInterface(networkInterface);
            }
        }
    }

    private final void analyzeNetworkInterface(NetworkInterface networkInterface) {
        logger.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
        try {
            boolean isLoopbackInterface = networkInterface.isLoopback();
            logger.debug("Is this a loopback interface? {}", (Object)isLoopbackInterface);
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getInetAddresses(...)");
            Enumeration<InetAddress> candidates2 = enumeration;
            while (candidates2.hasMoreElements()) {
                InetAddress candidate;
                Intrinsics.checkNotNull((Object)candidates2.nextElement(), (String)"null cannot be cast to non-null type java.net.InetAddress");
                if (isLoopbackInterface) {
                    if (candidate.isLoopbackAddress()) {
                        if (candidate.isReachable(50)) {
                            logger.debug("Adding loopback address {}", (Object)candidate);
                            this.loopback.add(candidate);
                            continue;
                        }
                        logger.debug("Ignoring unreachable local address on loopback interface {}", (Object)candidate);
                        continue;
                    }
                    logger.debug("Ignoring remote address on loopback interface {}", (Object)candidate);
                    continue;
                }
                if (candidate.isLoopbackAddress()) {
                    logger.debug("Ignoring loopback address on remote interface {}", (Object)candidate);
                    continue;
                }
                logger.debug("Adding remote address {}", (Object)candidate);
                this.remote.add(candidate);
            }
        }
        catch (SocketException e) {
            logger.debug("Error while querying interface {} for IP addresses", (Object)networkInterface, (Object)e);
        }
        catch (Throwable t) {
            String string2 = "Could not determine the IP addresses for network interface %s";
            Object[] objectArray = new Object[]{networkInterface.getName()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new RuntimeException(string3, t);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/proxy/InetAddresses$Companion;", "", "()V", "REACHABLE_TIMEOUT_MS", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "intellij.gradle.toolingProxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

