/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u001e\u0018\u00002\u00020\u0001Bu\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0013J\b\u0010,\u001a\u00020\u0007H\u0002J\u0014\u0010-\u001a\n .*\u0004\u0018\u00010\u00070\u0007*\u00020\u0003H\u0002R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0019\u0010\u0015R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0015R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010 R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0015\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/gradle/internal/daemon/DaemonState;", "Ljava/io/Serializable;", "pid", "", "token", "", "version", "", "status", "reason", "timestamp", "daemonExpirationStatus", "daemonOpts", "", "javaHome", "Ljava/io/File;", "idleTimeout", "", "registryDir", "(Ljava/lang/Long;[BLjava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/util/Collection;Ljava/io/File;Ljava/lang/Integer;Ljava/io/File;)V", "getDaemonExpirationStatus", "()Ljava/lang/String;", "getDaemonOpts", "()Ljava/util/Collection;", "description", "getDescription", "description$delegate", "Lkotlin/Lazy;", "getIdleTimeout", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getJavaHome", "()Ljava/io/File;", "getPid", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getReason", "getRegistryDir", "getStatus", "getTimestamp", "()J", "getToken", "()[B", "getVersion", "calculateDescription", "asFormattedTimestamp", "kotlin.jvm.PlatformType", "intellij.gradle"})
public final class DaemonState
implements Serializable {
    @Nullable
    private final Long pid;
    @Nullable
    private final byte[] token;
    @Nullable
    private final String version;
    @NotNull
    private final String status;
    @Nullable
    private final String reason;
    private final long timestamp;
    @Nullable
    private final String daemonExpirationStatus;
    @Nullable
    private final Collection<String> daemonOpts;
    @Nullable
    private final File javaHome;
    @Nullable
    private final Integer idleTimeout;
    @Nullable
    private final File registryDir;
    @NotNull
    private final Lazy description$delegate;

    public DaemonState(@Nullable Long pid, @Nullable byte[] token, @Nullable String version, @NotNull String status, @Nullable String reason, long timestamp, @Nullable String daemonExpirationStatus, @Nullable Collection<String> daemonOpts, @Nullable File javaHome, @Nullable Integer idleTimeout, @Nullable File registryDir) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.pid = pid;
        this.token = token;
        this.version = version;
        this.status = status;
        this.reason = reason;
        this.timestamp = timestamp;
        this.daemonExpirationStatus = daemonExpirationStatus;
        this.daemonOpts = daemonOpts;
        this.javaHome = javaHome;
        this.idleTimeout = idleTimeout;
        this.registryDir = registryDir;
        this.description$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DaemonState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return DaemonState.access$calculateDescription(this.this$0);
            }
        }));
    }

    @Nullable
    public final Long getPid() {
        return this.pid;
    }

    @Nullable
    public final byte[] getToken() {
        return this.token;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getStatus() {
        return this.status;
    }

    @Nullable
    public final String getReason() {
        return this.reason;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public final String getDaemonExpirationStatus() {
        return this.daemonExpirationStatus;
    }

    @Nullable
    public final Collection<String> getDaemonOpts() {
        return this.daemonOpts;
    }

    @Nullable
    public final File getJavaHome() {
        return this.javaHome;
    }

    @Nullable
    public final Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    @Nullable
    public final File getRegistryDir() {
        return this.registryDir;
    }

    @NotNull
    public final String getDescription() {
        Lazy lazy = this.description$delegate;
        return (String)lazy.getValue();
    }

    private final String calculateDescription() {
        StringBuilder info = new StringBuilder();
        info.append(this.pid).append(" ").append(this.asFormattedTimestamp(this.timestamp)).append(" ").append(this.status).append(" ");
        Object object = this.version;
        if (!(object == null || object.length() == 0)) {
            info.append("Gradle version: ").append(this.version);
        }
        if (!((object = (CharSequence)this.daemonExpirationStatus) == null || object.length() == 0)) {
            info.append("\nExpiration status: ").append(this.daemonExpirationStatus);
        }
        if (!((object = (CharSequence)this.reason) == null || object.length() == 0)) {
            info.append("\nStop reason: ").append(this.reason);
        }
        if (this.registryDir != null) {
            info.append("\nDaemons dir: ").append(this.registryDir);
        }
        if (this.javaHome != null) {
            info.append("\nJava home: ").append(this.javaHome.getPath());
        }
        if (!((object = this.daemonOpts) == null || object.isEmpty())) {
            info.append("\nDaemon options: ").append(this.daemonOpts);
        }
        if (this.idleTimeout != null) {
            info.append("\nIdle timeout: ").append(this.idleTimeout);
        }
        String string2 = info.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String asFormattedTimestamp(long $this$asFormattedTimestamp) {
        return DateFormat.getDateTimeInstance(3, 3).format(new Date($this$asFormattedTimestamp));
    }

    public static final /* synthetic */ String access$calculateDescription(DaemonState $this) {
        return $this.calculateDescription();
    }
}

