/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastControlFlowUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/junit/codeInspection/SuperTearDownInFinallyVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "hasNonTrivialActivity", "", "parentMethod", "Lorg/jetbrains/uast/UElement;", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitCallExpression", "NonTrivialActivityVisitor", "intellij.junit"})
final class SuperTearDownInFinallyVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public SuperTearDownInFinallyVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node.getReceiver() instanceof USuperExpression) || !Intrinsics.areEqual((Object)node.getMethodName(), (Object)"tearDown")) {
            return true;
        }
        Class[] classArray = new Class[]{ULambdaExpression.class, UDeclaration.class};
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)((UElement)node), UMethod.class, (boolean)true, (Class[])classArray);
        if (uMethod == null) {
            return true;
        }
        UMethod parentMethod = uMethod;
        if (!Intrinsics.areEqual((Object)parentMethod.getName(), (Object)"tearDown")) {
            return true;
        }
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (uClass == null || (uClass = uClass.getJavaPsi()) == null) {
            return true;
        }
        UClass containingClass = uClass;
        if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.TestCase")) {
            return true;
        }
        if (UastControlFlowUtils.isInFinallyBlock((UElement)((UElement)node))) {
            return true;
        }
        if (!this.hasNonTrivialActivity((UElement)parentMethod, node)) {
            return true;
        }
        String string = JUnitBundle.message("jvm.inspections.junit3.super.teardown.problem.descriptor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message2 = string;
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)message2, (LocalQuickFix[])new LocalQuickFix[0], null, (int)8, null);
        return true;
    }

    private final boolean hasNonTrivialActivity(UElement parentMethod, UCallExpression node) {
        NonTrivialActivityVisitor visitor = new NonTrivialActivityVisitor(node);
        parentMethod.accept((UastVisitor)visitor);
        return visitor.getHasNonTrivialActivity();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/execution/junit/codeInspection/SuperTearDownInFinallyVisitor$NonTrivialActivityVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "ignore", "Lorg/jetbrains/uast/UCallExpression;", "(Lorg/jetbrains/uast/UCallExpression;)V", "hasNonTrivialActivity", "", "getHasNonTrivialActivity", "()Z", "setHasNonTrivialActivity", "(Z)V", "visitCallExpression", "node", "intellij.junit"})
    private static final class NonTrivialActivityVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final UCallExpression ignore;
        private boolean hasNonTrivialActivity;

        public NonTrivialActivityVisitor(@NotNull UCallExpression ignore) {
            Intrinsics.checkNotNullParameter((Object)ignore, (String)"ignore");
            this.ignore = ignore;
        }

        public final boolean getHasNonTrivialActivity() {
            return this.hasNonTrivialActivity;
        }

        public final void setHasNonTrivialActivity(boolean bl) {
            this.hasNonTrivialActivity = bl;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node, (Object)this.ignore)) {
                return true;
            }
            this.hasNonTrivialActivity = true;
            return true;
        }
    }
}

