/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.MavenWrapperSupport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification;", "", "()V", "Companion", "intellij.maven"})
public final class MavenWrapperEventLogNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void noDistributionUrlEvent(@NotNull Project project2, @NotNull String multiModuleDir) {
        Companion.noDistributionUrlEvent(project2, multiModuleDir);
    }

    @JvmStatic
    public static final void informationEvent(@NotNull Project project2, @Nls @NotNull String content) {
        Companion.informationEvent(project2, content);
    }

    @JvmStatic
    public static final void errorDownloading(@NotNull Project project2, @NotNull String error) {
        Companion.errorDownloading(project2, error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\rH\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification$Companion;", "", "()V", "distributionUrlEmpty", "", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "project", "Lcom/intellij/openapi/project/Project;", "wrapperPropertyFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "errorDownloading", "error", "", "informationEvent", "content", "noDistributionUrlEvent", "multiModuleDir", "wrapperPropertyFileNotFound", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenWrapperEventLogNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWrapperEventLogNotification.kt\norg/jetbrains/idea/maven/server/MavenWrapperEventLogNotification$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void noDistributionUrlEvent(@NotNull Project project2, @NotNull String multiModuleDir) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)multiModuleDir, (String)"multiModuleDir");
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.noDistributionUrlEvent$lambda$1(multiModuleDir, notificationGroup2, project2));
        }

        @JvmStatic
        public final void informationEvent(@NotNull Project project2, @Nls @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.informationEvent$lambda$2(notificationGroup2, content, project2));
        }

        @JvmStatic
        public final void errorDownloading(@NotNull Project project2, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Maven");
            if (notificationGroup == null) {
                return;
            }
            NotificationGroup notificationGroup2 = notificationGroup;
            ApplicationManager.getApplication().invokeLater(() -> Companion.errorDownloading$lambda$4(notificationGroup2, error, project2));
        }

        private final void wrapperPropertyFileNotFound(NotificationGroup notificationGroup, Project project2) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.wrapper.notification.empty.url.content.file.not.found", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId("maven.wrapper.file.not.found.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.disable", new Object[0]), () -> Companion.wrapperPropertyFileNotFound$lambda$5(project2))).notify(project2);
        }

        private final void distributionUrlEmpty(NotificationGroup notificationGroup, Project project2, VirtualFile wrapperPropertyFile) {
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = SyncBundle.message("maven.wrapper.notification.empty.url.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            notificationGroup.createNotification(string, string2, NotificationType.WARNING).setDisplayId("maven.wrapper.empty.url.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.check", new Object[0]), () -> Companion.distributionUrlEmpty$lambda$6(project2, wrapperPropertyFile))).addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.empty.url.action.disable", new Object[0]), () -> Companion.distributionUrlEmpty$lambda$7(project2))).notify(project2);
        }

        private static final void noDistributionUrlEvent$lambda$1(String $multiModuleDir, NotificationGroup $notificationGroup, Project $project) {
            VirtualFile wrapperPropertyFile;
            Intrinsics.checkNotNullParameter((Object)$multiModuleDir, (String)"$multiModuleDir");
            Intrinsics.checkNotNullParameter((Object)$notificationGroup, (String)"$notificationGroup");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath($multiModuleDir);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                v1 = MavenWrapperSupport.Companion.getWrapperProperties(it);
            } else {
                v1 = wrapperPropertyFile = null;
            }
            if (wrapperPropertyFile == null) {
                Companion.wrapperPropertyFileNotFound($notificationGroup, $project);
            } else {
                Companion.distributionUrlEmpty($notificationGroup, $project, wrapperPropertyFile);
            }
        }

        private static final void informationEvent$lambda$2(NotificationGroup $notificationGroup, String $content, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$notificationGroup, (String)"$notificationGroup");
            Intrinsics.checkNotNullParameter((Object)$content, (String)"$content");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $notificationGroup.createNotification(string, $content, NotificationType.INFORMATION).setDisplayId("maven.wrapper.information.notification").notify($project);
        }

        private static final void errorDownloading$lambda$4$lambda$3(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        private static final void errorDownloading$lambda$4(NotificationGroup $notificationGroup, String $error, Project $project) {
            Intrinsics.checkNotNullParameter((Object)$notificationGroup, (String)"$notificationGroup");
            Intrinsics.checkNotNullParameter((Object)$error, (String)"$error");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            String string = SyncBundle.message("maven.wrapper.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{$error};
            String string2 = SyncBundle.message("maven.wrapper.notification.downloading.error.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $notificationGroup.createNotification(string, string2, NotificationType.ERROR).setDisplayId("maven.wrapper.downloading.error.notification").addAction((AnAction)NotificationAction.createSimple((String)SyncBundle.message("maven.wrapper.notification.downloading.error.action", new Object[0]), () -> Companion.errorDownloading$lambda$4$lambda$3($project))).notify($project);
        }

        private static final void wrapperPropertyFileNotFound$lambda$5(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        private static final void distributionUrlEmpty$lambda$6(Project $project, VirtualFile $wrapperPropertyFile) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$wrapperPropertyFile, (String)"$wrapperPropertyFile");
            Path path2 = $wrapperPropertyFile.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            OpenFileQuickFix.Companion.showFile($project, path2, null);
        }

        private static final void distributionUrlEmpty$lambda$7(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            ShowSettingsUtil.getInstance().showSettingsDialog($project, MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

