/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.trusted.ExternalSystemTrustedProjectDialog;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.actions.MavenProjectsManagerAction;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/project/actions/ReimportAction;", "Lorg/jetbrains/idea/maven/project/actions/MavenProjectsManagerAction;", "()V", "isAvailable", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isVisible", "perform", "", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "intellij.maven"})
public final class ReimportAction
extends MavenProjectsManagerAction {
    @Override
    public boolean isVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return !Registry.is((String)"maven.incremental.sync.in.ui");
    }

    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return MavenActionUtil.hasProject(e.getDataContext());
    }

    @Override
    protected void perform(@NotNull MavenProjectsManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Project project2 = manager.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        ExternalSystemTrustedProjectDialog.confirmLoadingUntrustedProject((Project)project2, (ProjectSystemId)projectSystemId);
        FileDocumentManager.getInstance().saveAllDocuments();
        MavenLog.LOG.info("ReimportAction forceUpdateAllProjectsOrFindAllAvailablePomFiles");
        manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles();
    }
}

