/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.ExceptionUtilRt;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemotePullUtil;
import org.jetbrains.idea.maven.server.ServerLogEvent;

public class MavenServerLoggerWrapper
extends MavenRemoteObject
implements MavenPullServerLogger {
    private final ConcurrentLinkedQueue<ServerLogEvent> myPullingQueue = new ConcurrentLinkedQueue();

    public void info(Throwable e) {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.INFO, this.serialize(e)));
    }

    public void warn(Throwable e) {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.WARN, this.serialize(e)));
    }

    public void error(Throwable e) {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.ERROR, this.serialize(e)));
    }

    public void print(String o) {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.PRINT, o));
    }

    public void debug(String o) {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.DEBUG, o));
    }

    @Override
    @NotNull
    public List<ServerLogEvent> pull() {
        List<ServerLogEvent> list = MavenRemotePullUtil.pull(this.myPullingQueue);
        if (list == null) {
            MavenServerLoggerWrapper.$$$reportNull$$$0(0);
        }
        return list;
    }

    private String serialize(Throwable e) {
        return ExceptionUtilRt.getThrowableText((Throwable)this.wrapException(e), (String)"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerLoggerWrapper", "pull"));
    }
}

