/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import com.intellij.AbstractBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpsDynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(JpsDynamicBundle.class);
    private static final Method SET_PARENT = JpsDynamicBundle.getSetParentMethod();
    private static final ClassLoader ourLangBundleLoader;

    private static Method getSetParentMethod() {
        try {
            return ReflectionUtil.getDeclaredMethod(ResourceBundle.class, (String)"setParent", (Class[])new Class[]{ResourceBundle.class});
        }
        catch (Throwable e) {
            return null;
        }
    }

    public JpsDynamicBundle(@NotNull Class<?> bundleClass, @NotNull String pathToBundle) {
        if (bundleClass == null) {
            JpsDynamicBundle.$$$reportNull$$$0(0);
        }
        if (pathToBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(1);
        }
        super(bundleClass, pathToBundle);
    }

    protected JpsDynamicBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(2);
        }
        super(pathToBundle);
    }

    @NotNull
    protected ResourceBundle findBundle(@NotNull @NonNls String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(3);
        }
        if (loader == null) {
            JpsDynamicBundle.$$$reportNull$$$0(4);
        }
        if (control == null) {
            JpsDynamicBundle.$$$reportNull$$$0(5);
        }
        ResourceBundle base = super.findBundle(pathToBundle, loader, control);
        ClassLoader languageBundleLoader = ourLangBundleLoader;
        if (languageBundleLoader != null) {
            ResourceBundle resourceBundle;
            ResourceBundle languageBundle = super.findBundle(pathToBundle, languageBundleLoader, control);
            try {
                if (SET_PARENT != null) {
                    SET_PARENT.invoke((Object)languageBundle, base);
                }
                resourceBundle = languageBundle;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
            if (resourceBundle == null) {
                JpsDynamicBundle.$$$reportNull$$$0(6);
            }
            return resourceBundle;
        }
        ResourceBundle resourceBundle = base;
        if (resourceBundle == null) {
            JpsDynamicBundle.$$$reportNull$$$0(7);
        }
        return resourceBundle;
    }

    static {
        URLClassLoader loader = null;
        try {
            String bundlePath = System.getProperty("jps.language.bundle", null);
            if (bundlePath != null) {
                loader = new URLClassLoader(new URL[]{new File(bundlePath).toURI().toURL()}, null);
            }
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            ourLangBundleLoader = loader;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/api/JpsDynamicBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/api/JpsDynamicBundle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

