/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class GenericType
implements Type {
    public static final int WILDCARD_EXTENDS = 1;
    public static final int WILDCARD_SUPER = 2;
    public static final int WILDCARD_UNBOUND = 3;
    public static final int WILDCARD_NO = 4;
    private final int type;
    private final int arrayDim;
    private final String value;
    private final List<GenericType> enclosingClasses = new ArrayList<GenericType>();
    private final List<GenericType> arguments = new ArrayList<GenericType>();
    private final List<Integer> wildcards = new ArrayList<Integer>();

    public GenericType(int type, int arrayDim, String value) {
        this.type = type;
        this.arrayDim = arrayDim;
        this.value = value;
    }

    private GenericType(GenericType other, int arrayDim) {
        this(other.getType(), arrayDim, other.getValue());
        this.enclosingClasses.addAll(other.enclosingClasses);
        this.arguments.addAll(other.arguments);
        this.wildcards.addAll(other.wildcards);
    }

    public GenericType(String signature) {
        int type = 0;
        int arrayDim = 0;
        String value = null;
        block5: for (int index = 0; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '[': {
                    ++arrayDim;
                    continue block5;
                }
                case 'T': {
                    type = 18;
                    value = signature.substring(index + 1, signature.length() - 1);
                    break block5;
                }
                case 'L': {
                    String args;
                    String name;
                    type = 8;
                    signature = signature.substring(index + 1, signature.length() - 1);
                    while (true) {
                        String cl;
                        name = cl = GenericType.getNextClassSignature(signature);
                        args = null;
                        int argStart = cl.indexOf("<");
                        if (argStart >= 0) {
                            name = cl.substring(0, argStart);
                            args = cl.substring(argStart + 1, cl.length() - 1);
                        }
                        if (cl.length() >= signature.length()) break;
                        signature = signature.substring(cl.length() + 1);
                        GenericType type11 = new GenericType(8, 0, name);
                        GenericType.parseArgumentsList(args, type11);
                        this.enclosingClasses.add(type11);
                    }
                    value = name;
                    GenericType.parseArgumentsList(args, this);
                    break block5;
                }
                default: {
                    value = signature.substring(index, index + 1);
                    type = VarType.getType(value.charAt(0));
                }
            }
        }
        this.type = type;
        this.arrayDim = arrayDim;
        this.value = value;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getArrayDim() {
        return this.arrayDim;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getNextClassSignature(String value) {
        int counter = 0;
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    --counter;
                    break;
                }
                case '.': {
                    if (counter != 0) break;
                    return value.substring(0, index);
                }
            }
            ++index;
        }
        return value.substring(0, index);
    }

    private static void parseArgumentsList(String value, GenericType type) {
        if (value == null) {
            return;
        }
        while (value.length() > 0) {
            String typeStr = GenericType.getNextType(value);
            int len = typeStr.length();
            int wildcard = switch (typeStr.charAt(0)) {
                case '*' -> 3;
                case '+' -> 1;
                case '-' -> 2;
                default -> 4;
            };
            type.getWildcards().add(wildcard);
            if (wildcard != 4) {
                typeStr = typeStr.substring(1);
            }
            type.getArguments().add(typeStr.length() == 0 ? null : new GenericType(typeStr));
            value = value.substring(len);
        }
    }

    public static String getNextType(String value) {
        int index;
        int counter = 0;
        boolean contMode = false;
        block8: for (index = 0; index < value.length(); ++index) {
            switch (value.charAt(index)) {
                case '*': {
                    if (contMode) continue block8;
                    break block8;
                }
                case 'L': 
                case 'T': {
                    if (!contMode) {
                        contMode = true;
                    }
                }
                case '+': 
                case '-': 
                case '[': {
                    continue block8;
                }
                case '<': {
                    ++counter;
                    continue block8;
                }
                case '>': {
                    --counter;
                    continue block8;
                }
                case ';': {
                    if (counter != 0) continue block8;
                    break block8;
                }
                default: {
                    if (!contMode) break block8;
                }
            }
        }
        return value.substring(0, index + 1);
    }

    public GenericType decreaseArrayDim() {
        assert (this.getArrayDim() > 0) : this;
        return new GenericType(this, this.getArrayDim() - 1);
    }

    public List<GenericType> getArguments() {
        return this.arguments;
    }

    public List<GenericType> getEnclosingClasses() {
        return this.enclosingClasses;
    }

    public List<Integer> getWildcards() {
        return this.wildcards;
    }
}

