/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.testFramework.ProfilerForTests;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerForTests;", "Lcom/intellij/testFramework/ProfilerForTests;", "()V", "instance", "Lone/profiler/AsyncProfiler;", "startProfiling", "", "logDir", "Ljava/nio/file/Path;", "fileName", "", "stopProfiling", "intellij.profiler.ultimate.ideaAsyncProfiler"})
public final class AsyncProfilerForTests
implements ProfilerForTests {
    @Nullable
    private final AsyncProfiler instance = !SystemInfo.isWindows ? AsyncProfilerExtractor.INSTANCE.getAsyncProfilerInstance(null) : null;

    public void startProfiling(@NotNull Path logDir, @NotNull String fileName) throws IOException {
        block0: {
            Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            AsyncProfiler asyncProfiler = this.instance;
            if (asyncProfiler == null) break block0;
            asyncProfiler.execute("start,interval=5ms,event=wall,jfr,file=" + logDir.resolve(fileName + ".jfr") + ",loglevel=DEBUG,log=" + logDir.resolve(fileName + ".log"));
        }
    }

    public void stopProfiling() throws IOException {
        block0: {
            AsyncProfiler asyncProfiler = this.instance;
            if (asyncProfiler == null) break block0;
            asyncProfiler.execute("stop");
        }
    }
}

