/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.newUsersOnboarding;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.platform.ide.newUiOnboarding.NewUiOnboardingStep;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingBundle;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingDialog;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingExecutor;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingExperiment;
import com.intellij.platform.ide.newUsersOnboarding.NewUsersOnboardingStatistics;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\fJ\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "currentDialog", "Lcom/intellij/openapi/ui/DialogWrapper;", "currentExecutor", "Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingExecutor;", "<set-?>", "", "wasDialogShownDuringIdeSession", "getWasDialogShownDuringIdeSession", "()Z", "getSteps", "", "Lkotlin/Pair;", "", "Lcom/intellij/platform/ide/newUiOnboarding/NewUiOnboardingStep;", "getStepsOrder", "onDialogClosed", "", "exitCode", "", "shouldShowOnboardingDialog", "showOnboardingDialog", "startOnboarding", "Companion", "intellij.platform.ide.newUsersOnboarding"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNewUsersOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1603#2,9:113\n1855#2:122\n1856#2:124\n1612#2:125\n1#3:123\n*S KotlinDebug\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService\n*L\n87#1:113,9\n87#1:122\n87#1:124\n87#1:125\n87#1:123\n*E\n"})
public final class NewUsersOnboardingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private NewUsersOnboardingExecutor currentExecutor;
    @Nullable
    private DialogWrapper currentDialog;
    private boolean wasDialogShownDuringIdeSession;
    @NotNull
    private static final String NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY = "NEW_USERS_ONBOARDING_DIALOG_SHOWN";

    public NewUsersOnboardingService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    public final boolean getWasDialogShownDuringIdeSession() {
        return this.wasDialogShownDuringIdeSession;
    }

    public final void showOnboardingDialog() {
        DialogWrapper dialogWrapper = this.currentDialog;
        if (dialogWrapper != null) {
            dialogWrapper.close(2);
        }
        NewUsersOnboardingDialog dialog2 = new NewUsersOnboardingDialog(this.project, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

            public final void invoke(int p0) {
                NewUsersOnboardingService.access$onDialogClosed((NewUsersOnboardingService)this.receiver, p0);
            }
        }));
        this.currentDialog = dialog2;
        dialog2.show();
        this.wasDialogShownDuringIdeSession = true;
        PropertiesComponent.getInstance().setValue(NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY, true);
        NewUsersOnboardingStatistics.INSTANCE.logDialogShown(this.project);
    }

    private final void onDialogClosed(int exitCode) {
        this.currentDialog = null;
        switch (exitCode) {
            case 0: {
                this.startOnboarding();
                NewUsersOnboardingStatistics.INSTANCE.logOnboardingStarted(this.project, NewUsersOnboardingStatistics.OnboardingStartingPlace.DIALOG);
                break;
            }
            case 1: {
                new Notification("newUsersOnboarding", NewUsersOnboardingBundle.INSTANCE.message("notification.text", new Object[0]), NotificationType.INFORMATION).notify(this.project);
                NewUsersOnboardingStatistics.INSTANCE.logDialogSkipPressed(this.project);
            }
        }
    }

    public final boolean shouldShowOnboardingDialog() {
        return NewUsersOnboardingExperiment.Companion.getInstance().isEnabled() && !PropertiesComponent.getInstance().getBoolean(NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY) && ConfigImportHelper.isNewUser();
    }

    public final void startOnboarding() {
        NewUsersOnboardingExecutor executor2;
        NewUsersOnboardingExecutor newUsersOnboardingExecutor = this.currentExecutor;
        if (newUsersOnboardingExecutor != null) {
            newUsersOnboardingExecutor.finishOnboarding(NewUsersOnboardingStatistics.OnboardingStopReason.INTERRUPTED);
        }
        List<Pair<String, NewUiOnboardingStep>> steps = this.getSteps();
        CoroutineScope childScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"onboarding executor", null, (boolean)false, (int)6, null);
        this.currentExecutor = executor2 = new NewUsersOnboardingExecutor(this.project, steps, childScope, (Disposable)this.project, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ NewUsersOnboardingService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                NewUsersOnboardingService.access$setCurrentExecutor$p(this.this$0, null);
            }
        }));
        executor2.start();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<String, NewUiOnboardingStep>> getSteps() {
        void $this$mapNotNullTo$iv$iv;
        List<String> stepIds = this.getStepsOrder();
        Iterable $this$mapNotNull$iv = stepIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            NewUiOnboardingStep step;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String id = (String)element$iv$iv;
            boolean bl2 = false;
            NewUiOnboardingStep newUiOnboardingStep = step = NewUiOnboardingStep.Companion.getIfAvailable(id);
            if ((newUiOnboardingStep != null ? TuplesKt.to((Object)id, (Object)newUiOnboardingStep) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getStepsOrder() {
        Object[] objectArray = new String[]{"mainMenu", "projectWidget", "gitWidget", "runWidget", "searchEverywhere", "settingsPopup", "toolWindowLayouts", "moreToolWindows", "learnToolWindow"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ void access$onDialogClosed(NewUsersOnboardingService $this, int exitCode) {
        $this.onDialogClosed(exitCode);
    }

    public static final /* synthetic */ void access$setCurrentExecutor$p(NewUsersOnboardingService $this, NewUsersOnboardingExecutor newUsersOnboardingExecutor) {
        $this.currentExecutor = newUsersOnboardingExecutor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion;", "", "()V", "NEW_USERS_ONBOARDING_DIALOG_SHOWN_PROPERTY", "", "getInstance", "Lcom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.newUsersOnboarding"})
    @SourceDebugExtension(value={"SMAP\nNewUsersOnboardingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,112:1\n31#2,2:113\n*S KotlinDebug\n*F\n+ 1 NewUsersOnboardingService.kt\ncom/intellij/platform/ide/newUsersOnboarding/NewUsersOnboardingService$Companion\n*L\n108#1:113,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewUsersOnboardingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NewUsersOnboardingService> serviceClass$iv = NewUsersOnboardingService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NewUsersOnboardingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

