/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.cloudconfig.Configuration;
import com.jetbrains.cloudconfig.exception.AccessDeniedException;
import com.jetbrains.cloudconfig.exception.InvalidVersionIdException;
import com.jetbrains.cloudconfig.exception.UnauthorizedException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;

abstract class AbstractHttpClient {
    static final String OCTET_STREAM_CONTENT_TYPE = "application/octet-stream";
    static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    static final String CONTENT_TYPE_HEADER_NAME = "Content-Type";
    static final String IF_NONE_MATCH_HEADER_NAME = "If-None-Match";
    static final String ETAG_HEADER_NAME = "ETag";
    static final String VERSION_ID_HEADER_NAME = "Version-Id";
    static final String ACCEPT_ENC_HEADER_NAME = "Accept-Encoding";
    static final String CONTENT_ENC_HEADER_NAME = "Content-Encoding";
    static final String DEFLATE_METHOD_NAME = "deflate";
    static final String GZIP_METHOD_NAME = "gzip";
    static final String HTTP_GET = "GET";
    static final String HTTP_PUT = "PUT";
    static final String HTTP_DELETE = "DELETE";
    static final String HTTP_OPTIONS = "OPTIONS";
    public static final String ENCODING = "UTF-8";
    protected static final Gson GSON = new GsonBuilder().serializeNulls().create();
    protected final String endpoint;
    protected final Configuration config;

    protected AbstractHttpClient(String endpoint) {
        this(endpoint, new Configuration());
    }

    protected AbstractHttpClient(String endpoint, Configuration config) {
        if (!endpoint.matches("^https?://.*$")) {
            throw new IllegalArgumentException("Invalid protocol: " + endpoint);
        }
        if (config == null) {
            throw new IllegalArgumentException("Client configuration must be passed");
        }
        this.endpoint = endpoint.replaceFirst("/+$", "");
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T download(String method, URL url, Map<String, String> props, ResponseParser<T> parser, boolean closeStream) throws IOException {
        InputStream in;
        HttpURLConnection connection = this.config.openConnection(url);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setRequestProperty(ACCEPT_ENC_HEADER_NAME, "gzip, deflate");
        connection.setRequestMethod(method);
        try {
            in = connection.getInputStream();
        }
        catch (IOException e) {
            if (connection.getResponseCode() == 401) {
                throw new UnauthorizedException("Invalid credentials", e);
            }
            if (connection.getResponseCode() == 403) {
                throw new AccessDeniedException("Access denied for given credentials", e);
            }
            throw e;
        }
        try {
            String responseEncoding = connection.getHeaderField(CONTENT_ENC_HEADER_NAME);
            if (GZIP_METHOD_NAME.equalsIgnoreCase(responseEncoding)) {
                in = new GZIPInputStream(in);
            } else if (DEFLATE_METHOD_NAME.equalsIgnoreCase(responseEncoding)) {
                in = new DeflaterInputStream(in);
            }
            T t = parser.parse(connection.getResponseCode(), connection.getHeaderFields(), in);
            return t;
        }
        finally {
            if (closeStream) {
                this.closeSafely(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload(String method, URL url, Map<String, String> props, StreamWriter writer, ResponseParser parser, int expectedStatus) throws IOException {
        block8: {
            HttpURLConnection connection = this.config.openConnection(url);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setRequestMethod(method);
            connection.setDoOutput(true);
            OutputStream out = connection.getOutputStream();
            try {
                writer.write(out);
                this.assertSuccess(connection, expectedStatus);
                if (parser == null) break block8;
                InputStream in = null;
                try {
                    in = connection.getInputStream();
                    parser.parse(connection.getResponseCode(), connection.getHeaderFields(), in);
                }
                finally {
                    if (in != null) {
                        this.closeSafely(in);
                    }
                }
            }
            finally {
                this.closeSafely(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertSuccess(HttpURLConnection connection, int expectedStatus) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode == 401) {
            throw new UnauthorizedException("Failed to authenticate with given credentials");
        }
        if (responseCode == 403) {
            throw new AccessDeniedException("Access denied for given credentials");
        }
        if (responseCode == 417) {
            throw new InvalidVersionIdException("VersionId differs from the last available on server");
        }
        if (responseCode != expectedStatus) {
            String message = "";
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                try {
                    IOException ioException;
                    Scanner scanner = new Scanner(errorStream).useDelimiter("\\A");
                    if (scanner.hasNext()) {
                        message = scanner.next();
                    }
                    if ((ioException = scanner.ioException()) != null) {
                        System.err.println("Failed to read error message");
                        ioException.printStackTrace();
                    }
                }
                finally {
                    this.closeSafely(errorStream);
                }
            }
            throw new RuntimeException(String.format("Unexpected response (code: %s, message: %s)", responseCode, message));
        }
    }

    protected void closeSafely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close resource");
            e.printStackTrace();
        }
    }

    protected void drainStream(InputStream source, OutputStream dest) throws IOException {
        int read2;
        byte[] buf = new byte[8192];
        while ((read2 = source.read(buf)) != -1) {
            dest.write(buf, 0, read2);
        }
    }

    protected static interface StreamWriter {
        public void write(OutputStream var1) throws IOException;
    }

    protected static interface ResponseParser<T> {
        public T parse(int var1, Map<String, List<String>> var2, InputStream var3) throws IOException;
    }
}

