/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

class CoverageRowSorter
extends RowSorter<TableModel> {
    private final JBTreeTable myTreeTable;
    private final CoverageTableModel myModel;
    private RowSorter.SortKey mySortKey;

    CoverageRowSorter(JBTreeTable table, CoverageTableModel model) {
        this.myTreeTable = table;
        this.myModel = model;
    }

    @Override
    public TableModel getModel() {
        return this.myTreeTable.getTable().getModel();
    }

    @Override
    public void toggleSortOrder(int column) {
        SortOrder sortOrder = this.mySortKey != null && this.mySortKey.getColumn() == column && this.mySortKey.getSortOrder() == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
        this.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column, sortOrder)));
    }

    @Override
    public int convertRowIndexToModel(int index) {
        return index;
    }

    @Override
    public int convertRowIndexToView(int index) {
        return index;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return ContainerUtil.createMaybeSingletonList((Object)this.mySortKey);
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        RowSorter.SortKey key = keys.get(0);
        if (key.getSortOrder() == SortOrder.UNSORTED) {
            return;
        }
        CoverageLogger.logColumnSortChanged(this.myModel.getColumnName(key.getColumn()), key.getSortOrder());
        this.mySortKey = key;
        ColumnInfo columnInfo = this.myModel.getColumnInfos()[key.getColumn()];
        Comparator comparator = columnInfo.getComparator();
        if (comparator != null) {
            this.fireSortOrderChanged();
            this.myModel.setComparator(CoverageRowSorter.reverseComparator(comparator, key.getSortOrder()));
        }
    }

    @Override
    public int getViewRowCount() {
        return this.myTreeTable.getTree().getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.myTreeTable.getTree().getRowCount();
    }

    @Override
    public void modelStructureChanged() {
    }

    @Override
    public void allRowsChanged() {
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
    }

    @NotNull
    private static <T> Comparator<T> reverseComparator(@NotNull Comparator<T> comparator, SortOrder order) {
        if (comparator == null) {
            CoverageRowSorter.$$$reportNull$$$0(0);
        }
        if (order != SortOrder.DESCENDING) {
            Comparator comparator2 = comparator;
            if (comparator2 == null) {
                CoverageRowSorter.$$$reportNull$$$0(1);
            }
            return comparator2;
        }
        Comparator comparator3 = (o1, o2) -> -comparator.compare(o1, o2);
        if (comparator3 == null) {
            CoverageRowSorter.$$$reportNull$$$0(2);
        }
        return comparator3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageRowSorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageRowSorter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reverseComparator";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

