/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.elements;

import com.intellij.java.frontend.elements.FrontendJavaDocElementTypeFactory;
import com.intellij.java.frontend.parser.JavaLangLevelVirtualFileCustomDataConsumerKt;
import com.intellij.lang.impl.TokenSequence;
import com.intellij.lang.java.lexer.BasicJavaLexer;
import com.intellij.lang.java.lexer.JavaDocLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrontendJavaParserUtil {
    private FrontendJavaParserUtil() {
    }

    @NotNull
    public static TokenList obtainTokens(@NotNull PsiFile file) {
        if (file == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(0);
        }
        TokenList tokenList = (TokenList)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)TokenSequence.performLexing((CharSequence)file.getViewProvider().getContents(), (Lexer)FrontendJavaParserUtil.createLexer(FrontendJavaParserUtil.getLanguageLevel((PsiElement)file))), (Object[])new Object[]{file}));
        if (tokenList == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(1);
        }
        return tokenList;
    }

    @NotNull
    public static BasicJavaLexer createLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(2);
        }
        return new BasicJavaLexer(level, FrontendJavaDocElementTypeFactory.INSTANCE);
    }

    @NotNull
    public static JavaDocLexer createDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(3);
        }
        return new JavaDocLexer(level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        PsiFile file;
        LanguageLevel forcedLanguageLevel;
        if (element == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(4);
        }
        if ((forcedLanguageLevel = (LanguageLevel)(file = element.getContainingFile()).getUserData(LanguageLevel.FILE_LANGUAGE_LEVEL_KEY)) != null) {
            LanguageLevel languageLevel = forcedLanguageLevel;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(5);
            }
            return languageLevel;
        }
        PsiFile originalFile = file.getOriginalFile();
        forcedLanguageLevel = (LanguageLevel)originalFile.getUserData(LanguageLevel.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            LanguageLevel languageLevel = forcedLanguageLevel;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(6);
            }
            return languageLevel;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            return FrontendJavaParserUtil.getLanguageLevel(virtualFile, element.getProject());
        }
        PsiElement context = file.getContext();
        if (context != null) {
            return FrontendJavaParserUtil.getLanguageLevel(context);
        }
        return FrontendJavaParserUtil.getLanguageLevel(element.getProject());
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            return FrontendJavaParserUtil.getLanguageLevel(project);
        }
        LanguageLevel level = JavaLangLevelVirtualFileCustomDataConsumerKt.getJavaLanguageLevel(virtualFile, project);
        if (level != null) {
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                FrontendJavaParserUtil.$$$reportNull$$$0(8);
            }
            return languageLevel;
        }
        return FrontendJavaParserUtil.getLanguageLevel(project);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull Project project) {
        LanguageLevelProjectExtension instance;
        if (project == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(9);
        }
        LanguageLevel languageLevel = (instance = LanguageLevelProjectExtension.getInstance((Project)project)) != null ? instance.getLanguageLevel() : LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            FrontendJavaParserUtil.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/frontend/elements/FrontendJavaParserUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/frontend/elements/FrontendJavaParserUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainTokens";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainTokens";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLexer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocLexer";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

