/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundIconRenderer
extends GutterIconRenderer {
    @NotNull
    private final PsiElement myElement;
    private Icon myIcon;
    private final String myQName;

    public BoundIconRenderer(@NotNull PsiElement element) {
        if (element == null) {
            BoundIconRenderer.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = this.myElement = element;
        if (psiElement instanceof PsiField) {
            ComponentItem item;
            String qName;
            PsiClass componentClass;
            PsiField field = (PsiField)psiElement;
            PsiType type = field.getType();
            if (type instanceof PsiClassType && (componentClass = ((PsiClassType)type).resolve()) != null && (qName = componentClass.getQualifiedName()) != null && (item = Palette.getInstance(this.myElement.getProject()).getItem(qName)) != null) {
                this.myIcon = item.getIcon();
            }
            this.myQName = field.getContainingClass().getQualifiedName() + "#" + field.getName();
        } else {
            this.myQName = ((PsiClass)element).getQualifiedName();
        }
    }

    @NotNull
    public Icon getIcon() {
        if (this.myIcon != null) {
            Icon icon = this.myIcon;
            if (icon == null) {
                BoundIconRenderer.$$$reportNull$$$0(1);
            }
            return icon;
        }
        Icon icon = PlatformIcons.UI_FORM_ICON;
        if (icon == null) {
            BoundIconRenderer.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                List<PsiFile> formFiles;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(formFiles = BoundIconRenderer.this.getBoundFormFiles()).isEmpty()) {
                    VirtualFile virtualFile = formFiles.get(0).getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    Project project = BoundIconRenderer.this.myElement.getProject();
                    FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
                    if (BoundIconRenderer.this.myElement instanceof PsiField) {
                        for (FileEditor editor : editors) {
                            if (!(editor instanceof UIFormEditor)) continue;
                            ((UIFormEditor)editor).selectComponent(((PsiField)BoundIconRenderer.this.myElement).getName());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/binding/BoundIconRenderer$1", "actionPerformed"));
            }
        };
    }

    @Nullable
    public String getTooltipText() {
        List<PsiFile> formFiles = this.getBoundFormFiles();
        if (!formFiles.isEmpty()) {
            return BoundIconRenderer.composeText(formFiles);
        }
        return super.getTooltipText();
    }

    private List<PsiFile> getBoundFormFiles() {
        List<PsiFile> formFiles = Collections.emptyList();
        PsiClass aClass = this.myElement instanceof PsiField ? ((PsiField)this.myElement).getContainingClass() : (PsiClass)this.myElement;
        if (aClass != null && aClass.getQualifiedName() != null) {
            formFiles = FormClassIndex.findFormsBoundToClass(aClass.getProject(), aClass);
        }
        return formFiles;
    }

    @NlsSafe
    private static String composeText(List<PsiFile> formFiles) {
        @NonNls StringBuilder result = new StringBuilder("<html><body>");
        result.append(UIDesignerBundle.message("ui.is.bound.header", new Object[0]));
        @NonNls String sep = "";
        for (PsiFile file : formFiles) {
            result.append(sep);
            sep = "<br>";
            result.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            result.append(file.getName());
        }
        result.append("</body></html>");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BoundIconRenderer that = (BoundIconRenderer)((Object)o);
        if (!this.myQName.equals(that.myQName)) {
            return false;
        }
        return !(this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null);
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/binding/BoundIconRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/binding/BoundIconRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

