/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceMutateService;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpressionImpl;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0004J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0015H\u0014J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0015H\u0016J\f\u0010%\u001a\u00020\u000f*\u00020&H\u0002R\u0011\u0010\b\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "expression", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtElement;", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "getCanonicalText", "", "canRename", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "bindToElement", "getKtReferenceMutateService", "Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "getVariants", "", "()[Ljava/lang/Object;", "isSoft", "toString", "canBeReferenceTo", "candidateTarget", "isReferenceToImportAlias", "alias", "Lorg/jetbrains/kotlin/psi/KtImportAlias;", "isReferenceTo", "isAccessorReference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "kt-references"})
@SourceDebugExtension(value={"SMAP\nKtReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReference.kt\norg/jetbrains/kotlin/idea/references/AbstractKtReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,137:1\n1863#2,2:138\n1863#2,2:140\n1755#2,3:142\n1755#2,2:145\n1757#2:148\n146#3:147\n*S KotlinDebug\n*F\n+ 1 KtReference.kt\norg/jetbrains/kotlin/idea/references/AbstractKtReference\n*L\n95#1:138,2\n106#1:140,2\n116#1:142,3\n120#1:145,2\n120#1:148\n122#1:147\n*E\n"})
public abstract class AbstractKtReference<T extends KtElement>
extends PsiPolyVariantReferenceBase<T>
implements KtReference {
    public AbstractKtReference(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public final T getExpression() {
        return (T)((KtElement)this.getElement());
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((PsiElement)this.getExpression()).getProject()).resolveWithCaching((PsiPolyVariantReference)this, this.getResolver(), false, incompleteCode);
        Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"resolveWithCaching(...)");
        return resolveResultArray;
    }

    @NotNull
    public String getCanonicalText() {
        String string2 = ((PsiElement)this.getExpression()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return string2;
    }

    public boolean canRename() {
        return false;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        return this.canRename() ? this.getKtReferenceMutateService().handleElementRename(this, newElementName) : null;
    }

    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getKtReferenceMutateService().bindToElement(this, element);
    }

    @NotNull
    protected final KtReferenceMutateService getKtReferenceMutateService() {
        KtReferenceMutateService ktReferenceMutateService = (KtReferenceMutateService)ApplicationManager.getApplication().getService(KtReferenceMutateService.class);
        if (ktReferenceMutateService == null) {
            throw new IllegalStateException("Cannot handle element rename because KtReferenceMutateService is missing");
        }
        return ktReferenceMutateService;
    }

    @NotNull
    public Object[] getVariants() {
        return PsiReference.EMPTY_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ((PsiElement)this.getExpression()).getText();
    }

    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
        return true;
    }

    protected boolean isReferenceToImportAlias(@NotNull KtImportAlias alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement candidateTarget) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)candidateTarget, (String)"candidateTarget");
        if (!this.canBeReferenceTo(candidateTarget)) {
            return false;
        }
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped(candidateTarget);
        psiElement2 = psiElement2;
        if (psiElement == null) return false;
        if ((psiElement2 = psiElement2.getOriginalElement()) == null) {
            return false;
        }
        PsiElement unwrappedCandidate = psiElement2;
        AbstractKtReference abstractKtReference = this;
        if (abstractKtReference instanceof KtInvokeFunctionReference) {
            if (!(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof PsiMethod)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((PsiNamedElement)candidateTarget).getName(), (Object)OperatorNameConventions.INVOKE.asString())) {
                return false;
            }
        } else if (abstractKtReference instanceof KtDestructuringDeclarationReference ? !(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof KtParameter) && !(candidateTarget instanceof PsiMethod) : abstractKtReference instanceof KtSimpleNameReference && unwrappedCandidate instanceof PsiMethod && this.isAccessorReference((KtSimpleNameReference)this) && !LightClassUtilsKt.getCanHaveSyntheticAccessors((PsiMethod)unwrappedCandidate)) {
            return false;
        }
        KtElement element = (KtElement)this.getElement();
        if (candidateTarget instanceof KtImportAlias) {
            if (element instanceof KtSimpleNameExpression) {
                if (Intrinsics.areEqual((Object)((KtSimpleNameExpression)element).getReferencedName(), (Object)((KtImportAlias)candidateTarget).getName())) return this.isReferenceToImportAlias((KtImportAlias)candidateTarget);
            }
            if (this instanceof KDocReference && Intrinsics.areEqual((Object)((KDocReference)this).getCanonicalText(), (Object)((KtImportAlias)candidateTarget).getName())) {
                return this.isReferenceToImportAlias((KtImportAlias)candidateTarget);
            }
        }
        if (element instanceof KtLabelReferenceExpression) {
            PsiElement it;
            Iterable $this$forEach$iv;
            PsiElement psiElement3;
            PsiElement psiElement4 = ((KtSimpleNameExpressionImpl)element).getParent();
            KtContainerNode ktContainerNode = psiElement4 instanceof KtContainerNode ? (KtContainerNode)psiElement4 : null;
            Object object = psiElement3 = ktContainerNode != null ? ktContainerNode.getParent() : null;
            if (psiElement3 instanceof KtReturnExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets((PsiReference)this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object calleeReference;
                    CharSequence charSequence;
                    it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || !((charSequence = (CharSequence)((KtNamedFunction)it).getName()) == null || charSequence.length() == 0))) continue;
                    KtFunction cfr_ignored_0 = (KtFunction)it;
                    KtLabeledExpression ktLabeledExpression = KtPsiUtilKt.getLabeledParent((KtExpression)it, ((KtSimpleNameExpressionImpl)element).getReferencedName());
                    if (ktLabeledExpression != null) {
                        if (!Intrinsics.areEqual((Object)candidateTarget, (Object)ktLabeledExpression)) continue;
                        return true;
                    }
                    Object object2 = ReferenceUtilsKt.getCalleeByLambdaArgument((KtFunction)it);
                    if (object2 == null) continue;
                    if ((object2 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)object2)) == null || !((KtSimpleNameReference)(calleeReference = object2)).isReferenceTo(candidateTarget)) continue;
                    return true;
                }
            } else if (psiElement3 instanceof KtBreakExpression || psiElement3 instanceof KtContinueExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets((PsiReference)this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtExpression ktExpression;
                    it = (PsiElement)element$iv;
                    boolean bl4 = false;
                    KtExpression ktExpression2 = it instanceof KtExpression ? (KtExpression)it : null;
                    if (ktExpression2 == null) continue;
                    if ((ktExpression2 = KtPsiUtilKt.getLabeledParent(ktExpression2, ((KtSimpleNameExpressionImpl)element).getReferencedName())) == null || !Intrinsics.areEqual((Object)candidateTarget, (Object)(ktExpression = ktExpression2))) continue;
                    return true;
                }
            }
        }
        Set<PsiElement> targets = ReferenceUtilsKt.getUnwrappedTargets((PsiReference)this);
        PsiManager manager = candidateTarget.getManager();
        Iterable $this$any$iv = targets;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl5 = false;
                if (!manager.areElementsEquivalent(unwrappedCandidate, it)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        $this$any$iv = targets;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            PsiElement it = (PsiElement)element$iv;
            boolean bl6 = false;
            if (ReferenceUtilsKt.isConstructorOf(it, unwrappedCandidate)) return true;
            if (it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion()) {
                PsiElement $this$getNonStrictParentOfType$iv = it;
                boolean $i$f$getNonStrictParentOfType = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClass.class, (boolean)false), (Object)unwrappedCandidate)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccessorReference(KtSimpleNameReference $this$isAccessorReference) {
        if ($this$isAccessorReference.getElement() instanceof KtOperationReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallableReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallExpression) return false;
        PsiElement psiElement = $this$isAccessorReference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        if (KtPsiUtilKt.isInImportDirective((KtExpression)psiElement)) return false;
        return true;
    }
}

