/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.OutputBuilder;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper;", "", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/openapi/Disposable;)V", "contentChangedAlarm", "Lcom/intellij/util/Alarm;", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputListener;", "scheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "useExtendedDelayOnce", "", "addListener", "", "listener", "onContentChanged", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandOutputScraper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandOutputScraper.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper\n+ 2 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n1#1,218:1\n160#2,7:219\n*S KotlinDebug\n*F\n+ 1 ShellCommandOutputScraper.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper\n*L\n66#1:219,7\n*E\n"})
public final class ShellCommandOutputScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final List<ShellCommandOutputListener> listeners;
    @NotNull
    private final Alarm contentChangedAlarm;
    @NotNull
    private final AtomicBoolean scheduled;
    private volatile boolean useExtendedDelayOnce;

    public ShellCommandOutputScraper(@NotNull BlockTerminalSession session2, @NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session = session2;
        this.listeners = new CopyOnWriteArrayList();
        this.contentChangedAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.scheduled = new AtomicBoolean(false);
        TerminalUtil.addModelListener(textBuffer, parentDisposable, () -> ShellCommandOutputScraper._init_$lambda$0(this));
    }

    public ShellCommandOutputScraper(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2, session2.getModel().getTextBuffer$intellij_terminal(), session2);
    }

    public final void addListener(@NotNull ShellCommandOutputListener listener, @NotNull Disposable parentDisposable, boolean useExtendedDelayOnce) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.listeners, listener, parentDisposable);
        this.useExtendedDelayOnce = useExtendedDelayOnce;
    }

    public static /* synthetic */ void addListener$default(ShellCommandOutputScraper shellCommandOutputScraper, ShellCommandOutputListener shellCommandOutputListener, Disposable disposable, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        shellCommandOutputScraper.addListener(shellCommandOutputListener, disposable, bl);
    }

    private final void onContentChanged() {
        if (!((Collection)this.listeners).isEmpty() && this.scheduled.compareAndSet(false, true)) {
            Function0 request2 = (Function0)new Function0<Unit>(this){
                final /* synthetic */ ShellCommandOutputScraper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandOutputScraper.access$getScheduled$p(this.this$0).set(false);
                    if (!((Collection)ShellCommandOutputScraper.access$getListeners$p(this.this$0)).isEmpty()) {
                        StyledCommandOutput output = this.this$0.scrapeOutput();
                        for (ShellCommandOutputListener listener : ShellCommandOutputScraper.access$getListeners$p(this.this$0)) {
                            listener.commandOutputChanged(output);
                        }
                    }
                }
            };
            int delay = this.useExtendedDelayOnce ? 150 : 50;
            this.useExtendedDelayOnce = false;
            this.contentChangedAlarm.addRequest(() -> ShellCommandOutputScraper.onContentChanged$lambda$1(request2), delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StyledCommandOutput scrapeOutput() {
        StyledCommandOutput styledCommandOutput;
        TerminalModel this_$iv = this.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            styledCommandOutput = Companion.scrapeOutput(this.session);
        }
        finally {
            this_$iv.unlockContent();
        }
        return styledCommandOutput;
    }

    private static final void _init_$lambda$0(ShellCommandOutputScraper this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onContentChanged();
    }

    private static final void onContentChanged$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ AtomicBoolean access$getScheduled$p(ShellCommandOutputScraper $this) {
        return $this.scheduled;
    }

    public static final /* synthetic */ List access$getListeners$p(ShellCommandOutputScraper $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper$Companion;", "", "()V", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "commandEndMarker", "", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull BlockTerminalSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return this.scrapeOutput(session2.getModel().getTextBuffer$intellij_terminal(), session2.getCommandBlockIntegration().getCommandEndMarker());
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull TerminalTextBuffer textBuffer, @Nullable String commandEndMarker) {
            Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
            OutputBuilder outputBuilder = new OutputBuilder(commandEndMarker);
            if (!textBuffer.isUsingAlternateBuffer()) {
                LinesBuffer linesBuffer = textBuffer.getHistoryBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)linesBuffer, (String)"getHistoryBuffer(...)");
                outputBuilder.addLines(linesBuffer);
            }
            LinesBuffer linesBuffer = textBuffer.getScreenBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)linesBuffer, (String)"getScreenBuffer(...)");
            outputBuilder.addLines(linesBuffer);
            return outputBuilder.build();
        }

        public static /* synthetic */ StyledCommandOutput scrapeOutput$default(Companion companion, TerminalTextBuffer terminalTextBuffer, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.scrapeOutput(terminalTextBuffer, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

