/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.GeneratorFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandEndMarkerListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.StartedCommand;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010%\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010&\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010'\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010(\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002J\u0016\u0010)\u001a\u00020\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "startedCommand", "Lorg/jetbrains/plugins/terminal/block/session/StartedCommand;", "addListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "clearTerminal", "fireClearInvoked", "fireCommandFinished", "exitCode", "", "fireCommandHistoryReceived", "history", "", "fireCommandStarted", "fireGeneratorFinished", "requestId", "result", "fireInitialized", "rawShellInfo", "firePromptShown", "firePromptStateUpdated", "state", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "fireShellEditorBufferReported", "event", "", "processCommandFinishedEvent", "processCommandHistoryEvent", "processCommandStartedEvent", "processGeneratorFinishedEvent", "processInitialized", "processPromptStateUpdatedEvent", "Companion", "Param", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager\n+ 2 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,308:1\n217#2,2:309\n219#2:315\n217#2,2:316\n219#2:322\n217#2,2:323\n219#2:329\n217#2,2:330\n219#2:336\n217#2,2:337\n219#2:343\n217#2,2:344\n219#2:350\n217#2,2:351\n219#2:357\n217#2,2:358\n219#2:364\n217#2,2:365\n219#2:371\n217#2,2:372\n219#2:378\n217#2,2:379\n219#2:385\n217#2,2:386\n219#2:392\n217#2,2:393\n219#2:399\n59#3,4:311\n59#3,4:318\n59#3,4:325\n59#3,4:332\n59#3,4:339\n59#3,4:346\n59#3,4:353\n59#3,4:360\n59#3,4:367\n59#3,4:374\n59#3,4:381\n59#3,4:388\n59#3,4:395\n13#3:400\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager\n*L\n48#1:309,2\n48#1:315\n70#1:316,2\n70#1:322\n107#1:323,2\n107#1:329\n131#1:330,2\n131#1:336\n137#1:337,2\n137#1:343\n146#1:344,2\n146#1:350\n153#1:351,2\n153#1:357\n165#1:358,2\n165#1:364\n177#1:365,2\n177#1:371\n181#1:372,2\n181#1:378\n189#1:379,2\n189#1:385\n196#1:386,2\n196#1:392\n204#1:393,2\n204#1:399\n48#1:311,4\n70#1:318,4\n107#1:325,4\n131#1:332,4\n137#1:339,4\n146#1:346,4\n153#1:353,4\n165#1:360,4\n177#1:367,4\n181#1:374,4\n189#1:381,4\n196#1:388,4\n204#1:395,4\n215#1:400\n*E\n"})
public final class ShellCommandManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final CopyOnWriteArrayList<ShellCommandListener> listeners;
    @Nullable
    private volatile StartedCommand startedCommand;
    @NotNull
    private static final Logger LOG;

    public ShellCommandManager(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.listeners = new CopyOnWriteArrayList();
        this.session.getController$intellij_terminal().addCustomCommandListener(arg_0 -> ShellCommandManager._init_$lambda$0(this, arg_0));
    }

    private final void processInitialized(List<String> event) {
        String shellInfo;
        String string = Param.SHELL_INFO.getDecodedValueOrNull((String)CollectionsKt.getOrNull(event, (int)1));
        if (string == null) {
            string = shellInfo = "{}";
        }
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received initialized event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this, shellInfo){
                final /* synthetic */ ShellCommandManager this$0;
                final /* synthetic */ String $shellInfo;
                {
                    this.this$0 = $receiver;
                    this.$shellInfo = $shellInfo;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireInitialized(this.this$0, this.$shellInfo);
                }
            }));
        } else {
            this.fireInitialized(shellInfo);
        }
    }

    private final void processCommandStartedEvent(List<String> event) {
        StartedCommand startedCommand;
        String command2 = Param.COMMAND.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String currentDirectory = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        this.startedCommand = startedCommand = new StartedCommand(command2, currentDirectory, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        this.fireCommandStarted(startedCommand);
    }

    private final void processCommandFinishedEvent(List<String> event) {
        int exitCode = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        StartedCommand startedCommand = this.startedCommand;
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received command_finished event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this, startedCommand, exitCode){
                final /* synthetic */ ShellCommandManager this$0;
                final /* synthetic */ StartedCommand $startedCommand;
                final /* synthetic */ int $exitCode;
                {
                    this.this$0 = $receiver;
                    this.$startedCommand = $startedCommand;
                    this.$exitCode = $exitCode;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireCommandFinished(this.this$0, this.$startedCommand, this.$exitCode);
                    ShellCommandManager.access$setStartedCommand$p(this.this$0, null);
                }
            }));
        } else {
            this.fireCommandFinished(startedCommand, exitCode);
            this.startedCommand = null;
        }
    }

    private final void processPromptStateUpdatedEvent(List<String> event) {
        String string = Param.CURRENT_DIRECTORY.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        String string2 = Param.USER_NAME.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)2));
        String string3 = Param.USER_HOME.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)3));
        String string4 = Param.GIT_BRANCH.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)4));
        String string5 = Param.VIRTUAL_ENV.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)5));
        String string6 = Param.CONDA_ENV.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)6));
        String string7 = Param.ORIGINAL_PROMPT.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)7));
        String string8 = Param.ORIGINAL_RIGHT_PROMPT.getDecodedNotEmptyValueOrNull((String)CollectionsKt.getOrNull(event, (int)8));
        String string9 = this.session.getShellIntegration().getShellType().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        TerminalPromptState state = new TerminalPromptState(string, string2, string3, string4, string5, string6, string7, string8, string9);
        this.firePromptStateUpdated(state);
    }

    private final void processCommandHistoryEvent(List<String> event) {
        String history = Param.HISTORY_STRING.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        this.fireCommandHistoryReceived(history);
    }

    private final void processGeneratorFinishedEvent(List<String> event) {
        int requestId = Param.REQUEST_ID.getIntValue((String)CollectionsKt.getOrNull(event, (int)1));
        String result2 = Param.RESULT.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)2));
        int exitCode = Param.EXIT_CODE.getIntValue((String)CollectionsKt.getOrNull(event, (int)3));
        if (this.session.getCommandBlockIntegration().getCommandEndMarker() != null) {
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Received generator_finished event, waiting for command end marker", e$iv);
            }
            new ShellCommandEndMarkerListener(this.session, (Function0<Unit>)((Function0)new Function0<Unit>(this, requestId, result2, exitCode){
                final /* synthetic */ ShellCommandManager this$0;
                final /* synthetic */ int $requestId;
                final /* synthetic */ String $result;
                final /* synthetic */ int $exitCode;
                {
                    this.this$0 = $receiver;
                    this.$requestId = $requestId;
                    this.$result = $result;
                    this.$exitCode = $exitCode;
                    super(0);
                }

                public final void invoke() {
                    ShellCommandManager.access$fireGeneratorFinished(this.this$0, this.$requestId, this.$result, this.$exitCode);
                }
            }));
        } else {
            this.fireGeneratorFinished(requestId, result2, exitCode);
        }
    }

    private final void clearTerminal() {
        block1: {
            TerminalStarter terminalStarter = this.session.getTerminalStarterFuture$intellij_terminal().getNow(null);
            if (terminalStarter == null) break block1;
            TerminalStarter it = terminalStarter;
            boolean bl = false;
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl2 = false;
                logger.debug("force clearing terminal", e$iv);
            }
            TerminalModel terminalModel = this.session.getModel();
            Terminal terminal = it.getTerminal();
            Intrinsics.checkNotNullExpressionValue((Object)terminal, (String)"getTerminal(...)");
            terminalModel.clearAllAndMoveCursorToTopLeftCorner$intellij_terminal(terminal);
        }
    }

    private final void fireInitialized(String rawShellInfo) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: initialized. Shell info: " + rawShellInfo, e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.shellInfoReceived(rawShellInfo);
            listener.initialized();
        }
        this.clearTerminal();
    }

    private final void firePromptShown() {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: prompt_shown", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.promptShown();
        }
    }

    private final void fireCommandStarted(StartedCommand startedCommand) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: command_started - " + startedCommand, e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandStarted(startedCommand.getCommand());
        }
    }

    private final void fireCommandFinished(StartedCommand startedCommand, int exitCode) {
        if (startedCommand == null) {
            LOG.info("Shell event: received command_finished without preceding command_started - skipping");
        } else {
            CommandFinishedEvent event = new CommandFinishedEvent(startedCommand.getCommand(), exitCode, startedCommand.getCommandStarted().elapsedNow-UwyO8pc(), null);
            Companion $this$iv = Companion;
            Throwable e$iv = null;
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                boolean bl = false;
                logger.debug("Shell event: command_finished - " + event, e$iv);
            }
            for (ShellCommandListener listener : this.listeners) {
                listener.commandFinished(event);
            }
        }
        this.clearTerminal();
    }

    private final void firePromptStateUpdated(TerminalPromptState state) {
        for (ShellCommandListener listener : this.listeners) {
            listener.promptStateUpdated(state);
        }
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Prompt state updated: " + state, e$iv);
        }
    }

    private final void fireCommandHistoryReceived(String history) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: command_history of " + history.length() + " size", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandHistoryReceived(history);
        }
    }

    private final void fireShellEditorBufferReported(List<String> event) {
        String buffer = Param.SHELL_EDITOR_BUFFER.getDecodedValue((String)CollectionsKt.getOrNull(event, (int)1));
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: shell_editor_buffer_reported of " + buffer.length() + " size", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.commandBufferReceived(buffer);
        }
    }

    private final void fireGeneratorFinished(int requestId, String result2, int exitCode) {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: generator_finished with requestId " + requestId + " and result of " + result2.length() + " size", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.generatorFinished(new GeneratorFinishedEvent(requestId, result2, exitCode));
        }
        this.clearTerminal();
    }

    private final void fireClearInvoked() {
        Companion $this$iv = Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Shell event: clear_invoked", e$iv);
        }
        for (ShellCommandListener listener : this.listeners) {
            listener.clearInvoked();
        }
    }

    public final void addListener(@NotNull ShellCommandListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem((List)this.listeners, listener, parentDisposable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void _init_$lambda$0(ShellCommandManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            String string = (String)CollectionsKt.getOrNull((List)it, (int)0);
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 424089318: {
                        if (!string.equals("command_finished")) break;
                        n = 1;
                        break;
                    }
                    case -779416838: {
                        if (!string.equals("clear_invoked")) break;
                        n = 2;
                        break;
                    }
                    case -1808601184: {
                        if (!string.equals("command_history")) break;
                        n = 3;
                        break;
                    }
                    case -337753203: {
                        if (!string.equals("command_started")) break;
                        n = 4;
                        break;
                    }
                    case -872176010: {
                        if (!string.equals("prompt_shown")) break;
                        n = 5;
                        break;
                    }
                    case 140169743: {
                        if (!string.equals("shell_editor_buffer_reported")) break;
                        n = 6;
                        break;
                    }
                    case -268905378: {
                        if (!string.equals("generator_finished")) break;
                        n = 7;
                        break;
                    }
                    case 1234020052: {
                        if (!string.equals("initialized")) break;
                        n = 8;
                        break;
                    }
                    case 1940723570: {
                        if (!string.equals("prompt_state_updated")) break;
                        n = 9;
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        this$0.processInitialized(it);
                        return;
                    }
                    case 5: {
                        this$0.firePromptShown();
                        return;
                    }
                    case 4: {
                        this$0.processCommandStartedEvent(it);
                        return;
                    }
                    case 1: {
                        this$0.processCommandFinishedEvent(it);
                        return;
                    }
                    case 9: {
                        this$0.processPromptStateUpdatedEvent(it);
                        return;
                    }
                    case 3: {
                        this$0.processCommandHistoryEvent(it);
                        return;
                    }
                    case 6: {
                        this$0.fireShellEditorBufferReported(it);
                        return;
                    }
                    case 7: {
                        this$0.processGeneratorFinishedEvent(it);
                        return;
                    }
                    case 2: {
                        this$0.fireClearInvoked();
                        return;
                    }
                }
            }
            LOG.warn("Unknown custom command: " + it);
            return;
        }
        catch (Throwable t) {
            LOG.warn("Error while processing custom command: " + it, t);
        }
    }

    public static final /* synthetic */ void access$fireInitialized(ShellCommandManager $this, String rawShellInfo) {
        $this.fireInitialized(rawShellInfo);
    }

    public static final /* synthetic */ void access$fireCommandFinished(ShellCommandManager $this, StartedCommand startedCommand, int exitCode) {
        $this.fireCommandFinished(startedCommand, exitCode);
    }

    public static final /* synthetic */ void access$setStartedCommand$p(ShellCommandManager $this, StartedCommand startedCommand) {
        $this.startedCommand = startedCommand;
    }

    public static final /* synthetic */ void access$fireGeneratorFinished(ShellCommandManager $this, int requestId, String result2, int exitCode) {
        $this.fireGeneratorFinished(requestId, result2, exitCode);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0011\u0010\f\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\rH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_terminal", "()Lcom/intellij/openapi/diagnostic/Logger;", "debug", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lazyMessage", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/NonNls;", "debug$intellij_terminal", "decodeHex", "hexStr", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,308:1\n59#2,4:309\n*S KotlinDebug\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n*L\n218#1:309,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_terminal() {
            return LOG;
        }

        public final void debug$intellij_terminal(@Nullable Exception e, @NotNull Function0<String> lazyMessage) {
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv = this.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
            }
        }

        public static /* synthetic */ void debug$intellij_terminal$default(Companion $this, Exception e, Function0 lazyMessage, int n, Object object) {
            if ((n & 1) != 0) {
                e = null;
            }
            Intrinsics.checkNotNullParameter((Object)lazyMessage, (String)"lazyMessage");
            boolean $i$f$debug$intellij_terminal = false;
            Logger $this$debug$iv = $this.getLOG$intellij_terminal();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                $this$debug$iv.debug((String)lazyMessage.invoke(), (Throwable)e);
            }
        }

        private final String decodeHex(String hexStr) throws IllegalArgumentException {
            byte[] bytes = HexFormat.of().parseHex(hexStr);
            Intrinsics.checkNotNull((Object)bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0012\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\n\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Param;", "", "(Ljava/lang/String;I)V", "paramNameWithSeparator", "", "fail", "T", "()Ljava/lang/Object;", "getDecodedNotEmptyValueOrNull", "nameAndValue", "getDecodedValue", "getDecodedValueOrNull", "getIntValue", "", "getValueOrNull", "paramName", "EXIT_CODE", "COMMAND", "HISTORY_STRING", "REQUEST_ID", "RESULT", "CURRENT_DIRECTORY", "USER_NAME", "USER_HOME", "GIT_BRANCH", "VIRTUAL_ENV", "CONDA_ENV", "SHELL_EDITOR_BUFFER", "ORIGINAL_PROMPT", "ORIGINAL_RIGHT_PROMPT", "SHELL_INFO", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Param\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1#2:309\n*E\n"})
    private static final class Param
    extends Enum<Param> {
        @NotNull
        private final String paramNameWithSeparator = this.paramName() + "=";
        public static final /* enum */ Param EXIT_CODE = new Param();
        public static final /* enum */ Param COMMAND = new Param();
        public static final /* enum */ Param HISTORY_STRING = new Param();
        public static final /* enum */ Param REQUEST_ID = new Param();
        public static final /* enum */ Param RESULT = new Param();
        public static final /* enum */ Param CURRENT_DIRECTORY = new Param();
        public static final /* enum */ Param USER_NAME = new Param();
        public static final /* enum */ Param USER_HOME = new Param();
        public static final /* enum */ Param GIT_BRANCH = new Param();
        public static final /* enum */ Param VIRTUAL_ENV = new Param();
        public static final /* enum */ Param CONDA_ENV = new Param();
        public static final /* enum */ Param SHELL_EDITOR_BUFFER = new Param();
        public static final /* enum */ Param ORIGINAL_PROMPT = new Param();
        public static final /* enum */ Param ORIGINAL_RIGHT_PROMPT = new Param();
        public static final /* enum */ Param SHELL_INFO = new Param();
        private static final /* synthetic */ Param[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private final String paramName() {
            String string = this.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public final int getIntValue(@Nullable String nameAndValue) {
            Object object = this.getValueOrNull(nameAndValue);
            return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? ((Integer)object).intValue() : ((Number)this.fail()).intValue();
        }

        @NotNull
        public final String getDecodedValue(@Nullable String nameAndValue) {
            String string = this.getDecodedValueOrNull(nameAndValue);
            if (string == null) {
                string = (String)this.fail();
            }
            return string;
        }

        @Nullable
        public final String getDecodedNotEmptyValueOrNull(@Nullable String nameAndValue) {
            String string;
            String string2 = this.getDecodedValueOrNull(nameAndValue);
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                string = ((CharSequence)it).length() > 0 ? string3 : null;
            } else {
                string = null;
            }
            return string;
        }

        @Nullable
        public final String getDecodedValueOrNull(@Nullable String nameAndValue) {
            String string = this.getValueOrNull(nameAndValue);
            if (string == null) {
                return null;
            }
            String encodedValue = string;
            return Companion.decodeHex(encodedValue);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getValueOrNull(String nameAndValue) {
            String string;
            String string2 = nameAndValue;
            String string3 = string2;
            if (string2 == null) return null;
            String it = string = string3;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)this.paramNameWithSeparator, (boolean)false, (int)2, null)) return null;
            String string4 = string;
            string3 = string4;
            if (string4 == null) return null;
            String string5 = string3.substring(this.paramNameWithSeparator.length());
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string6;
        }

        private final <T> T fail() {
            throw new IllegalStateException("Cannot parse " + this.paramName());
        }

        public static Param[] values() {
            return (Param[])$VALUES.clone();
        }

        public static Param valueOf(String value) {
            return Enum.valueOf(Param.class, value);
        }

        @NotNull
        public static EnumEntries<Param> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paramArray = new Param[]{Param.EXIT_CODE, Param.COMMAND, Param.HISTORY_STRING, Param.REQUEST_ID, Param.RESULT, Param.CURRENT_DIRECTORY, Param.USER_NAME, Param.USER_HOME, Param.GIT_BRANCH, Param.VIRTUAL_ENV, Param.CONDA_ENV, Param.SHELL_EDITOR_BUFFER, Param.ORIGINAL_PROMPT, Param.ORIGINAL_RIGHT_PROMPT, Param.SHELL_INFO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

