/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.block.completion.TerminalInlineCompletion;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.block.history.CommandSearchPresenter;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptView;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorStateListener;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorUtil;
import org.jetbrains.plugins.terminal.block.prompt.lang.TerminalPromptLanguage;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.ui.TerminalUi;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00016B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020\u0015H\u0002J\b\u00103\u001a\u00020+H\u0016J\n\u00104\u001a\u0006\u0012\u0002\b\u00030)J\u0014\u00105\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010&\u001a\u00020'H\u0003R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u0006\u0012\u0002\b\u00030)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController$PromptStateListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/TerminalCommandExecutor;)V", "charSize", "Ljava/awt/geom/Dimension2D;", "getCharSize", "()Ljava/awt/geom/Dimension2D;", "commandHistoryPresenter", "Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter;", "commandSearchPresenter", "Lorg/jetbrains/plugins/terminal/block/history/CommandSearchPresenter;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "getController", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "preferredFocusableComponent", "getPreferredFocusableComponent", "promptPanel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView$TerminalPromptPanel;", "terminalWidth", "", "getTerminalWidth", "()I", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "toolbarSizeInitializedFuture", "Ljava/util/concurrent/CompletableFuture;", "commandHistoryStateChanged", "", "showing", "", "commandSearchRequested", "createPromptTextField", "Lcom/intellij/ui/LanguageTextField;", "createToolbar", "targetComponent", "dispose", "getTerminalWidthInitializedFuture", "scheduleToolbarUpdate", "TerminalPromptPanel", "intellij.terminal"})
public final class TerminalPromptView
implements TerminalPromptController.PromptStateListener,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalPromptController controller;
    @NotNull
    private final TerminalPromptPanel promptPanel;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final CommandHistoryPresenter commandHistoryPresenter;
    @NotNull
    private final CommandSearchPresenter commandSearchPresenter;
    @NotNull
    private final ActionToolbar toolbar;
    @NotNull
    private final CompletableFuture<?> toolbarSizeInitializedFuture;

    public TerminalPromptView(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull BlockTerminalSession session2, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.settings = settings;
        LanguageTextField editorTextField = this.createPromptTextField(session2);
        EditorEx editorEx = editorTextField.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        this.editor = (EditorImpl)editorEx;
        this.controller = new TerminalPromptController(this.project, (EditorEx)this.editor, session2, commandExecutor);
        this.controller.addListener(this);
        this.commandHistoryPresenter = new CommandHistoryPresenter(this.project, (Editor)this.editor, this.controller);
        this.commandSearchPresenter = new CommandSearchPresenter(this.project, (Editor)this.editor, this.controller.getModel());
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        this.toolbar = this.createToolbar((JComponent)editorComponentImpl);
        this.toolbarSizeInitializedFuture = this.scheduleToolbarUpdate(this.toolbar);
        JComponent jComponent = (JComponent)editorTextField;
        JComponent jComponent2 = this.toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        this.promptPanel = new TerminalPromptPanel(jComponent, jComponent2);
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)11, (int)19, (int)12, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        JBEmptyBorder innerBorder = jBEmptyBorder;
        Color color = TerminalUi.INSTANCE.promptSeparatorColor((Editor)this.editor);
        JBInsets jBInsets = new JBInsets(1, 0, 0, 0);
        CustomLineBorder outerBorder2 = new CustomLineBorder(color, jBInsets){

            public void paintBorder(@NotNull Component c, @Nullable Graphics g, int x, int y, int w, int h) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                if (c.getY() != 0) {
                    super.paintBorder(c, g, x, y, w, h);
                }
            }
        };
        this.promptPanel.setBorder(JBUI.Borders.compound((Border)((Border)outerBorder2), (Border)((Border)innerBorder)));
        this.promptPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@Nullable MouseEvent e) {
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)editor.getContentComponent(), true);
            }
        });
        this.controller.getModel().addErrorStateListener(new TerminalPromptErrorStateListener(){

            @Override
            public void errorStateChanged(@Nullable TerminalPromptErrorDescription description2) {
                JComponent jComponent;
                if (description2 != null) {
                    EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
                    jComponent = TerminalPromptErrorUtil.INSTANCE.createErrorComponent(description2, editorColorsScheme);
                } else {
                    jComponent = null;
                }
                JComponent errorComponent = jComponent;
                promptPanel.setBottomComponent(errorComponent);
            }
        }, this);
    }

    @NotNull
    public final TerminalPromptController getController() {
        return this.controller;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.promptPanel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"getContentComponent(...)");
        return (JComponent)editorComponentImpl;
    }

    public final int getTerminalWidth() {
        int availableWidth = this.promptPanel.getAvailableContentWidth();
        int scrollBarWidth = this.editor.getScrollPane().getVerticalScrollBar().getWidth();
        return availableWidth - scrollBarWidth;
    }

    @NotNull
    public final Dimension2D getCharSize() {
        return TerminalUiUtilsKt.getCharSize((Editor)this.editor);
    }

    @NotNull
    public final CompletableFuture<?> getTerminalWidthInitializedFuture() {
        return this.toolbarSizeInitializedFuture;
    }

    @Override
    public void commandHistoryStateChanged(boolean showing) {
        if (showing) {
            List<String> history = this.controller.getCommandHistory();
            if (!((Collection)history).isEmpty()) {
                this.commandHistoryPresenter.showCommandHistory(history);
            }
        } else {
            this.commandHistoryPresenter.onCommandHistoryClosed();
        }
    }

    @Override
    public void commandSearchRequested() {
        List<String> history = this.controller.getCommandHistory();
        if (!((Collection)history).isEmpty()) {
            this.commandSearchPresenter.showCommandSearch(history);
        }
    }

    private final LanguageTextField createPromptTextField(BlockTerminalSession session2) {
        TerminalPromptLanguage terminalPromptLanguage = TerminalPromptLanguage.INSTANCE;
        Project project = this.project;
        LanguageTextField textField2 = new LanguageTextField(terminalPromptLanguage, project){

            public void setBackground(@Nullable Color bg) {
            }

            public void updateUI() {
                super.updateUI();
                this.setFont(EditorUtil.getEditorFont());
            }
        };
        textField2.setDisposedWith((Disposable)this);
        textField2.setAlignmentX(0.0f);
        EditorEx editorEx = textField2.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor = (EditorImpl)editorEx;
        editor.getSettings().setUseSoftWraps(true);
        editor.getSettings().setShowingSpecialChars(false);
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor.setVerticalScrollbarVisible(true);
        editor.getGutterComponentEx().setPaintBackground(false);
        TerminalUi.INSTANCE.useTerminalDefaultBackground((EditorEx)editor, this);
        Project $this$createPromptTextField_u24lambda_u240 = project = editor.getColorsScheme();
        boolean bl = false;
        $this$createPromptTextField_u24lambda_u240.setEditorFontName(this.settings.getTerminalFont().getFontName());
        $this$createPromptTextField_u24lambda_u240.setEditorFontSize(this.settings.getTerminalFont().getSize());
        $this$createPromptTextField_u24lambda_u240.setLineSpacing(1.0f);
        $this$createPromptTextField_u24lambda_u240.setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        editor.getCaretModel().getPrimaryCaret().setVisualAttributes(new CaretVisualAttributes(null, CaretVisualAttributes.Weight.HEAVY));
        editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)editor.getDocument());
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            editor.setFile(it);
            it.putUserData(NavBarModelExtension.IGNORE_IN_NAVBAR, (Object)true);
        }
        if (Registry.is((String)"terminal.new.ui.inline.completion")) {
            TerminalInlineCompletion.Companion.getInstance(this.project).install((EditorEx)editor);
        }
        editor.setContextMenuGroupId("Terminal.PromptContextMenu");
        return textField2;
    }

    private final ActionToolbar createToolbar(JComponent targetComponent) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Terminal.PromptToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup toolbarGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = actionManager.createActionToolbar("TerminalPrompt", toolbarGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(targetComponent);
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setBorder((Border)JBUI.Borders.emptyRight((int)10));
        return toolbar;
    }

    @RequiresEdt
    private final CompletableFuture<?> scheduleToolbarUpdate(ActionToolbar toolbar) {
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        CheckedDisposable disposable = checkedDisposable;
        CompletableFuture future = new CompletableFuture();
        Disposer.register((Disposable)((Disposable)disposable), () -> TerminalPromptView.scheduleToolbarUpdate$lambda$2(future));
        Function0 isDisposed2 = (Function0)new Function0<Boolean>(disposable){
            final /* synthetic */ CheckedDisposable $disposable;
            {
                this.$disposable = $disposable;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$disposable.isDisposed();
            }
        };
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater((Function0<Boolean>)isDisposed2, modalityState, () -> TerminalPromptView.scheduleToolbarUpdate$lambda$4(toolbar, disposable, future, isDisposed2));
        return future;
    }

    public void dispose() {
    }

    private static final void scheduleToolbarUpdate$lambda$2(CompletableFuture $future) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (!$future.isDone()) {
            $future.completeExceptionally(new IllegalStateException("parent disposed"));
        }
    }

    private static final void scheduleToolbarUpdate$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void scheduleToolbarUpdate$lambda$4(ActionToolbar $toolbar, CheckedDisposable $disposable, CompletableFuture $future, Function0 $isDisposed) {
        Intrinsics.checkNotNullParameter((Object)$toolbar, (String)"$toolbar");
        Intrinsics.checkNotNullParameter((Object)$disposable, (String)"$disposable");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)$isDisposed, (String)"$isDisposed");
        UIUtil.markAsShowing((JComponent)$toolbar.getComponent(), (boolean)true);
        $toolbar.addListener(new ActionToolbarListener((Function0<Boolean>)$isDisposed, $future){
            final /* synthetic */ Function0<Boolean> $isDisposed;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.$isDisposed = $isDisposed;
                this.$future = $future;
            }

            public void actionsUpdated() {
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater(this.$isDisposed, modalityState, () -> scheduleToolbarUpdate.2.1.actionsUpdated$lambda$0(this.$future));
            }

            private static final void actionsUpdated$lambda$0(CompletableFuture $future) {
                Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
                $future.complete(Unit.INSTANCE);
            }
        }, (Disposable)$disposable);
        $future.whenComplete((arg_0, arg_1) -> TerminalPromptView.scheduleToolbarUpdate$lambda$4$lambda$3((Function2)new Function2<Unit, Throwable, Unit>($disposable, $toolbar){
            final /* synthetic */ CheckedDisposable $disposable;
            final /* synthetic */ ActionToolbar $toolbar;
            {
                this.$disposable = $disposable;
                this.$toolbar = $toolbar;
                super(2);
            }

            public final void invoke(Unit unit, Throwable throwable) {
                Disposer.dispose((Disposable)((Disposable)this.$disposable));
                UIUtil.markAsShowing((JComponent)this.$toolbar.getComponent(), (boolean)false);
            }
        }, arg_0, arg_1));
        $toolbar.updateActionsAsync();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView$TerminalPromptPanel;", "Ljavax/swing/JPanel;", "mainComponent", "Ljavax/swing/JComponent;", "sideComponent", "(Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "bottomComponent", "doLayout", "", "getAvailableContentWidth", "", "getPreferredSize", "Ljava/awt/Dimension;", "setBottomComponent", "component", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalPromptView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptView.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptView$TerminalPromptPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
    private static final class TerminalPromptPanel
    extends JPanel {
        @NotNull
        private final JComponent mainComponent;
        @NotNull
        private final JComponent sideComponent;
        @Nullable
        private JComponent bottomComponent;

        public TerminalPromptPanel(@NotNull JComponent mainComponent, @NotNull JComponent sideComponent) {
            Intrinsics.checkNotNullParameter((Object)mainComponent, (String)"mainComponent");
            Intrinsics.checkNotNullParameter((Object)sideComponent, (String)"sideComponent");
            super(null);
            this.mainComponent = mainComponent;
            this.sideComponent = sideComponent;
            this.setOpaque(false);
            this.add(this.mainComponent);
            this.add(this.sideComponent);
        }

        public final void setBottomComponent(@Nullable JComponent component2) {
            JComponent jComponent = this.bottomComponent;
            if (jComponent != null) {
                JComponent it = jComponent;
                boolean bl = false;
                this.remove(it);
            }
            if (component2 != null) {
                this.add(component2);
            }
            this.bottomComponent = component2;
            this.revalidate();
            this.repaint();
        }

        public final int getAvailableContentWidth() {
            return this.getWidth() - this.getInsets().left - this.getInsets().right - this.sideComponent.getPreferredSize().width;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension mainComponentSize = this.mainComponent.getPreferredSize();
            JComponent jComponent = this.bottomComponent;
            Dimension dimension = jComponent != null ? jComponent.getPreferredSize() : null;
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Dimension bottomComponentSize = dimension;
            Dimension sideComponentSize = this.sideComponent.getPreferredSize();
            Dimension size = new Dimension(mainComponentSize.width + sideComponentSize.width, mainComponentSize.height + bottomComponentSize.height);
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }

        @Override
        public void doLayout() {
            block1: {
                Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
                Dimension sidePrefSize = this.sideComponent.getPreferredSize();
                Dimension mainPrefSize = this.mainComponent.getPreferredSize();
                JComponent jComponent = this.bottomComponent;
                Dimension dimension = jComponent != null ? jComponent.getPreferredSize() : null;
                if (dimension == null) {
                    dimension = new Dimension(0, 0);
                }
                Dimension bottomPrefSize = dimension;
                int sideComponentX = Math.max(rect.x + rect.width - sidePrefSize.width, 0);
                this.sideComponent.setBounds(sideComponentX, rect.y, sidePrefSize.width, sidePrefSize.height);
                int mainHeight = Math.min(rect.height, mainPrefSize.height);
                this.mainComponent.setBounds(rect.x, rect.y, rect.width - sidePrefSize.width, mainHeight);
                int bottomHeight = Math.min(rect.height - mainHeight, bottomPrefSize.height);
                JComponent jComponent2 = this.bottomComponent;
                if (jComponent2 == null) break block1;
                jComponent2.setBounds(rect.x, rect.y + mainHeight, rect.width, bottomHeight);
            }
        }
    }
}

