/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import com.google.gson.annotations.JsonAdapter;
import org.eclipse.lsp4j.debug.adapters.RestartArgumentsArgumentsTypeAdapter;
import org.eclipse.lsp4j.debug.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

/**
 * Arguments for 'restart' request.
 */
@SuppressWarnings("all")
public class RestartArguments {
  /**
   * The latest version of the 'launch' or 'attach' configuration.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  @JsonAdapter(RestartArgumentsArgumentsTypeAdapter.class)
  private Either<LaunchRequestArguments, AttachRequestArguments> arguments;

  /**
   * The latest version of the 'launch' or 'attach' configuration.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  public Either<LaunchRequestArguments, AttachRequestArguments> getArguments() {
    return this.arguments;
  }

  /**
   * The latest version of the 'launch' or 'attach' configuration.
   * <p>
   * This is an optional property.
   * <p>
   * Since 1.47
   */
  public void setArguments(final Either<LaunchRequestArguments, AttachRequestArguments> arguments) {
    this.arguments = arguments;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("arguments", this.arguments);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    RestartArguments other = (RestartArguments) obj;
    if (this.arguments == null) {
      if (other.arguments != null)
        return false;
    } else if (!this.arguments.equals(other.arguments))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.arguments== null) ? 0 : this.arguments.hashCode());
  }
}
