/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.util.ReflectionUtilRt;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenBuildBase;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenModelBase;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfile;
import org.jetbrains.idea.maven.model.MavenProfileActivation;
import org.jetbrains.idea.maven.model.MavenProfileActivationFile;
import org.jetbrains.idea.maven.model.MavenProfileActivationOS;
import org.jetbrains.idea.maven.model.MavenProfileActivationProperty;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.server.MavenServerGlobals;

public class Maven40ModelConverter {
    @NotNull
    public static MavenModel convertModel(Model model) {
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        Build build = model.getBuild();
        return Maven40ModelConverter.convertModel(model, Maven40ModelConverter.asSourcesList(build.getSourceDirectory()), Maven40ModelConverter.asSourcesList(build.getTestSourceDirectory()));
    }

    @NotNull
    public static MavenModel convertModel(Model model, List<String> sources, List<String> testSources) {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven40ModelConverter.convertPlugins(model));
        result.setRemoteRepositories(Maven40ModelConverter.convertRepositories(model.getRepositories()));
        result.setProfiles(Maven40ModelConverter.convertProfiles(model.getProfiles()));
        result.setModules(model.getModules());
        Maven40ModelConverter.convertBuild(result.getBuild(), model.getBuild(), sources, testSources);
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven40ModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static List<MavenPlugin> convertPlugins(Model mavenModel) {
        List plugins;
        ArrayList<MavenPlugin> result = new ArrayList<MavenPlugin>();
        Build build = mavenModel.getBuild();
        if (build != null && (plugins = build.getPlugins()) != null) {
            for (Plugin each : plugins) {
                result.add(Maven40ModelConverter.convertPlugin(each));
            }
        }
        return result;
    }

    private static MavenPlugin convertPlugin(Plugin plugin) {
        ArrayList<MavenPlugin.Execution> executions = new ArrayList<MavenPlugin.Execution>(plugin.getExecutions().size());
        for (PluginExecution each : plugin.getExecutions()) {
            executions.add(Maven40ModelConverter.convertExecution(each));
        }
        ArrayList<MavenId> deps = new ArrayList<MavenId>(plugin.getDependencies().size());
        for (Dependency each : plugin.getDependencies()) {
            deps.add(new MavenId(each.getGroupId(), each.getArtifactId(), each.getVersion()));
        }
        return new MavenPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), false, "true".equals(plugin.getExtensions()), Maven40ModelConverter.convertConfiguration(plugin.getConfiguration()), executions, deps);
    }

    public static MavenPlugin.Execution convertExecution(PluginExecution execution) {
        return new MavenPlugin.Execution(execution.getId(), execution.getPhase(), execution.getGoals(), Maven40ModelConverter.convertConfiguration(execution.getConfiguration()));
    }

    private static Element convertConfiguration(Object config) {
        return config == null ? null : Maven40ModelConverter.xppToElement((Xpp3Dom)config);
    }

    protected static Element xppToElement(Xpp3Dom xpp) {
        Element result;
        try {
            result = new Element(xpp.getName());
        }
        catch (IllegalNameException e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return null;
        }
        Xpp3Dom[] children = xpp.getChildren();
        if (children == null || children.length == 0) {
            result.setText(xpp.getValue());
        } else {
            for (Xpp3Dom each : children) {
                Element child = Maven40ModelConverter.xppToElement(each);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    private static List<String> asSourcesList(String directory) {
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }

    public static void convertBuild(MavenBuild result, Build build, List<String> sources, List<String> testSources) {
        Maven40ModelConverter.convertBuildBase((MavenBuildBase)result, (BuildBase)build);
        result.setOutputDirectory(build.getOutputDirectory());
        result.setTestOutputDirectory(build.getTestOutputDirectory());
        result.setSources(sources);
        result.setTestSources(testSources);
    }

    private static void convertBuildBase(MavenBuildBase result, BuildBase build) {
        result.setFinalName(build.getFinalName());
        result.setDefaultGoal(build.getDefaultGoal());
        result.setDirectory(build.getDirectory());
        result.setResources(Maven40ModelConverter.convertResources(build.getResources()));
        result.setTestResources(Maven40ModelConverter.convertResources(build.getTestResources()));
        result.setFilters(build.getFilters() == null ? Collections.emptyList() : build.getFilters());
    }

    public static MavenId createMavenId(Artifact artifact) {
        return new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    public static List<MavenResource> convertResources(List<Resource> resources) {
        if (resources == null) {
            return new ArrayList<MavenResource>();
        }
        ArrayList<MavenResource> result = new ArrayList<MavenResource>(resources.size());
        for (Resource each : resources) {
            String directory = each.getDirectory();
            if (null == directory) continue;
            result.add(new MavenResource(directory, each.isFiltering(), each.getTargetPath(), Maven40ModelConverter.ensurePatterns(each.getIncludes()), Maven40ModelConverter.ensurePatterns(each.getExcludes())));
        }
        return result;
    }

    private static List<String> ensurePatterns(List<String> patterns) {
        return patterns == null ? Collections.emptyList() : patterns;
    }

    public static List<MavenRemoteRepository> convertRepositories(List<? extends Repository> repositories) {
        if (repositories == null) {
            return new ArrayList<MavenRemoteRepository>();
        }
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(repositories.size());
        for (Repository repository : repositories) {
            result.add(new MavenRemoteRepository(repository.getId(), repository.getName(), repository.getUrl(), repository.getLayout(), Maven40ModelConverter.convertPolicy(repository.getReleases()), Maven40ModelConverter.convertPolicy(repository.getSnapshots())));
        }
        return result;
    }

    public static List<MavenRemoteRepository> convertRemoteRepositories(List<? extends ArtifactRepository> repositories) {
        if (repositories == null) {
            return new ArrayList<MavenRemoteRepository>();
        }
        ArrayList<MavenRemoteRepository> result = new ArrayList<MavenRemoteRepository>(repositories.size());
        for (ArtifactRepository artifactRepository : repositories) {
            result.add(new MavenRemoteRepository(artifactRepository.getId(), artifactRepository.getId(), artifactRepository.getUrl(), artifactRepository.getLayout() != null ? artifactRepository.getLayout().getId() : "default", Maven40ModelConverter.convertPolicy(artifactRepository.getReleases()), Maven40ModelConverter.convertPolicy(artifactRepository.getSnapshots())));
        }
        return result;
    }

    private static MavenRemoteRepository.Policy convertPolicy(RepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    private static MavenRemoteRepository.Policy convertPolicy(ArtifactRepositoryPolicy policy) {
        return policy != null ? new MavenRemoteRepository.Policy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy()) : null;
    }

    private static String convertExtension(Artifact artifact) {
        ArtifactHandler handler = artifact.getArtifactHandler();
        String result = null;
        if (handler != null) {
            result = handler.getExtension();
        }
        if (result == null) {
            result = artifact.getType();
        }
        return result;
    }

    public static List<MavenProfile> convertProfiles(Collection<? extends Profile> profiles) {
        if (profiles == null) {
            return Collections.emptyList();
        }
        ArrayList<MavenProfile> result = new ArrayList<MavenProfile>();
        for (Profile profile : profiles) {
            String id = profile.getId();
            if (id == null) continue;
            MavenProfile profile2 = new MavenProfile(id, profile.getSource());
            List modules = profile.getModules();
            profile2.setModules(modules == null ? Collections.emptyList() : modules);
            profile2.setActivation(Maven40ModelConverter.convertActivation(profile.getActivation()));
            if (profile.getBuild() != null) {
                Maven40ModelConverter.convertBuildBase(profile2.getBuild(), profile.getBuild());
            }
            result.add(profile2);
        }
        return result;
    }

    private static MavenProfileActivation convertActivation(Activation activation) {
        if (activation == null) {
            return null;
        }
        MavenProfileActivation result = new MavenProfileActivation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setOs(Maven40ModelConverter.convertOsActivation(activation.getOs()));
        result.setJdk(activation.getJdk());
        result.setFile(Maven40ModelConverter.convertFileActivation(activation.getFile()));
        result.setProperty(Maven40ModelConverter.convertPropertyActivation(activation.getProperty()));
        return result;
    }

    private static MavenProfileActivationOS convertOsActivation(ActivationOS os) {
        return os == null ? null : new MavenProfileActivationOS(os.getName(), os.getFamily(), os.getArch(), os.getVersion());
    }

    private static MavenProfileActivationFile convertFileActivation(ActivationFile file) {
        return file == null ? null : new MavenProfileActivationFile(file.getExists(), file.getMissing());
    }

    private static MavenProfileActivationProperty convertPropertyActivation(ActivationProperty property) {
        return property == null ? null : new MavenProfileActivationProperty(property.getName(), property.getValue());
    }

    public static Map<String, String> convertToMap(Object object) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Maven40ModelConverter.doConvert(object, "", result);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isNativeToString(String toStringResult, Object o) {
        String className = o.getClass().getName();
        return toStringResult.startsWith(className) && toStringResult.startsWith("@", className.length());
    }

    private static void doConvert(Object object, String prefix, Map<String, String> result) throws IllegalAccessException, InvocationTargetException {
        for (Method each : ReflectionUtilRt.collectGetters(object.getClass())) {
            Class<?> type = each.getReturnType();
            if (Maven40ModelConverter.shouldSkip(type)) continue;
            each.setAccessible(true);
            Object value = each.invoke(object, new Object[0]);
            if (value == null) continue;
            String key = each.getName().substring(3);
            String name = prefix + key.substring(0, 1).toLowerCase() + key.substring(1);
            if (value instanceof String || value.getClass().isPrimitive()) {
                String sValue = String.valueOf(value);
                if (Maven40ModelConverter.isNativeToString(sValue, value)) continue;
                result.put(name, sValue);
                continue;
            }
            Package pack = type.getPackage();
            if (pack == null || !pack.getName().startsWith("org.apache.maven")) continue;
            Maven40ModelConverter.doConvert(value, name + ".", result);
        }
    }

    public static boolean shouldSkip(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Xpp3Dom.class.isAssignableFrom(clazz);
    }

    @NotNull
    public static Model toNativeModel(MavenModel model) {
        Model result = new Model();
        result.setArtifactId(model.getMavenId().getArtifactId());
        result.setGroupId(model.getMavenId().getGroupId());
        result.setVersion(model.getMavenId().getVersion());
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        if (model.getParent() != null) {
            Parent parent = new Parent();
            parent.setArtifactId(model.getParent().getMavenId().getArtifactId());
            parent.setGroupId(model.getParent().getMavenId().getGroupId());
            parent.setVersion(model.getParent().getMavenId().getVersion());
            parent.setRelativePath(model.getParent().getRelativePath());
            result.setParent(parent);
        }
        Maven40ModelConverter.toNativeModelBase((MavenModelBase)model, (ModelBase)result);
        result.setBuild(new Build());
        MavenBuild modelBuild = model.getBuild();
        Maven40ModelConverter.toNativeBuildBase((MavenBuildBase)modelBuild, (BuildBase)result.getBuild());
        result.getBuild().setOutputDirectory(modelBuild.getOutputDirectory());
        result.getBuild().setTestOutputDirectory(modelBuild.getTestOutputDirectory());
        if (modelBuild.getSources().size() > 1) {
            throw new RuntimeException("too many source directories: " + modelBuild.getSources());
        }
        if (modelBuild.getTestSources().size() > 1) {
            throw new RuntimeException("too many test directories: " + modelBuild.getTestSources());
        }
        if (modelBuild.getSources().size() == 1) {
            result.getBuild().setSourceDirectory((String)modelBuild.getSources().get(0));
        }
        if (modelBuild.getTestSources().size() == 1) {
            result.getBuild().setTestSourceDirectory((String)modelBuild.getTestSources().get(0));
        }
        result.setProfiles(Maven40ModelConverter.toNativeProfiles(model.getProfiles()));
        Model model2 = result;
        if (model2 == null) {
            Maven40ModelConverter.$$$reportNull$$$0(1);
        }
        return model2;
    }

    private static List<Profile> toNativeProfiles(List<MavenProfile> profiles) {
        ArrayList<Profile> result = new ArrayList<Profile>(profiles.size());
        for (MavenProfile each : profiles) {
            Profile p = new Profile();
            p.setId(each.getId());
            p.setSource(each.getSource());
            p.setBuild((BuildBase)new Build());
            p.setActivation(Maven40ModelConverter.toNativeActivation(each.getActivation()));
            Maven40ModelConverter.toNativeModelBase((MavenModelBase)each, (ModelBase)p);
            Maven40ModelConverter.toNativeBuildBase(each.getBuild(), p.getBuild());
            result.add(p);
        }
        return result;
    }

    private static Activation toNativeActivation(MavenProfileActivation activation) {
        if (activation == null) {
            return null;
        }
        Activation result = new Activation();
        result.setActiveByDefault(activation.isActiveByDefault());
        result.setJdk(activation.getJdk());
        result.setOs(Maven40ModelConverter.toNativeOsActivation(activation.getOs()));
        result.setFile(Maven40ModelConverter.toNativeFileActivation(activation.getFile()));
        result.setProperty(Maven40ModelConverter.toNativePropertyActivation(activation.getProperty()));
        return result;
    }

    private static ActivationOS toNativeOsActivation(MavenProfileActivationOS os) {
        if (os == null) {
            return null;
        }
        ActivationOS result = new ActivationOS();
        result.setArch(os.getArch());
        result.setFamily(os.getFamily());
        result.setName(os.getName());
        result.setVersion(os.getVersion());
        return result;
    }

    private static ActivationFile toNativeFileActivation(MavenProfileActivationFile file) {
        if (file == null) {
            return null;
        }
        ActivationFile result = new ActivationFile();
        result.setExists(file.getExists());
        result.setMissing(file.getMissing());
        return result;
    }

    private static ActivationProperty toNativePropertyActivation(MavenProfileActivationProperty property) {
        if (property == null) {
            return null;
        }
        ActivationProperty result = new ActivationProperty();
        result.setName(property.getName());
        result.setValue(property.getValue());
        return result;
    }

    private static void toNativeModelBase(MavenModelBase from, ModelBase to) {
        to.setModules(from.getModules());
        to.setProperties(from.getProperties());
    }

    private static void toNativeBuildBase(MavenBuildBase from, BuildBase to) {
        to.setFinalName(from.getFinalName());
        to.setDefaultGoal(from.getDefaultGoal());
        to.setDirectory(from.getDirectory());
        to.setFilters(from.getFilters());
        to.setResources(Maven40ModelConverter.toNativeResources(from.getResources()));
        to.setTestResources(Maven40ModelConverter.toNativeResources(from.getTestResources()));
    }

    private static List<Resource> toNativeResources(List<MavenResource> resources) {
        ArrayList<Resource> result = new ArrayList<Resource>(resources.size());
        for (MavenResource each : resources) {
            Resource r = new Resource();
            r.setDirectory(each.getDirectory());
            r.setTargetPath(each.getTargetPath());
            r.setFiltering(each.isFiltered());
            r.setIncludes(each.getIncludes());
            r.setExcludes(each.getExcludes());
            result.add(r);
        }
        return result;
    }

    public static Repository toNativeRepository(MavenRemoteRepository r) {
        Repository result = new Repository();
        result.setId(r.getId());
        result.setName(r.getName());
        result.setUrl(r.getUrl());
        result.setLayout(r.getLayout() == null ? "default" : r.getLayout());
        if (r.getReleasesPolicy() != null) {
            result.setReleases(Maven40ModelConverter.toNativePolicy(r.getReleasesPolicy()));
        }
        if (r.getSnapshotsPolicy() != null) {
            result.setSnapshots(Maven40ModelConverter.toNativePolicy(r.getSnapshotsPolicy()));
        }
        return result;
    }

    private static RepositoryPolicy toNativePolicy(MavenRemoteRepository.Policy policy) {
        RepositoryPolicy result = new RepositoryPolicy();
        result.setEnabled(policy.isEnabled());
        result.setUpdatePolicy(policy.getUpdatePolicy());
        result.setChecksumPolicy(policy.getChecksumPolicy());
        return result;
    }

    public static List<MavenArtifact> convertArtifacts(Collection<? extends Artifact> artifacts, Map<Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        if (artifacts == null) {
            return new ArrayList<MavenArtifact>();
        }
        LinkedHashSet<MavenArtifact> result = new LinkedHashSet<MavenArtifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            result.add(Maven40ModelConverter.convertArtifact(artifact, nativeToConvertedMap, localRepository));
        }
        return new ArrayList<MavenArtifact>(result);
    }

    public static MavenArtifact convertArtifact(Artifact artifact, Map<Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        MavenArtifact result = nativeToConvertedMap.get(artifact);
        if (result == null) {
            result = Maven40ModelConverter.convertArtifact(artifact, localRepository);
            nativeToConvertedMap.put(artifact, result);
        }
        return result;
    }

    public static MavenArtifact convertArtifact(Artifact artifact, File localRepository) {
        return new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), artifact.getType(), artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), Maven40ModelConverter.convertExtension(artifact), artifact.getFile(), localRepository, artifact.isResolved(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/maven/server/m40/utils/Maven40ModelConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "convertModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toNativeModel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

