/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.grouping;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.MainCallTreeNode;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ(\u0010\u0002\u001a\n\u0012\u0004\u0012\u0002H\u0004\u0018\u00010\u0003\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007H&J \u0010\b\u001a\u00020\t\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0007H\u0016J&\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u00030\u000eH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/ui/grouping/ProfilerNodesGrouper;", "", "groupWithRootNode", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "root", "Lcom/intellij/profiler/MainCallTreeNode;", "isApplicable", "", "node", "postprocessGroups", "", "groups", "", "Companion", "intellij.profiler.common"})
public interface ProfilerNodesGrouper {
    @NotNull
    public static final Companion Companion = com.intellij.profiler.ui.grouping.ProfilerNodesGrouper$Companion.$$INSTANCE;

    default public <Call extends BaseCallStackElement> boolean isApplicable(@NotNull MainCallTreeNode<Call> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        return false;
    }

    @Nullable
    public <Call extends BaseCallStackElement> FoldingNodesGroup<Call> groupWithRootNode(@NotNull MainCallTreeNode<Call> var1);

    default public <Call extends BaseCallStackElement> void postprocessGroups(@NotNull List<FoldingNodesGroup<Call>> groups2) {
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nJ(\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ui/grouping/ProfilerNodesGrouper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "validateGroup", "", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "group", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "validationFailed", "", "message", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nProfilerNodesGrouper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfilerNodesGrouper.kt\ncom/intellij/profiler/ui/grouping/ProfilerNodesGrouper$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,53:1\n13#2:54\n*S KotlinDebug\n*F\n+ 1 ProfilerNodesGrouper.kt\ncom/intellij/profiler/ui/grouping/ProfilerNodesGrouper$Companion\n*L\n22#1:54\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger LOG;

        private Companion() {
        }

        public final <Call extends BaseCallStackElement> boolean validateGroup(@NotNull FoldingNodesGroup<Call> group2) {
            Intrinsics.checkNotNullParameter(group2, (String)"group");
            Object groupStartData = group2.getGroupStart().getData();
            if (groupStartData == null) {
                this.validationFailed(group2, "Root node cannot be a start of a group");
                return false;
            }
            long groupStartValue = groupStartData.getValue();
            long totalChildrenValue = 0L;
            List<MainCallTreeNode<Call>> endNodes = group2.getGroupEnd();
            for (MainCallTreeNode<Call> endNode : endNodes) {
                Object object = endNode.getData();
                Intrinsics.checkNotNull((Object)object);
                long value = object.getValue();
                totalChildrenValue += value;
            }
            if (groupStartValue < totalChildrenValue) {
                this.validationFailed(group2, StringsKt.trimIndent((String)("\n          Sum of children values is greater than a group start value:\n          children value:    " + totalChildrenValue + "\n          group start value: " + groupStartValue + "\n        ")));
                return false;
            }
            return true;
        }

        private final <Call extends BaseCallStackElement> void validationFailed(FoldingNodesGroup<Call> group2, String message2) {
            Object object = group2.getGroupStart().getData();
            if (object == null || (object = (BaseCallStackElement)object.getCall()) == null) {
                object = "<root>";
            }
            LOG.warn("Cannot make a group starting with node \"" + object + "\": " + message2);
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ProfilerNodesGrouper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }
}

