/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.monitor;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Dataset;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.Overlay;
import java.awt.Graphics2D;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u00040\u0003BG\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/api/monitor/ValueDisplay;", "T", "", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "data", "Lcom/intellij/ui/charts/Dataset;", "Lcom/intellij/ui/charts/Coordinates;", "prefix", "", "postfix", "digits", "", "onlyValue", "", "(Lcom/intellij/ui/charts/Dataset;Ljava/lang/String;Ljava/lang/String;IZ)V", "getData", "()Lcom/intellij/ui/charts/Dataset;", "getPostfix", "()Ljava/lang/String;", "getPrefix", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.common"})
final class ValueDisplay<T extends Number>
extends Overlay<LineChart<Long, T, ?>> {
    @NotNull
    private final Dataset<Coordinates<Long, T>> data;
    @NotNull
    private final String prefix;
    @NotNull
    private final String postfix;
    private final int digits;
    private final boolean onlyValue;

    public ValueDisplay(@NotNull Dataset<Coordinates<Long, T>> data, @Nls @NotNull String prefix, @NlsSafe @NotNull String postfix, int digits, boolean onlyValue) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        this.data = data;
        this.prefix = prefix;
        this.postfix = postfix;
        this.digits = digits;
        this.onlyValue = onlyValue;
    }

    public /* synthetic */ ValueDisplay(Dataset dataset2, String string, String string2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(dataset2, string, string2, n, bl);
    }

    @NotNull
    public final Dataset<Coordinates<Long, T>> getData() {
        return this.data;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getPostfix() {
        return this.postfix;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates current = (Coordinates)CollectionsKt.lastOrNull((Iterable)this.data.getData());
        if (current != null && ((LineChart)this.getChart()).getRanges().getYMaxInitialized()) {
            String string;
            g.setColor(JBColor.foreground());
            g.drawString(this.prefix, ((LineChart)this.getChart()).getMargins().left, 20);
            if (this.onlyValue) {
                var5_3 = "%." + this.digits + "f" + this.postfix;
                var6_4 = new Object[]{current.getY().doubleValue()};
                String string2 = String.format(var5_3, Arrays.copyOf(var6_4, var6_4.length));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            } else {
                var5_3 = "%." + this.digits + "f / %." + this.digits + "f" + this.postfix;
                var6_4 = new Object[]{current.getY().doubleValue(), ((LineChart)this.getChart()).getRanges().getYMax().doubleValue()};
                String string3 = String.format(var5_3, Arrays.copyOf(var6_4, var6_4.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            }
            String values = string;
            int offset = g.getFontMetrics().stringWidth(values);
            g.drawString(values, ((LineChart)this.getChart()).getWidth() - ((LineChart)this.getChart()).getMargins().left - offset, 20);
        }
    }
}

