/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StatisticsRecorderUtil {
    private static final String[] BUILT_IN_RECORDERS = new String[]{"FUS", "MLSE"};
    private static final String IDEA_FUS_RECORDER_INTERNAL_MODE = "fus.internal.test.mode";
    private static final String IDEA_RECORDER_INTERNAL_MODE = "fus.recorder.internal.test.mode";

    public static boolean isBuildInRecorder(@NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsRecorderUtil.$$$reportNull$$$0(0);
        }
        return ContainerUtil.find((Object[])BUILT_IN_RECORDERS, it -> it.equals(recorderId)) != null;
    }

    public static boolean isAnyTestModeEnabled() {
        if (ApplicationManager.getApplication().isInternal()) {
            return StatisticsRecorderUtil.isFusInternalTestMode() || !StringUtil.isEmptyOrSpaces((String)System.getProperty(IDEA_RECORDER_INTERNAL_MODE));
        }
        return false;
    }

    @NotNull
    public static List<String> getRecordersInTestMode() {
        if (StatisticsRecorderUtil.isAnyTestModeEnabled()) {
            if (StatisticsRecorderUtil.isFusInternalTestMode()) {
                List list = ContainerUtil.map(StatisticsEventLogProviderUtil.getEventLogProviders(), it -> it.getRecorderId());
                if (list == null) {
                    StatisticsRecorderUtil.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<String> custom = StatisticsRecorderUtil.getCustomTestModeRecorders();
            if (!custom.isEmpty()) {
                List<String> list = custom;
                if (list == null) {
                    StatisticsRecorderUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            StatisticsRecorderUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static boolean isTestModeEnabled(@NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsRecorderUtil.$$$reportNull$$$0(4);
        }
        if (StatisticsRecorderUtil.isAnyTestModeEnabled()) {
            if (StatisticsRecorderUtil.isFusInternalTestMode()) {
                return true;
            }
            return StatisticsRecorderUtil.getCustomTestModeRecorders().contains(recorderId);
        }
        return false;
    }

    public static boolean isCharsEscapingRequired(@NotNull String recorderId) {
        if (recorderId == null) {
            StatisticsRecorderUtil.$$$reportNull$$$0(5);
        }
        return StatisticsEventLogProviderUtil.getEventLogProvider(recorderId).isCharsEscapingRequired();
    }

    @NotNull
    private static List<String> getCustomTestModeRecorders() {
        String additional = System.getProperty(IDEA_RECORDER_INTERNAL_MODE);
        if (!StringUtil.isEmptyOrSpaces((String)additional)) {
            Object[] split = additional.split(";");
            List list = ContainerUtil.mapNotNull((Object[])split, item -> StringUtil.nullize((String)item.trim()));
            if (list == null) {
                StatisticsRecorderUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            StatisticsRecorderUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean isFusInternalTestMode() {
        return Boolean.getBoolean(IDEA_FUS_RECORDER_INTERNAL_MODE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/utils/StatisticsRecorderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/utils/StatisticsRecorderUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordersInTestMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTestModeRecorders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBuildInRecorder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestModeEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCharsEscapingRequired";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

