/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.ActionExtendedSummary;
import com.intellij.internal.statistic.local.ActionSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummaryState;
import com.intellij.internal.statistic.local.ActionsTotalSummary;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsLocalSummary", storages={@Storage(value="actionSummary.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/local/ActionsLocalSummary;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/internal/statistic/local/ActionsLocalSummaryState;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "()V", "state", "totalSummary", "Lcom/intellij/internal/statistic/local/ActionsTotalSummary;", "calculateTotalSummary", "getActionStatsById", "Lcom/intellij/internal/statistic/local/ActionExtendedSummary;", "actionId", "", "getActionsStats", "", "Lcom/intellij/internal/statistic/local/ActionSummary;", "getState", "getTotalStats", "loadState", "", "updateActionsSummary", "place", "updateActionsSummary$intellij_platform_statistics", "intellij.platform.statistics"})
public final class ActionsLocalSummary
extends SimpleModificationTracker
implements PersistentStateComponent<ActionsLocalSummaryState> {
    @NotNull
    private volatile ActionsLocalSummaryState state = new ActionsLocalSummaryState(null, 1, null);
    @NotNull
    private volatile ActionsTotalSummary totalSummary = new ActionsTotalSummary(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);

    @NotNull
    public ActionsLocalSummaryState getState() {
        return this.state;
    }

    public void loadState(@NotNull ActionsLocalSummaryState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.totalSummary = this.calculateTotalSummary(state);
    }

    private final ActionsTotalSummary calculateTotalSummary(ActionsLocalSummaryState state) {
        int maxUsageCount = 0;
        int maxUsageCountFromSe = 0;
        int minUsageCount = Integer.MAX_VALUE;
        int minUsageCountFromSe = Integer.MAX_VALUE;
        for (ActionExtendedSummary value : state.getData$intellij_platform_statistics().values()) {
            maxUsageCount = Math.max(maxUsageCount, value.usageCount);
            minUsageCount = Math.min(minUsageCount, value.usageCount);
            maxUsageCountFromSe = Math.max(maxUsageCountFromSe, value.usageFromSearchEverywhere);
            minUsageCountFromSe = Math.min(minUsageCountFromSe, value.usageFromSearchEverywhere);
        }
        return new ActionsTotalSummary(maxUsageCount, minUsageCount, maxUsageCountFromSe, minUsageCountFromSe);
    }

    @NotNull
    public final synchronized ActionsTotalSummary getTotalStats() {
        return this.totalSummary;
    }

    @NotNull
    public final synchronized Map<String, ActionSummary> getActionsStats() {
        Map<String, ActionExtendedSummary> data = this.state.getData$intellij_platform_statistics();
        if (data.isEmpty()) {
            return MapsKt.emptyMap();
        }
        HashMap result = new HashMap(data.size());
        for (Map.Entry<String, ActionExtendedSummary> datum : data.entrySet()) {
            ActionSummary summary2 = new ActionSummary();
            summary2.usageCount = datum.getValue().usageCount;
            summary2.lastUsedTimestamp = datum.getValue().lastUsedTimestamp;
            ((Map)result).put(datum.getKey(), summary2);
        }
        return result;
    }

    @Nullable
    public final synchronized ActionExtendedSummary getActionStatsById(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return this.state.getData$intellij_platform_statistics().get(actionId);
    }

    public final synchronized void updateActionsSummary$intellij_platform_statistics(@NotNull String actionId, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        boolean isFromSearchEverywhere = Intrinsics.areEqual((Object)place, (Object)"GoToAction");
        ActionExtendedSummary actionExtendedSummary = this.state.getData$intellij_platform_statistics().computeIfAbsent(actionId, arg_0 -> ActionsLocalSummary.updateActionsSummary$lambda$0(updateActionsSummary.summary.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)actionExtendedSummary, (String)"computeIfAbsent(...)");
        ActionExtendedSummary summary2 = actionExtendedSummary;
        summary2.incrementUsage(isFromSearchEverywhere);
        this.totalSummary.updateUsage(summary2, isFromSearchEverywhere);
        this.incModificationCount();
    }

    private static final ActionExtendedSummary updateActionsSummary$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ActionExtendedSummary)$tmp0.invoke(p0);
    }
}

