/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventIdName;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventId;", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "description", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;Ljava/lang/String;)V", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "log", "", "project", "Lcom/intellij/openapi/project/Project;", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "toString", "intellij.platform.statistics"})
public final class EventId
extends BaseEventId {
    @NotNull
    private final EventLogGroup group;

    public EventId(@NotNull EventLogGroup group, @EventIdName @NonNls @NotNull String eventId, @NonNls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        super(eventId, group.getRecorder(), description);
        this.group = group;
    }

    public final void log() {
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), false);
    }

    public final void log(@Nullable Project project) {
        this.getLogger$intellij_platform_statistics().logAsync(this.group, this.getEventId(), new FeatureUsageData(this.group.getRecorder()).addProject(project).build(), false);
    }

    @NotNull
    public final MetricEvent metric() {
        return new MetricEvent(this.getEventId(), null, this.group.getRecorder());
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public String toString() {
        return "EventId(eventId='" + this.getEventId() + "')";
    }
}

