/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.integrations.maven;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndexUtils;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class MavenRepositoriesHolder {
    private static final String UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP_ID = "Unindexed maven repositories gradle detection";
    private static final Key<String> NOTIFICATION_KEY = Key.create((String)"Unindexed maven repositories gradle detection");
    private final Project myProject;
    private volatile Set<MavenRemoteRepository> myRemoteRepositories;
    private volatile Set<String> myNotIndexedUrls;

    public MavenRepositoriesHolder(Project project) {
        this.myProject = project;
        this.myRemoteRepositories = Collections.emptySet();
        this.myNotIndexedUrls = Collections.emptySet();
    }

    public void updateNotIndexedUrls(List<String> repositories) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (repositories.isEmpty()) {
            this.myNotIndexedUrls = Collections.emptySet();
            ExternalSystemNotificationManager.getInstance((Project)this.myProject).clearNotifications(UNINDEXED_MAVEN_REPOSITORIES_NOTIFICATION_GROUP_ID, NotificationSource.PROJECT_SYNC, GradleConstants.SYSTEM_ID);
        } else {
            this.myNotIndexedUrls = new HashSet<String>(repositories);
        }
    }

    public static MavenRepositoriesHolder getInstance(@NotNull Project p) {
        if (p == null) {
            MavenRepositoriesHolder.$$$reportNull$$$0(0);
        }
        return (MavenRepositoriesHolder)p.getService(MavenRepositoriesHolder.class);
    }

    public void update(Set<MavenRemoteRepository> remoteRepositories) {
        this.myRemoteRepositories = new HashSet<MavenRemoteRepository>(remoteRepositories);
    }

    public Set<MavenRemoteRepository> getRemoteRepositories() {
        return Collections.unmodifiableSet(this.myRemoteRepositories);
    }

    public boolean contains(String url) {
        String pathOrUrl = MavenIndexUtils.normalizePathOrUrl((String)url);
        for (MavenRemoteRepository repository : this.myRemoteRepositories) {
            if (!MavenIndexUtils.normalizePathOrUrl((String)repository.getUrl()).equals(pathOrUrl)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/plugins/gradle/integrations/maven/MavenRepositoriesHolder", "getInstance"));
    }
}

