/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventProcessor;

public final class GradleTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.openapi.externalSystem.event-processing");

    public static void onStatusChange(@NotNull GradleTestsExecutionConsole console, @NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> event) {
        TestEventProcessor eventProcessor;
        if (console == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(0);
        }
        if (event == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(1);
        }
        if ((eventProcessor = GradleTestEventsProcessor.createEventProcessor(console, event)) != null) {
            eventProcessor.process(event);
        }
    }

    @Nullable
    private static TestEventProcessor createEventProcessor(@NotNull GradleTestsExecutionConsole console, @NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> event) {
        if (console == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(2);
        }
        if (event == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(3);
        }
        TestOperationDescriptor descriptor = (TestOperationDescriptor)event.getDescriptor();
        if (event instanceof ExternalSystemStartEvent) {
            if (StringUtil.isEmpty((String)descriptor.getMethodName())) {
                return new BeforeSuiteEventProcessor(console);
            }
            return new BeforeTestEventProcessor(console);
        }
        if (event instanceof ExternalSystemFinishEvent) {
            if (StringUtil.isEmpty((String)descriptor.getMethodName())) {
                return new AfterSuiteEventProcessor(console);
            }
            return new AfterTestEventProcessor(console);
        }
        if (event instanceof ExternalSystemMessageEvent) {
            return new OnOutputEventProcessor(console);
        }
        LOG.warn("Undefined progress event " + event.getClass().getSimpleName() + " " + event);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/GradleTestEventsProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onStatusChange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createEventProcessor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

