/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateUtil {
    public static final Resolver NULL_RESOLVER = groups -> null;

    public static String resolveRefs(CharSequence text2, Pattern pattern, Resolver resolver) {
        if (text2 == null) {
            return "";
        }
        Matcher matcher = pattern.matcher(text2);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                String[] groups = new String[matcher.groupCount() + 1];
                for (int i = 0; i < groups.length; ++i) {
                    groups[i] = matcher.group(i);
                }
                String resolved = resolver.resolve(groups);
                matcher.appendReplacement(sb, resolved == null ? "" : resolved.replace("\\", "\\\\").replace("$", "\\$"));
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return text2.toString();
    }

    public static interface Resolver {
        public String resolve(String[] var1);
    }

    public static class MappedResolver
    implements Resolver {
        protected final Map<String, String> resolved;

        public MappedResolver(Map<String, String> map2) {
            this.resolved = map2;
        }

        public MappedResolver() {
            this(new HashMap<String, String>());
        }

        public MappedResolver set(String name, String value2) {
            this.resolved.put(name, value2);
            return this;
        }

        public Map<String, String> getMMap() {
            return this.resolved;
        }

        @Override
        public String resolve(String[] groups) {
            return groups.length > 2 ? null : this.resolved.get(groups[1]);
        }
    }
}

