/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.AttributeProvider;
import com.vladsch.flexmark.html.AttributeProviderFactory;
import com.vladsch.flexmark.html.DelegatingNodeRendererFactoryWrapper;
import com.vladsch.flexmark.html.Disposable;
import com.vladsch.flexmark.html.EmbeddedAttributeProvider;
import com.vladsch.flexmark.html.HtmlRendererOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.NodeRendererSubContext;
import com.vladsch.flexmark.html.NodeRenderingHandlerWrapper;
import com.vladsch.flexmark.html.RendererBuilder;
import com.vladsch.flexmark.html.RendererExtension;
import com.vladsch.flexmark.html.UriContentResolverFactory;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.NotNullValueSupplier;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.data.ScopedDataSet;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.dependency.DependencyResolver;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.format.TrackedOffsetUtils;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.misc.Extension;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.TagRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlRenderer
implements IRender {
    public static final DataKey<String> SOFT_BREAK = new DataKey<String>("SOFT_BREAK", "\n");
    public static final DataKey<String> HARD_BREAK = new DataKey<String>("HARD_BREAK", "<br />\n");
    public static final NullableDataKey<String> STRONG_EMPHASIS_STYLE_HTML_OPEN = new NullableDataKey("STRONG_EMPHASIS_STYLE_HTML_OPEN");
    public static final NullableDataKey<String> STRONG_EMPHASIS_STYLE_HTML_CLOSE = new NullableDataKey("STRONG_EMPHASIS_STYLE_HTML_CLOSE");
    public static final NullableDataKey<String> EMPHASIS_STYLE_HTML_OPEN = new NullableDataKey("EMPHASIS_STYLE_HTML_OPEN");
    public static final NullableDataKey<String> EMPHASIS_STYLE_HTML_CLOSE = new NullableDataKey("EMPHASIS_STYLE_HTML_CLOSE");
    public static final NullableDataKey<String> CODE_STYLE_HTML_OPEN = new NullableDataKey("CODE_STYLE_HTML_OPEN");
    public static final NullableDataKey<String> CODE_STYLE_HTML_CLOSE = new NullableDataKey("CODE_STYLE_HTML_CLOSE");
    public static final NullableDataKey<String> INLINE_CODE_SPLICE_CLASS = new NullableDataKey("INLINE_CODE_SPLICE_CLASS");
    public static final DataKey<Boolean> PERCENT_ENCODE_URLS = SharedDataKeys.PERCENT_ENCODE_URLS;
    public static final DataKey<Integer> INDENT_SIZE = SharedDataKeys.INDENT_SIZE;
    public static final DataKey<Boolean> ESCAPE_HTML = new DataKey<Boolean>("ESCAPE_HTML", false);
    public static final DataKey<Boolean> ESCAPE_HTML_BLOCKS = new DataKey<DataKey<Boolean>>("ESCAPE_HTML_BLOCKS", ESCAPE_HTML);
    public static final DataKey<Boolean> ESCAPE_HTML_COMMENT_BLOCKS = new DataKey<DataKey<Boolean>>("ESCAPE_HTML_COMMENT_BLOCKS", ESCAPE_HTML_BLOCKS);
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML = new DataKey<DataKey<Boolean>>("ESCAPE_HTML_BLOCKS", ESCAPE_HTML);
    public static final DataKey<Boolean> ESCAPE_INLINE_HTML_COMMENTS = new DataKey<DataKey<Boolean>>("ESCAPE_INLINE_HTML_COMMENTS", ESCAPE_INLINE_HTML);
    public static final DataKey<Boolean> SUPPRESS_HTML = new DataKey<Boolean>("SUPPRESS_HTML", false);
    public static final DataKey<Boolean> SUPPRESS_HTML_BLOCKS = new DataKey<DataKey<Boolean>>("SUPPRESS_HTML_BLOCKS", SUPPRESS_HTML);
    public static final DataKey<Boolean> SUPPRESS_HTML_COMMENT_BLOCKS = new DataKey<DataKey<Boolean>>("SUPPRESS_HTML_COMMENT_BLOCKS", SUPPRESS_HTML_BLOCKS);
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML = new DataKey<DataKey<Boolean>>("SUPPRESS_INLINE_HTML", SUPPRESS_HTML);
    public static final DataKey<Boolean> SUPPRESS_INLINE_HTML_COMMENTS = new DataKey<DataKey<Boolean>>("SUPPRESS_INLINE_HTML_COMMENTS", SUPPRESS_INLINE_HTML);
    public static final DataKey<Boolean> SOURCE_WRAP_HTML = new DataKey<Boolean>("SOURCE_WRAP_HTML", false);
    public static final DataKey<Boolean> SOURCE_WRAP_HTML_BLOCKS = new DataKey<DataKey<Boolean>>("SOURCE_WRAP_HTML_BLOCKS", SOURCE_WRAP_HTML);
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_RESOLVE_DUPES = SharedDataKeys.HEADER_ID_GENERATOR_RESOLVE_DUPES;
    public static final DataKey<String> HEADER_ID_GENERATOR_TO_DASH_CHARS = SharedDataKeys.HEADER_ID_GENERATOR_TO_DASH_CHARS;
    public static final DataKey<String> HEADER_ID_GENERATOR_NON_DASH_CHARS = SharedDataKeys.HEADER_ID_GENERATOR_NON_DASH_CHARS;
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NO_DUPED_DASHES = SharedDataKeys.HEADER_ID_GENERATOR_NO_DUPED_DASHES;
    public static final DataKey<Boolean> HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE = SharedDataKeys.HEADER_ID_GENERATOR_NON_ASCII_TO_LOWERCASE;
    public static final DataKey<Boolean> HEADER_ID_REF_TEXT_TRIM_LEADING_SPACES = SharedDataKeys.HEADER_ID_REF_TEXT_TRIM_LEADING_SPACES;
    public static final DataKey<Boolean> HEADER_ID_REF_TEXT_TRIM_TRAILING_SPACES = SharedDataKeys.HEADER_ID_REF_TEXT_TRIM_TRAILING_SPACES;
    public static final DataKey<Boolean> HEADER_ID_ADD_EMOJI_SHORTCUT = SharedDataKeys.HEADER_ID_ADD_EMOJI_SHORTCUT;
    public static final DataKey<Boolean> RENDER_HEADER_ID = SharedDataKeys.RENDER_HEADER_ID;
    public static final DataKey<Boolean> GENERATE_HEADER_ID = SharedDataKeys.GENERATE_HEADER_ID;
    public static final DataKey<Boolean> DO_NOT_RENDER_LINKS = SharedDataKeys.DO_NOT_RENDER_LINKS;
    public static final DataKey<String> FENCED_CODE_LANGUAGE_CLASS_PREFIX = new DataKey<String>("FENCED_CODE_LANGUAGE_CLASS_PREFIX", "language-");
    public static final DataKey<HashMap<String, String>> FENCED_CODE_LANGUAGE_CLASS_MAP = new DataKey<NotNullValueSupplier<HashMap>>("FENCED_CODE_LANGUAGE_CLASS_MAP", HashMap::new);
    public static final DataKey<String> FENCED_CODE_NO_LANGUAGE_CLASS = new DataKey<String>("FENCED_CODE_NO_LANGUAGE_CLASS", "");
    public static final DataKey<String> FENCED_CODE_LANGUAGE_DELIMITERS = new DataKey<String>("FENCED_CODE_LANGUAGE_DELIMITERS", " \t");
    public static final DataKey<String> SOURCE_POSITION_ATTRIBUTE = new DataKey<String>("SOURCE_POSITION_ATTRIBUTE", "");
    public static final DataKey<Boolean> SOURCE_POSITION_PARAGRAPH_LINES = new DataKey<Boolean>("SOURCE_POSITION_PARAGRAPH_LINES", false);
    public static final DataKey<String> TYPE = new DataKey<String>("TYPE", "HTML");
    public static final DataKey<ArrayList<TagRange>> TAG_RANGES = new DataKey<NotNullValueSupplier<ArrayList>>("TAG_RANGES", ArrayList::new);
    public static final DataKey<Boolean> RECHECK_UNDEFINED_REFERENCES = new DataKey<Boolean>("RECHECK_UNDEFINED_REFERENCES", false);
    public static final DataKey<Boolean> OBFUSCATE_EMAIL = new DataKey<Boolean>("OBFUSCATE_EMAIL", false);
    public static final DataKey<Boolean> OBFUSCATE_EMAIL_RANDOM = new DataKey<Boolean>("OBFUSCATE_EMAIL_RANDOM", true);
    public static final DataKey<Boolean> HTML_BLOCK_OPEN_TAG_EOL = new DataKey<Boolean>("HTML_BLOCK_OPEN_TAG_EOL", true);
    public static final DataKey<Boolean> HTML_BLOCK_CLOSE_TAG_EOL = new DataKey<Boolean>("HTML_BLOCK_CLOSE_TAG_EOL", true);
    public static final DataKey<Boolean> UNESCAPE_HTML_ENTITIES = new DataKey<Boolean>("UNESCAPE_HTML_ENTITIES", true);
    public static final DataKey<String> AUTOLINK_WWW_PREFIX = new DataKey<String>("AUTOLINK_WWW_PREFIX", "http://");
    public static final DataKey<String> SUPPRESSED_LINKS = new DataKey<String>("SUPPRESSED_LINKS", "javascript:.*");
    public static final DataKey<Boolean> NO_P_TAGS_USE_BR = new DataKey<Boolean>("NO_P_TAGS_USE_BR", false);
    public static final DataKey<Boolean> EMBEDDED_ATTRIBUTE_PROVIDER = new DataKey<Boolean>("EMBEDDED_ATTRIBUTE_PROVIDER", true);
    public static final DataKey<Integer> FORMAT_FLAGS = new DataKey<Integer>("RENDERER_FORMAT_FLAGS", LineAppendable.F_TRIM_LEADING_WHITESPACE);
    public static final DataKey<Integer> MAX_TRAILING_BLANK_LINES = SharedDataKeys.RENDERER_MAX_TRAILING_BLANK_LINES;
    public static final DataKey<Integer> MAX_BLANK_LINES = SharedDataKeys.RENDERER_MAX_BLANK_LINES;
    @Deprecated
    public static final int CONVERT_TABS = LineAppendable.F_CONVERT_TABS;
    @Deprecated
    public static final int COLLAPSE_WHITESPACE = LineAppendable.F_COLLAPSE_WHITESPACE;
    @Deprecated
    public static final int SUPPRESS_TRAILING_WHITESPACE = LineAppendable.F_TRIM_TRAILING_WHITESPACE;
    @Deprecated
    public static final int PASS_THROUGH = LineAppendable.F_PASS_THROUGH;
    @Deprecated
    public static final int FORMAT_ALL = LineAppendable.F_FORMAT_ALL;
    public static final DataKey<List<Pair<String, String>>> RENDERER_TYPE_EQUIVALENCE = new DataKey("RENDERER_TYPE_EQUIVALENCE", Collections.emptyList());
    @Deprecated
    public static final int FORMAT_CONVERT_TABS = LineAppendable.F_CONVERT_TABS;
    @Deprecated
    public static final int FORMAT_COLLAPSE_WHITESPACE = LineAppendable.F_COLLAPSE_WHITESPACE;
    @Deprecated
    public static final int FORMAT_SUPPRESS_TRAILING_WHITESPACE = LineAppendable.F_TRIM_TRAILING_WHITESPACE;
    @Deprecated
    public static final int FORMAT_ALL_OPTIONS = LineAppendable.F_FORMAT_ALL;
    public static final DataKey<List<TrackedOffset>> TRACKED_OFFSETS = new DataKey("TRACKED_OFFSETS", Collections.emptyList());
    final List<AttributeProviderFactory> attributeProviderFactories;
    final List<DelegatingNodeRendererFactoryWrapper> nodeRendererFactories;
    final List<LinkResolverFactory> linkResolverFactories;
    final HeaderIdGeneratorFactory htmlIdGeneratorFactory;
    final HtmlRendererOptions htmlOptions;
    final DataHolder options;

    HtmlRenderer(@NotNull Builder builder) {
        this.options = builder.toImmutable();
        this.htmlOptions = new HtmlRendererOptions(this.options);
        this.htmlIdGeneratorFactory = builder.htmlIdGeneratorFactory;
        ArrayList<DelegatingNodeRendererFactoryWrapper> nodeRenderers = new ArrayList<DelegatingNodeRendererFactoryWrapper>(builder.nodeRendererFactories.size());
        for (int i = builder.nodeRendererFactories.size() - 1; i >= 0; --i) {
            NodeRendererFactory nodeRendererFactory = builder.nodeRendererFactories.get(i);
            nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        }
        CoreNodeRenderer.Factory nodeRendererFactory = new CoreNodeRenderer.Factory();
        nodeRenderers.add(new DelegatingNodeRendererFactoryWrapper(nodeRenderers, nodeRendererFactory));
        this.nodeRendererFactories = DependencyResolver.resolveFlatDependencies(nodeRenderers, null, dependent -> dependent.getFactory().getClass());
        boolean addEmbedded = !builder.attributeProviderFactories.containsKey(EmbeddedAttributeProvider.Factory.getClass());
        ArrayList<AttributeProviderFactory> values = new ArrayList<AttributeProviderFactory>(builder.attributeProviderFactories.values());
        if (addEmbedded && EMBEDDED_ATTRIBUTE_PROVIDER.get(this.options).booleanValue()) {
            values.add(0, EmbeddedAttributeProvider.Factory);
        }
        this.attributeProviderFactories = DependencyResolver.resolveFlatDependencies(values, null, null);
        this.linkResolverFactories = DependencyResolver.resolveFlatDependencies(builder.linkResolverFactories, null, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder builder(@Nullable DataHolder options) {
        return new Builder(options);
    }

    @Override
    @NotNull
    public DataHolder getOptions() {
        return this.options;
    }

    @Override
    public void render(@NotNull Node node, @NotNull Appendable output2) {
        this.render(node, output2, this.htmlOptions.maxTrailingBlankLines);
    }

    public void render(@NotNull Node node, @NotNull Appendable output2, int maxTrailingBlankLines) {
        HtmlWriter htmlWriter = new HtmlWriter(output2, this.htmlOptions.indentSize, this.htmlOptions.formatFlags, !this.htmlOptions.htmlBlockOpenTagEol, !this.htmlOptions.htmlBlockCloseTagEol);
        MainNodeRenderer renderer = new MainNodeRenderer(this.options, htmlWriter, node.getDocument());
        if (renderer.htmlIdGenerator != HtmlIdGenerator.NULL && !(node instanceof Document)) {
            renderer.htmlIdGenerator.generateIds(node.getDocument());
        }
        renderer.render(node);
        htmlWriter.appendToSilently(output2, this.htmlOptions.maxBlankLines, maxTrailingBlankLines);
        TrackedOffsetUtils.resolveTrackedOffsets(node.getChars(), htmlWriter, TRACKED_OFFSETS.get(renderer.getDocument()), maxTrailingBlankLines, SharedDataKeys.RUNNING_TESTS.get(this.options));
        renderer.dispose();
    }

    @Override
    @NotNull
    public String render(@NotNull Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    public static boolean isCompatibleRendererType(@NotNull MutableDataHolder options, @NotNull String supportedRendererType) {
        String rendererType = TYPE.get(options);
        return HtmlRenderer.isCompatibleRendererType(options, rendererType, supportedRendererType);
    }

    public static boolean isCompatibleRendererType(@NotNull MutableDataHolder options, @NotNull String rendererType, @NotNull String supportedRendererType) {
        if (rendererType.equals(supportedRendererType)) {
            return true;
        }
        List<Pair<String, String>> equivalence = RENDERER_TYPE_EQUIVALENCE.get(options);
        for (Pair<String, String> pair : equivalence) {
            if (!rendererType.equals(pair.getFirst()) || !supportedRendererType.equals(pair.getSecond())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static MutableDataHolder addRenderTypeEquivalence(@NotNull MutableDataHolder options, @NotNull String rendererType, @NotNull String supportedRendererType) {
        if (!HtmlRenderer.isCompatibleRendererType(options, rendererType, supportedRendererType)) {
            List<Pair<String, String>> equivalence = RENDERER_TYPE_EQUIVALENCE.get(options);
            ArrayList<Pair<String, String>> newEquivalence = new ArrayList<Pair<String, String>>(equivalence);
            newEquivalence.add(new Pair<String, String>(rendererType, supportedRendererType));
            options.set(RENDERER_TYPE_EQUIVALENCE, newEquivalence);
        }
        return options;
    }

    private class MainNodeRenderer
    extends NodeRendererSubContext
    implements NodeRendererContext,
    Disposable {
        private Document document;
        private Map<Class<?>, NodeRenderingHandlerWrapper> renderers;
        private List<PhasedNodeRenderer> phasedRenderers;
        private LinkResolver[] myLinkResolvers;
        private Set<RenderingPhase> renderingPhases;
        private DataHolder options;
        private RenderingPhase phase;
        HtmlIdGenerator htmlIdGenerator;
        private HashMap<LinkType, HashMap<String, ResolvedLink>> resolvedLinkMap;
        private AttributeProvider[] attributeProviders;

        @Override
        public void dispose() {
            this.document = null;
            this.renderers = null;
            this.phasedRenderers = null;
            for (LinkResolver linkResolver : this.myLinkResolvers) {
                if (!(linkResolver instanceof Disposable)) continue;
                ((Disposable)((Object)linkResolver)).dispose();
            }
            this.myLinkResolvers = null;
            this.renderingPhases = null;
            this.options = null;
            if (this.htmlIdGenerator instanceof Disposable) {
                ((Disposable)((Object)this.htmlIdGenerator)).dispose();
            }
            this.htmlIdGenerator = null;
            this.resolvedLinkMap = null;
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                if (!(attributeProvider instanceof Disposable)) continue;
                ((Disposable)((Object)attributeProvider)).dispose();
            }
            this.attributeProviders = null;
        }

        MainNodeRenderer(DataHolder options, HtmlWriter htmlWriter, Document document2) {
            int i;
            super(htmlWriter);
            this.resolvedLinkMap = new HashMap();
            this.options = new ScopedDataSet(document2, options);
            this.document = document2;
            this.renderers = new HashMap(32);
            this.renderingPhases = new HashSet<RenderingPhase>(RenderingPhase.values().length);
            this.phasedRenderers = new ArrayList<PhasedNodeRenderer>(HtmlRenderer.this.nodeRendererFactories.size());
            this.myLinkResolvers = new LinkResolver[HtmlRenderer.this.linkResolverFactories.size()];
            int n = this.doNotRenderLinksNesting = HtmlRenderer.this.htmlOptions.doNotRenderLinksInDocument ? 0 : 1;
            this.htmlIdGenerator = HtmlRenderer.this.htmlIdGeneratorFactory != null ? HtmlRenderer.this.htmlIdGeneratorFactory.create(this) : (!HtmlRenderer.this.htmlOptions.generateHeaderIds ? HtmlIdGenerator.NULL : new HeaderIdGenerator.Factory().create(this));
            htmlWriter.setContext(this);
            for (i = HtmlRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                NodeRendererFactory nodeRendererFactory = HtmlRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.apply(this.getOptions());
                Set<NodeRenderingHandler<?>> renderingHandlers = nodeRenderer.getNodeRenderingHandlers();
                assert (renderingHandlers != null);
                for (NodeRenderingHandler<?> nodeType : renderingHandlers) {
                    NodeRenderingHandlerWrapper handlerWrapper = new NodeRenderingHandlerWrapper(nodeType, this.renderers.get(nodeType.getNodeType()));
                    this.renderers.put(nodeType.getNodeType(), handlerWrapper);
                }
                if (!(nodeRenderer instanceof PhasedNodeRenderer)) continue;
                Set<RenderingPhase> renderingPhases = ((PhasedNodeRenderer)nodeRenderer).getRenderingPhases();
                assert (renderingPhases != null);
                this.renderingPhases.addAll(renderingPhases);
                this.phasedRenderers.add((PhasedNodeRenderer)nodeRenderer);
            }
            for (i = 0; i < HtmlRenderer.this.linkResolverFactories.size(); ++i) {
                this.myLinkResolvers[i] = HtmlRenderer.this.linkResolverFactories.get(i).apply(this);
            }
            this.attributeProviders = new AttributeProvider[HtmlRenderer.this.attributeProviderFactories.size()];
            for (i = 0; i < HtmlRenderer.this.attributeProviderFactories.size(); ++i) {
                this.attributeProviders[i] = HtmlRenderer.this.attributeProviderFactories.get(i).apply(this);
            }
        }

        @Override
        @NotNull
        public Node getCurrentNode() {
            return this.renderingNode;
        }

        @Override
        @NotNull
        public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
            String urlSeq;
            HashMap resolvedLinks = this.resolvedLinkMap.computeIfAbsent(linkType, k -> new HashMap());
            ResolvedLink resolvedLink = (ResolvedLink)resolvedLinks.get(urlSeq = String.valueOf(url));
            if (resolvedLink == null) {
                resolvedLink = new ResolvedLink(linkType, urlSeq, attributes);
                if (!urlSeq.isEmpty()) {
                    LinkResolver linkResolver;
                    Node currentNode = this.getCurrentNode();
                    LinkResolver[] linkResolverArray = this.myLinkResolvers;
                    int n = linkResolverArray.length;
                    for (int i = 0; i < n && (resolvedLink = (linkResolver = linkResolverArray[i]).resolveLink(currentNode, this, resolvedLink)).getStatus() == LinkStatus.UNKNOWN; ++i) {
                    }
                    if (urlEncode == null && HtmlRenderer.this.htmlOptions.percentEncodeUrls || urlEncode != null && urlEncode.booleanValue()) {
                        resolvedLink = resolvedLink.withUrl(Escaping.percentEncodeUrl(resolvedLink.getUrl()));
                    }
                }
                resolvedLinks.put(urlSeq, resolvedLink);
            }
            return resolvedLink;
        }

        @Override
        public String getNodeId(@NotNull Node node) {
            String id = this.htmlIdGenerator.getId(node);
            if (HtmlRenderer.this.attributeProviderFactories.size() != 0) {
                MutableAttributes attributes = new MutableAttributes();
                if (id != null) {
                    attributes.replaceValue("id", id);
                }
                for (AttributeProvider attributeProvider : this.attributeProviders) {
                    attributeProvider.setAttributes(this.renderingNode, AttributablePart.ID, attributes);
                }
                id = attributes.getValue("id");
            }
            return id;
        }

        @Override
        @NotNull
        public DataHolder getOptions() {
            return this.options;
        }

        @Override
        @NotNull
        public HtmlRendererOptions getHtmlOptions() {
            return HtmlRenderer.this.htmlOptions;
        }

        @Override
        @NotNull
        public Document getDocument() {
            return this.document;
        }

        @Override
        @NotNull
        public RenderingPhase getRenderingPhase() {
            return this.phase;
        }

        @Override
        @NotNull
        public String encodeUrl(@NotNull CharSequence url) {
            if (HtmlRenderer.this.htmlOptions.percentEncodeUrls) {
                return Escaping.percentEncodeUrl(url);
            }
            return String.valueOf(url);
        }

        @Override
        @NotNull
        public MutableAttributes extendRenderingNodeAttributes(@NotNull AttributablePart part, Attributes attributes) {
            MutableAttributes attr = attributes != null ? attributes.toMutable() : new MutableAttributes();
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(this.renderingNode, part, attr);
            }
            return attr;
        }

        @Override
        @NotNull
        public MutableAttributes extendRenderingNodeAttributes(@NotNull Node node, @NotNull AttributablePart part, Attributes attributes) {
            MutableAttributes attr = attributes != null ? attributes.toMutable() : new MutableAttributes();
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(node, part, attr);
            }
            return attr;
        }

        @Override
        public void render(@NotNull Node node) {
            this.renderNode(node, this);
        }

        @Override
        public void delegateRender() {
            this.renderByPreviousHandler(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderByPreviousHandler(NodeRendererSubContext subContext) {
            if (subContext.renderingNode != null) {
                NodeRenderingHandlerWrapper nodeRenderer = subContext.renderingHandlerWrapper.myPreviousRenderingHandler;
                if (nodeRenderer != null) {
                    Node oldNode = subContext.renderingNode;
                    int oldDoNotRenderLinksNesting = subContext.doNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(oldNode, subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingNode = oldNode;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            } else {
                throw new IllegalStateException("renderingByPreviousHandler called outside node rendering code");
            }
        }

        @Override
        @NotNull
        public NodeRendererContext getSubContext(boolean inheritIndent) {
            HtmlWriter htmlWriter = new HtmlWriter(this.getHtmlWriter(), inheritIndent);
            htmlWriter.setContext(this);
            return new SubNodeRenderer(this, htmlWriter, false);
        }

        @Override
        @NotNull
        public NodeRendererContext getDelegatedSubContext(boolean inheritIndent) {
            HtmlWriter htmlWriter = new HtmlWriter(this.getHtmlWriter(), inheritIndent);
            htmlWriter.setContext(this);
            return new SubNodeRenderer(this, htmlWriter, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderNode(Node node, NodeRendererSubContext subContext) {
            if (node instanceof Document) {
                int oldDoNotRenderLinksNesting = subContext.getDoNotRenderLinksNesting();
                int documentDoNotRenderLinksNesting = this.getHtmlOptions().doNotRenderLinksInDocument ? 1 : 0;
                this.htmlIdGenerator.generateIds(this.document);
                for (RenderingPhase phase : RenderingPhase.values()) {
                    NodeRenderingHandlerWrapper nodeRenderer;
                    if (phase != RenderingPhase.BODY && !this.renderingPhases.contains((Object)phase)) continue;
                    this.phase = phase;
                    for (PhasedNodeRenderer phasedRenderer : this.phasedRenderers) {
                        if (!Objects.requireNonNull(phasedRenderer.getRenderingPhases()).contains((Object)phase)) continue;
                        subContext.doNotRenderLinksNesting = documentDoNotRenderLinksNesting;
                        subContext.renderingNode = node;
                        phasedRenderer.renderDocument(subContext, subContext.htmlWriter, (Document)node, phase);
                        subContext.renderingNode = null;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                    }
                    if (this.getRenderingPhase() != RenderingPhase.BODY || (nodeRenderer = this.renderers.get(node.getClass())) == null) continue;
                    subContext.doNotRenderLinksNesting = documentDoNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(node, subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingHandlerWrapper = prevWrapper;
                        subContext.renderingNode = null;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                    }
                }
            } else {
                NodeRenderingHandlerWrapper nodeRenderer = this.renderers.get(node.getClass());
                if (nodeRenderer != null) {
                    Node oldNode = this.renderingNode;
                    int oldDoNotRenderLinksNesting = subContext.doNotRenderLinksNesting;
                    NodeRenderingHandlerWrapper prevWrapper = subContext.renderingHandlerWrapper;
                    try {
                        subContext.renderingNode = node;
                        subContext.renderingHandlerWrapper = nodeRenderer;
                        nodeRenderer.myRenderingHandler.render(node, subContext, subContext.htmlWriter);
                    }
                    finally {
                        subContext.renderingNode = oldNode;
                        subContext.doNotRenderLinksNesting = oldDoNotRenderLinksNesting;
                        subContext.renderingHandlerWrapper = prevWrapper;
                    }
                }
            }
        }

        @Override
        public void renderChildren(@NotNull Node parent) {
            this.renderChildrenNode(parent, this);
        }

        protected void renderChildrenNode(Node parent, NodeRendererSubContext subContext) {
            Node node = parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                this.renderNode(node, subContext);
                node = next;
            }
        }

        private class SubNodeRenderer
        extends NodeRendererSubContext
        implements NodeRendererContext {
            private final MainNodeRenderer myMainNodeRenderer;

            public SubNodeRenderer(MainNodeRenderer mainNodeRenderer2, HtmlWriter htmlWriter, boolean inheritCurrentHandler) {
                super(htmlWriter);
                this.myMainNodeRenderer = mainNodeRenderer2;
                int n = this.doNotRenderLinksNesting = mainNodeRenderer2.getHtmlOptions().doNotRenderLinksInDocument ? 1 : 0;
                if (inheritCurrentHandler) {
                    this.renderingNode = mainNodeRenderer2.renderingNode;
                    this.renderingHandlerWrapper = mainNodeRenderer2.renderingHandlerWrapper;
                }
            }

            @Override
            public String getNodeId(@NotNull Node node) {
                return this.myMainNodeRenderer.getNodeId(node);
            }

            @Override
            @NotNull
            public DataHolder getOptions() {
                return this.myMainNodeRenderer.getOptions();
            }

            @Override
            @NotNull
            public HtmlRendererOptions getHtmlOptions() {
                return this.myMainNodeRenderer.getHtmlOptions();
            }

            @Override
            @NotNull
            public Document getDocument() {
                return this.myMainNodeRenderer.getDocument();
            }

            @Override
            @NotNull
            public RenderingPhase getRenderingPhase() {
                return this.myMainNodeRenderer.getRenderingPhase();
            }

            @Override
            @NotNull
            public String encodeUrl(@NotNull CharSequence url) {
                return this.myMainNodeRenderer.encodeUrl(url);
            }

            @Override
            @NotNull
            public MutableAttributes extendRenderingNodeAttributes(@NotNull AttributablePart part, Attributes attributes) {
                return this.myMainNodeRenderer.extendRenderingNodeAttributes(part, attributes);
            }

            @Override
            @NotNull
            public MutableAttributes extendRenderingNodeAttributes(@NotNull Node node, @NotNull AttributablePart part, Attributes attributes) {
                return this.myMainNodeRenderer.extendRenderingNodeAttributes(node, part, attributes);
            }

            @Override
            public void render(@NotNull Node node) {
                this.myMainNodeRenderer.renderNode(node, this);
            }

            @Override
            public void delegateRender() {
                this.myMainNodeRenderer.renderByPreviousHandler(this);
            }

            @Override
            @NotNull
            public Node getCurrentNode() {
                return this.myMainNodeRenderer.getCurrentNode();
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, urlEncode);
            }

            @Override
            @NotNull
            public ResolvedLink resolveLink(@NotNull LinkType linkType, @NotNull CharSequence url, Attributes attributes, Boolean urlEncode) {
                return this.myMainNodeRenderer.resolveLink(linkType, url, attributes, urlEncode);
            }

            @Override
            @NotNull
            public NodeRendererContext getSubContext(boolean inheritIndent) {
                HtmlWriter htmlWriter = new HtmlWriter(this.htmlWriter, inheritIndent);
                htmlWriter.setContext(this);
                return new SubNodeRenderer(this.myMainNodeRenderer, htmlWriter, false);
            }

            @Override
            @NotNull
            public NodeRendererContext getDelegatedSubContext(boolean inheritIndent) {
                HtmlWriter htmlWriter = new HtmlWriter(this.htmlWriter, inheritIndent);
                htmlWriter.setContext(this);
                return new SubNodeRenderer(this.myMainNodeRenderer, htmlWriter, true);
            }

            @Override
            public void renderChildren(@NotNull Node parent) {
                this.myMainNodeRenderer.renderChildrenNode(parent, this);
            }

            @Override
            @NotNull
            public HtmlWriter getHtmlWriter() {
                return this.htmlWriter;
            }

            @Override
            protected int getDoNotRenderLinksNesting() {
                return super.getDoNotRenderLinksNesting();
            }

            @Override
            public boolean isDoNotRenderLinks() {
                return super.isDoNotRenderLinks();
            }

            @Override
            public void doNotRenderLinks(boolean doNotRenderLinks) {
                super.doNotRenderLinks(doNotRenderLinks);
            }

            @Override
            public void doNotRenderLinks() {
                super.doNotRenderLinks();
            }

            @Override
            public void doRenderLinks() {
                super.doRenderLinks();
            }
        }
    }

    public static interface HtmlRendererExtension
    extends Extension {
        public void rendererOptions(@NotNull MutableDataHolder var1);

        public void extend(@NotNull Builder var1, @NotNull String var2);
    }

    public static class Builder
    extends BuilderBase<Builder>
    implements RendererBuilder {
        Map<Class<?>, AttributeProviderFactory> attributeProviderFactories = new LinkedHashMap();
        List<NodeRendererFactory> nodeRendererFactories = new ArrayList<NodeRendererFactory>();
        List<LinkResolverFactory> linkResolverFactories = new ArrayList<LinkResolverFactory>();
        HeaderIdGeneratorFactory htmlIdGeneratorFactory = null;

        public Builder() {
        }

        public Builder(@Nullable DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        @Override
        protected void removeApiPoint(@NotNull Object apiPoint) {
            if (apiPoint instanceof AttributeProviderFactory) {
                this.attributeProviderFactories.remove(apiPoint.getClass());
            } else if (apiPoint instanceof NodeRendererFactory) {
                this.nodeRendererFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkResolverFactory) {
                this.linkResolverFactories.remove(apiPoint);
            } else if (apiPoint instanceof HeaderIdGeneratorFactory) {
                this.htmlIdGeneratorFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        @Override
        protected void preloadExtension(@NotNull Extension extension) {
            if (extension instanceof HtmlRendererExtension) {
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.rendererOptions(this);
            } else if (extension instanceof RendererExtension) {
                RendererExtension htmlRendererExtension = (RendererExtension)extension;
                htmlRendererExtension.rendererOptions(this);
            }
        }

        @Override
        protected boolean loadExtension(@NotNull Extension extension) {
            if (extension instanceof HtmlRendererExtension) {
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.extend(this, TYPE.get(this));
                return true;
            }
            if (extension instanceof RendererExtension) {
                RendererExtension htmlRendererExtension = (RendererExtension)extension;
                htmlRendererExtension.extend(this, TYPE.get(this));
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public HtmlRenderer build() {
            return new HtmlRenderer(this);
        }

        @NotNull
        public Builder softBreak(@NotNull String softBreak) {
            this.set((DataKey)SOFT_BREAK, (Object)softBreak);
            return this;
        }

        @NotNull
        public Builder indentSize(int indentSize) {
            this.set((DataKey)INDENT_SIZE, (Object)indentSize);
            return this;
        }

        @NotNull
        public Builder escapeHtml(boolean escapeHtml) {
            this.set((DataKey)ESCAPE_HTML, (Object)escapeHtml);
            return this;
        }

        public boolean isRendererType(@NotNull String supportedRendererType) {
            String rendererType = TYPE.get(this);
            return HtmlRenderer.isCompatibleRendererType(this, rendererType, supportedRendererType);
        }

        @NotNull
        public Builder percentEncodeUrls(boolean percentEncodeUrls) {
            this.set((DataKey)PERCENT_ENCODE_URLS, (Object)percentEncodeUrls);
            return this;
        }

        @Override
        @NotNull
        public Builder attributeProviderFactory(@NotNull AttributeProviderFactory attributeProviderFactory) {
            this.attributeProviderFactories.put(attributeProviderFactory.getClass(), attributeProviderFactory);
            this.addExtensionApiPoint(attributeProviderFactory);
            return this;
        }

        @NotNull
        public Builder nodeRendererFactory(@NotNull NodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            this.addExtensionApiPoint(nodeRendererFactory);
            return this;
        }

        @Override
        @NotNull
        public Builder linkResolverFactory(@NotNull LinkResolverFactory linkResolverFactory) {
            this.linkResolverFactories.add(linkResolverFactory);
            this.addExtensionApiPoint(linkResolverFactory);
            return this;
        }

        @Override
        @NotNull
        public Builder contentResolverFactory(@NotNull UriContentResolverFactory contentResolverFactory) {
            throw new IllegalStateException("Not implemented");
        }

        @Override
        @NotNull
        public Builder htmlIdGeneratorFactory(@NotNull HeaderIdGeneratorFactory htmlIdGeneratorFactory) {
            if (this.htmlIdGeneratorFactory != null) {
                throw new IllegalStateException("custom header id factory is already set to " + htmlIdGeneratorFactory.getClass().getName());
            }
            this.htmlIdGeneratorFactory = htmlIdGeneratorFactory;
            this.addExtensionApiPoint(htmlIdGeneratorFactory);
            return this;
        }
    }
}

