/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gitlab;

import com.vladsch.flexmark.ext.gitlab.internal.GitLabBlockQuoteParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabInlineMathParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabInlineParser;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabNodeFormatter;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabNodeRenderer;
import com.vladsch.flexmark.ext.gitlab.internal.GitLabOptions;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import org.jetbrains.annotations.NotNull;

public class GitLabExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Formatter.FormatterExtension {
    private static final String[] DEFAULT_MATH_LANGUAGES = new String[]{"math"};
    private static final String[] DEFAULT_MERMAID_LANGUAGES = new String[]{"mermaid"};
    public static final DataKey<Boolean> INS_PARSER = new DataKey<Boolean>("INS_PARSER", true);
    public static final DataKey<Boolean> DEL_PARSER = new DataKey<Boolean>("DEL_PARSER", true);
    public static final DataKey<Boolean> BLOCK_QUOTE_PARSER = new DataKey<Boolean>("BLOCK_QUOTE_PARSER", true);
    public static final DataKey<Boolean> NESTED_BLOCK_QUOTES = new DataKey<Boolean>("NESTED_BLOCK_QUOTES", true);
    public static final DataKey<Boolean> INLINE_MATH_PARSER = new DataKey<Boolean>("INLINE_MATH_PARSER", true);
    public static final DataKey<Boolean> RENDER_BLOCK_MATH = new DataKey<Boolean>("RENDER_BLOCK_MATH", true);
    public static final DataKey<Boolean> RENDER_BLOCK_MERMAID = new DataKey<Boolean>("RENDER_BLOCK_MERMAID", true);
    public static final DataKey<Boolean> RENDER_VIDEO_IMAGES = new DataKey<Boolean>("RENDER_VIDEO_IMAGES", true);
    public static final DataKey<Boolean> RENDER_VIDEO_LINK = new DataKey<Boolean>("RENDER_VIDEO_LINK", true);
    public static final DataKey<String[]> MATH_LANGUAGES = new DataKey<String[]>("MATH_LANGUAGES", DEFAULT_MATH_LANGUAGES);
    public static final DataKey<String[]> MERMAID_LANGUAGES = new DataKey<String[]>("MERMAID_LANGUAGES", DEFAULT_MERMAID_LANGUAGES);
    public static final DataKey<String> INLINE_MATH_CLASS = new DataKey<String>("INLINE_MATH_CLASS", "katex");
    public static final DataKey<String> BLOCK_MATH_CLASS = new DataKey<String>("BLOCK_MATH_CLASS", "katex");
    public static final DataKey<String> BLOCK_MERMAID_CLASS = new DataKey<String>("BLOCK_MERMAID_CLASS", "mermaid");
    public static final DataKey<String> VIDEO_IMAGE_CLASS = new DataKey<String>("VIDEO_IMAGE_CLASS", "video-container");
    public static final DataKey<String> VIDEO_IMAGE_LINK_TEXT_FORMAT = new DataKey<String>("VIDEO_IMAGE_LINK_TEXT_FORMAT", "Download '%s'");
    @Deprecated
    public static final DataKey<String> BLOCK_INFO_DELIMITERS = HtmlRenderer.FENCED_CODE_LANGUAGE_DELIMITERS;
    public static final DataKey<String> VIDEO_IMAGE_EXTENSIONS = new DataKey<String>("VIDEO_IMAGE_EXTENSIONS", "mp4,m4v,mov,webm,ogv");

    private GitLabExtension() {
    }

    public static GitLabExtension create() {
        return new GitLabExtension();
    }

    @Override
    public void rendererOptions(@NotNull MutableDataHolder options) {
    }

    @Override
    public void parserOptions(MutableDataHolder options) {
    }

    @Override
    public void extend(Formatter.Builder formatterBuilder) {
        formatterBuilder.nodeFormatterFactory(new GitLabNodeFormatter.Factory());
    }

    @Override
    public void extend(Parser.Builder parserBuilder) {
        GitLabOptions options = new GitLabOptions(parserBuilder);
        if (options.blockQuoteParser) {
            parserBuilder.customBlockParserFactory(new GitLabBlockQuoteParser.Factory());
        }
        if (options.delParser || options.insParser) {
            parserBuilder.customInlineParserExtensionFactory(new GitLabInlineParser.Factory());
        }
        if (options.inlineMathParser) {
            parserBuilder.customInlineParserExtensionFactory(new GitLabInlineMathParser.Factory());
        }
    }

    @Override
    public void extend(@NotNull HtmlRenderer.Builder htmlRendererBuilder, @NotNull String rendererType) {
        if (htmlRendererBuilder.isRendererType("HTML")) {
            htmlRendererBuilder.nodeRendererFactory(new GitLabNodeRenderer.Factory());
        } else if (htmlRendererBuilder.isRendererType("JIRA")) {
            // empty if block
        }
    }
}

