/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features.statistician;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.DoubleEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.local.ContributorSummary;
import com.intellij.internal.statistic.local.ContributorsLocalSummary;
import com.intellij.internal.statistic.local.ContributorsSelectionsRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004J8\u0010\u0006\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bJ:\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J8\u0010\u0016\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/statistician/ContributorsLocalStatisticsFields;", "", "()V", "getFieldsDeclaration", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getLastTimeSelectedStatistics", "Ljava/util/ArrayList;", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "Lkotlin/collections/ArrayList;", "sessionStartTime", "", "lastSelectedTime", "isFromAll", "", "getLocalStatistics", "contributorId", "", "getSelectionAndTimeStatistics", "selection", "", "maxSelection", "getSelectionStatistics", "Companion", "intellij.searchEverywhereMl.ranking.core"})
@SourceDebugExtension(value={"SMAP\nContributorsLocalStatisticsFields.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContributorsLocalStatisticsFields.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/statistician/ContributorsLocalStatisticsFields\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,126:1\n40#2,3:127\n*S KotlinDebug\n*F\n+ 1 ContributorsLocalStatisticsFields.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/statistician/ContributorsLocalStatisticsFields\n*L\n47#1:127,3\n*E\n"})
public final class ContributorsLocalStatisticsFields {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntEventField SELECTION_ALL = EventFields.Int((String)"selectionAll");
    @NotNull
    private static final IntEventField SELECTION_OTHER = EventFields.Int((String)"selectionOther");
    @NotNull
    private static final DoubleEventField SELECTION_TO_MAX_ALL = EventFields.Double((String)"selectionToMaxAll");
    @NotNull
    private static final DoubleEventField SELECTION_TO_MAX_OTHER = EventFields.Double((String)"selectionToMaxOther");
    @NotNull
    private static final LongEventField TIME_SINCE_LAST_SELECTION_ALL = EventFields.Long$default((String)"timeSinceLastSelectionAll", null, (int)2, null);
    @NotNull
    private static final LongEventField TIME_SINCE_LAST_SELECTION_OTHER = EventFields.Long$default((String)"timeSinceLastSelectionOther", null, (int)2, null);
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_MINUTE_ALL = EventFields.Boolean((String)"wasSelectedInLastMinuteAll");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_MINUTE_OTHER = EventFields.Boolean((String)"wasSelectedInLastMinuteOther");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_HOUR_ALL = EventFields.Boolean((String)"wasSelectedInLastHourAll");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_HOUR_OTHER = EventFields.Boolean((String)"wasSelectedInLastHourOther");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_DAY_ALL = EventFields.Boolean((String)"wasSelectedInLastDayAll");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_DAY_OTHER = EventFields.Boolean((String)"wasSelectedInLastDayOther");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_MONTH_ALL = EventFields.Boolean((String)"wasSelectedInLastMonthAll");
    @NotNull
    private static final BooleanEventField WAS_SELECTED_IN_LAST_MONTH_OTHER = EventFields.Boolean((String)"wasSelectedInLastMonthOther");

    @NotNull
    public final List<EventField<?>> getFieldsDeclaration() {
        Object[] objectArray = new PrimitiveEventField[]{SELECTION_ALL, SELECTION_OTHER, SELECTION_TO_MAX_ALL, SELECTION_TO_MAX_OTHER, TIME_SINCE_LAST_SELECTION_ALL, TIME_SINCE_LAST_SELECTION_OTHER, WAS_SELECTED_IN_LAST_MINUTE_ALL, WAS_SELECTED_IN_LAST_MINUTE_OTHER, WAS_SELECTED_IN_LAST_HOUR_ALL, WAS_SELECTED_IN_LAST_HOUR_OTHER, WAS_SELECTED_IN_LAST_DAY_ALL, WAS_SELECTED_IN_LAST_DAY_OTHER, WAS_SELECTED_IN_LAST_MONTH_ALL, WAS_SELECTED_IN_LAST_MONTH_OTHER};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<EventPair<?>> getLocalStatistics(@NotNull String contributorId, long sessionStartTime) {
        Intrinsics.checkNotNullParameter((Object)contributorId, (String)"contributorId");
        boolean $i$f$service = false;
        Class<ContributorsLocalSummary> serviceClass$iv = ContributorsLocalSummary.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ContributorsLocalSummary localSummary = (ContributorsLocalSummary)object;
        ContributorSummary contributorSummary = localSummary.getContributorStatsById(contributorId);
        if (contributorSummary == null) {
            return CollectionsKt.emptyList();
        }
        ContributorSummary summary = contributorSummary;
        ContributorsSelectionsRange contributorsSelectionRange = localSummary.getContributorsSelectionsRange();
        List<EventPair<?>> localStatsAll = this.getSelectionAndTimeStatistics(summary.allTabSelectionCount, contributorsSelectionRange.getMaxAllTabSelectionCount(), sessionStartTime, summary.allTabLastSelectedTimestamp, true);
        List<EventPair<?>> localStatsOther = this.getSelectionAndTimeStatistics(summary.otherTabsSelectionCount, contributorsSelectionRange.getMaxOtherTabsSelectionCount(), sessionStartTime, summary.otherTabsLastSelectedTimestamp, false);
        return CollectionsKt.plus((Collection)localStatsAll, (Iterable)localStatsOther);
    }

    private final List<EventPair<?>> getSelectionAndTimeStatistics(int selection, int maxSelection, long sessionStartTime, long lastSelectedTime, boolean isFromAll) {
        ArrayList<EventPair<?>> selectionStats = this.getSelectionStatistics(selection, maxSelection, isFromAll);
        ArrayList<EventPair<?>> lastTimeSelectedStats = this.getLastTimeSelectedStatistics(sessionStartTime, lastSelectedTime, isFromAll);
        return CollectionsKt.plus((Collection)selectionStats, (Iterable)lastTimeSelectedStats);
    }

    private final ArrayList<EventPair<?>> getSelectionStatistics(int selection, int maxSelection, boolean isFromAll) {
        ArrayList data = new ArrayList();
        if (selection > 0) {
            IntEventField selectionType = isFromAll ? SELECTION_ALL : SELECTION_OTHER;
            data.add(selectionType.with((Object)selection));
            if (maxSelection != 0) {
                DoubleEventField selectionToMaxType = isFromAll ? SELECTION_TO_MAX_ALL : SELECTION_TO_MAX_OTHER;
                data.add(selectionToMaxType.with((Object)((double)selection / (double)maxSelection)));
            }
        }
        return data;
    }

    private final ArrayList<EventPair<?>> getLastTimeSelectedStatistics(long sessionStartTime, long lastSelectedTime, boolean isFromAll) {
        ArrayList data = new ArrayList();
        if (lastSelectedTime > 0L) {
            long timeSinceLastSelection = sessionStartTime - lastSelectedTime;
            data.add((isFromAll ? TIME_SINCE_LAST_SELECTION_ALL : TIME_SINCE_LAST_SELECTION_OTHER).with((Object)timeSinceLastSelection));
            SearchEverywhereElementFeaturesProviderKt.addIfTrue(data, isFromAll ? WAS_SELECTED_IN_LAST_MINUTE_ALL : WAS_SELECTED_IN_LAST_MINUTE_OTHER, timeSinceLastSelection <= 60000L);
            SearchEverywhereElementFeaturesProviderKt.addIfTrue(data, isFromAll ? WAS_SELECTED_IN_LAST_HOUR_ALL : WAS_SELECTED_IN_LAST_HOUR_OTHER, timeSinceLastSelection <= 3600000L);
            SearchEverywhereElementFeaturesProviderKt.addIfTrue(data, isFromAll ? WAS_SELECTED_IN_LAST_DAY_ALL : WAS_SELECTED_IN_LAST_DAY_OTHER, timeSinceLastSelection <= 86400000L);
            SearchEverywhereElementFeaturesProviderKt.addIfTrue(data, isFromAll ? WAS_SELECTED_IN_LAST_MONTH_ALL : WAS_SELECTED_IN_LAST_MONTH_OTHER, timeSinceLastSelection <= 2592000000L);
        }
        return data;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001d\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\u001f\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0011\u0010!\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010#\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0018R\u0011\u0010%\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/statistician/ContributorsLocalStatisticsFields$Companion;", "", "()V", "SELECTION_ALL", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "getSELECTION_ALL", "()Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "SELECTION_OTHER", "getSELECTION_OTHER", "SELECTION_TO_MAX_ALL", "Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "getSELECTION_TO_MAX_ALL", "()Lcom/intellij/internal/statistic/eventLog/events/DoubleEventField;", "SELECTION_TO_MAX_OTHER", "getSELECTION_TO_MAX_OTHER", "TIME_SINCE_LAST_SELECTION_ALL", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "getTIME_SINCE_LAST_SELECTION_ALL", "()Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "TIME_SINCE_LAST_SELECTION_OTHER", "getTIME_SINCE_LAST_SELECTION_OTHER", "WAS_SELECTED_IN_LAST_DAY_ALL", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getWAS_SELECTED_IN_LAST_DAY_ALL", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "WAS_SELECTED_IN_LAST_DAY_OTHER", "getWAS_SELECTED_IN_LAST_DAY_OTHER", "WAS_SELECTED_IN_LAST_HOUR_ALL", "getWAS_SELECTED_IN_LAST_HOUR_ALL", "WAS_SELECTED_IN_LAST_HOUR_OTHER", "getWAS_SELECTED_IN_LAST_HOUR_OTHER", "WAS_SELECTED_IN_LAST_MINUTE_ALL", "getWAS_SELECTED_IN_LAST_MINUTE_ALL", "WAS_SELECTED_IN_LAST_MINUTE_OTHER", "getWAS_SELECTED_IN_LAST_MINUTE_OTHER", "WAS_SELECTED_IN_LAST_MONTH_ALL", "getWAS_SELECTED_IN_LAST_MONTH_ALL", "WAS_SELECTED_IN_LAST_MONTH_OTHER", "getWAS_SELECTED_IN_LAST_MONTH_OTHER", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntEventField getSELECTION_ALL() {
            return SELECTION_ALL;
        }

        @NotNull
        public final IntEventField getSELECTION_OTHER() {
            return SELECTION_OTHER;
        }

        @NotNull
        public final DoubleEventField getSELECTION_TO_MAX_ALL() {
            return SELECTION_TO_MAX_ALL;
        }

        @NotNull
        public final DoubleEventField getSELECTION_TO_MAX_OTHER() {
            return SELECTION_TO_MAX_OTHER;
        }

        @NotNull
        public final LongEventField getTIME_SINCE_LAST_SELECTION_ALL() {
            return TIME_SINCE_LAST_SELECTION_ALL;
        }

        @NotNull
        public final LongEventField getTIME_SINCE_LAST_SELECTION_OTHER() {
            return TIME_SINCE_LAST_SELECTION_OTHER;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_MINUTE_ALL() {
            return WAS_SELECTED_IN_LAST_MINUTE_ALL;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_MINUTE_OTHER() {
            return WAS_SELECTED_IN_LAST_MINUTE_OTHER;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_HOUR_ALL() {
            return WAS_SELECTED_IN_LAST_HOUR_ALL;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_HOUR_OTHER() {
            return WAS_SELECTED_IN_LAST_HOUR_OTHER;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_DAY_ALL() {
            return WAS_SELECTED_IN_LAST_DAY_ALL;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_DAY_OTHER() {
            return WAS_SELECTED_IN_LAST_DAY_OTHER;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_MONTH_ALL() {
            return WAS_SELECTED_IN_LAST_MONTH_ALL;
        }

        @NotNull
        public final BooleanEventField getWAS_SELECTED_IN_LAST_MONTH_OTHER() {
            return WAS_SELECTED_IN_LAST_MONTH_OTHER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

