/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.GraphDataInput;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.java.ElementAnnotation;
import org.jetbrains.jps.dependency.java.FieldAssignUsage;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;

public final class JvmField
extends ProtoMember
implements DiffCapable<JvmField, Diff> {
    private static final JVMFlags INLINABLE_FIELD_FLAGS = new JVMFlags(16);

    public JvmField(JVMFlags flags, String signature, String name, String descriptor, @NotNull Iterable<ElementAnnotation> annotations, Object value) {
        if (annotations == null) {
            JvmField.$$$reportNull$$$0(0);
        }
        super(flags, signature, name, TypeRepr.getType(descriptor), annotations, value);
    }

    public JvmField(GraphDataInput in) throws IOException {
        super(in);
    }

    public boolean isSameKind(JvmField other) {
        return this.isStatic() == other.isStatic() && this.isSynthetic() == other.isSynthetic() && this.isFinal() == other.isFinal() && Objects.equals(this.getType(), other.getType());
    }

    public boolean isInlinable() {
        return this.getFlags().isAllSet(INLINABLE_FIELD_FLAGS);
    }

    @Override
    public FieldUsage createUsage(JvmNodeReferenceID owner) {
        return new FieldUsage(owner, this.getName(), this.getType().getDescriptor());
    }

    public FieldAssignUsage createAssignUsage(String owner) {
        return new FieldAssignUsage(owner, this.getName(), this.getType().getDescriptor());
    }

    @Override
    public boolean isSame(DiffCapable<?, ?> other) {
        return other instanceof JvmField && this.getName().equals(((JvmField)other).getName());
    }

    @Override
    public int diffHashCode() {
        return this.getName().hashCode();
    }

    public int hashCode() {
        return 31 * this.diffHashCode() + this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JvmField)) {
            return false;
        }
        JvmField other = (JvmField)obj;
        return this.isSame(other) && Objects.equals(this.getType(), other.getType());
    }

    @Override
    public Diff difference(JvmField past) {
        return new Diff(past);
    }

    public String toString() {
        return this.getName() + this.getType().getDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "org/jetbrains/jps/dependency/java/JvmField", "<init>"));
    }

    public final class Diff
    extends ProtoMember.Diff<JvmField> {
        public Diff(JvmField past) {
            super((ProtoMember)JvmField.this, (ProtoMember)past);
        }
    }
}

