/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.XmlReader;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class RadNestedForm
extends RadComponent {
    private static final Logger LOG = Logger.getInstance(RadNestedForm.class);
    private final String myFormFileName;
    private final RadRootContainer myRootContainer;

    public RadNestedForm(ModuleProvider module2, String formFileName, String id) throws Exception {
        super(module2, JPanel.class, id);
        this.myFormFileName = formFileName;
        LOG.debug("Loading nested form " + formFileName);
        VirtualFile formFile = ResourceFileUtil.findResourceFileInDependents((Module)this.getModule(), (String)formFileName);
        if (formFile == null) {
            throw new IllegalArgumentException("Couldn't find virtual file for nested form " + formFileName);
        }
        Document doc = FileDocumentManager.getInstance().getDocument(formFile);
        ClassLoader classLoader = LoaderFactory.getInstance(this.getProject()).getLoader(formFile);
        LwRootContainer rootContainer = Utils.getRootContainer((String)doc.getText(), (PropertiesProvider)new CompiledClassPropertiesProvider(classLoader));
        this.myRootContainer = XmlReader.createRoot(module2, rootContainer, classLoader, null);
        if (this.myRootContainer.getComponentCount() > 0) {
            this.getDelegee().setLayout(new BorderLayout());
            JComponent nestedFormDelegee = this.myRootContainer.getComponent(0).getDelegee();
            this.getDelegee().add((Component)nestedFormDelegee, "Center");
            this.setRadComponentRecursive(nestedFormDelegee);
        }
        if (this.isCustomCreateRequired()) {
            this.setCustomCreate(true);
        }
    }

    private void setRadComponentRecursive(JComponent component) {
        component.putClientProperty("radComponent", this);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            Component child = component.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            this.setRadComponentRecursive((JComponent)child);
        }
    }

    @Override
    public void write(XmlWriter writer) {
        writer.startElement("nested-form");
        try {
            this.writeId(writer);
            writer.addAttribute("form-file", this.myFormFileName);
            this.writeBinding(writer);
            this.writeConstraints(writer);
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    @NotNull
    public String getComponentClassName() {
        String string = this.myRootContainer.getClassToBind();
        if (string == null) {
            RadNestedForm.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean hasIntrospectedProperties() {
        return false;
    }

    @Override
    public boolean isCustomCreateRequired() {
        if (super.isCustomCreateRequired()) {
            return true;
        }
        PsiClass boundClass = FormEditingUtil.findClassToBind(this.getModule(), this.myRootContainer.getClassToBind());
        return RadNestedForm.isNonStaticInnerClass(boundClass);
    }

    private static boolean isNonStaticInnerClass(PsiClass boundClass) {
        if (boundClass == null) {
            return false;
        }
        return PsiUtil.isInnerClass((PsiClass)boundClass) || RadNestedForm.isNonStaticInnerClass(boundClass.getContainingClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/radComponents/RadNestedForm", "getComponentClassName"));
    }
}

