/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.editors.ComboBoxPropertyEditor;
import com.intellij.uiDesigner.propertyInspector.properties.BindingProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SlowOperations;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class BindingEditor
extends ComboBoxPropertyEditor<String> {
    public BindingEditor(final Project project) {
        this.myCbx.setEditable(true);
        JComponent editorComponent = (JComponent)this.myCbx.getEditor().getEditorComponent();
        editorComponent.setBorder(null);
        this.myCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BindingEditor.this.fireValueCommitted(true, false);
            }
        });
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!BindingEditor.this.myCbx.isPopupVisible()) {
                    BindingEditor.this.fireEditingCancelled();
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)DesignerToolWindowManager.getInstance(DesignerToolWindowManager.getInstance(project).getActiveFormEditor()).getPropertyInspector(), true));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uiDesigner/propertyInspector/editors/BindingEditor$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)this.myCbx);
    }

    private static String[] getFieldNames(RadComponent component, String currentName) {
        String binding;
        PsiField[] fields;
        IRootContainer root;
        String className;
        ArrayList<String> result = new ArrayList<String>();
        if (currentName != null) {
            result.add(currentName);
        }
        if ((className = (root = FormEditingUtil.getRoot(component)).getClassToBind()) == null) {
            return ArrayUtilRt.toStringArray(result);
        }
        PsiClass aClass = FormEditingUtil.findClassToBind(component.getModule(), className);
        if (aClass == null) {
            return ArrayUtilRt.toStringArray(result);
        }
        for (PsiField field : fields = aClass.getFields()) {
            PsiType componentType;
            String fieldName;
            if (field.hasModifierProperty("static") || Objects.equals(currentName, fieldName = field.getName()) || !FormEditingUtil.isBindingUnique(component, fieldName, (IComponent)root)) continue;
            String componentClassName = component instanceof RadErrorComponent ? component.getComponentClassName() : (component instanceof RadHSpacer || component instanceof RadVSpacer ? Spacer.class.getName() : component.getComponentClass().getName());
            try {
                componentType = JavaPsiFacade.getInstance((Project)component.getProject()).getElementFactory().createTypeFromText(componentClassName, null);
            }
            catch (IncorrectOperationException e) {
                continue;
            }
            PsiType fieldType = field.getType();
            if (!fieldType.isAssignableFrom(componentType)) continue;
            result.add(fieldName);
        }
        String text = FormInspectionUtil.getText(component.getModule(), component);
        if (text != null && (binding = BindingProperty.suggestBindingFromText(component, text)) != null && !result.contains(binding)) {
            result.add(binding);
        }
        Object[] names = ArrayUtilRt.toStringArray(result);
        Arrays.sort(names);
        return names;
    }

    @Override
    public String getValue() throws Exception {
        String value = (String)super.getValue();
        return value != null ? value.replace('$', '.') : null;
    }

    @Override
    public JComponent getComponent(RadComponent component, @NlsSafe String value, InplaceContext inplaceContext) {
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-307701, EA-653866");){
            String[] fieldNames = BindingEditor.getFieldNames(component, value);
            this.myCbx.setModel(new DefaultComboBoxModel<String>(fieldNames));
            this.myCbx.setSelectedItem((Object)value);
            ComboBox comboBox = this.myCbx;
            return comboBox;
        }
    }
}

