/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public class SvnDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<SvnFileRevision> {
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffFromHistoryHandler(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myVcs = vcs;
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull SvnFileRevision rev1, @Nullable SvnFileRevision rev2) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(1);
        }
        if (rev1 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(2);
        }
        File file = path.getIOFile();
        Target target1 = Target.on(rev1.getURL(), rev1.getRevision());
        Target target2 = rev2 != null ? Target.on(rev2.getURL(), rev2.getRevision()) : Target.on(file);
        return this.executeDiff(path, target1, target2);
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull SvnFileRevision rev) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(3);
        }
        if (rev == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(4);
        }
        Target target1 = Target.on(rev.getURL(), Revision.of(0L));
        Target target2 = Target.on(rev.getURL(), rev.getRevision());
        return this.executeDiff(path, target1, target2);
    }

    @NotNull
    protected String getPresentableName(@NotNull SvnFileRevision revision) {
        if (revision == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(5);
        }
        String string = revision.getRevisionNumber().asString();
        if (string == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @NotNull Target target1, @NotNull Target target2) throws VcsException {
        if (path == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(7);
        }
        if (target1 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(8);
        }
        if (target2 == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(9);
        }
        File file = path.getIOFile();
        ClientFactory factory = target2.isUrl() ? this.myVcs.getFactory(file) : DirectoryWithBranchComparer.getClientFactory(this.myVcs, file);
        List<Change> list = factory.createDiffClient().compare(target1, target2);
        if (list == null) {
            SvnDiffFromHistoryHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnDiffFromHistoryHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChangesBetweenRevisions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeDiff";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10 -> new IllegalStateException(string);
        };
    }
}

