/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GroupByPackages {
    private final Map<File, Collection<File>> myParentToChildrenMap;
    private final Collection<File> myRoots;

    public GroupByPackages(@NotNull Collection<? extends File> files2) {
        if (files2 == null) {
            GroupByPackages.$$$reportNull$$$0(0);
        }
        this.myParentToChildrenMap = new HashMap<File, Collection<File>>();
        this.myRoots = new HashSet<File>();
        for (File file : files2) {
            this.process(file);
        }
        this.splitRoots();
    }

    private void splitRoots() {
        for (File oldRoot : new ArrayList<File>(this.myRoots)) {
            File newRoot;
            if (oldRoot.equals(newRoot = this.splitRoot(oldRoot))) continue;
            this.replaceRoot(oldRoot, newRoot);
        }
    }

    private void replaceRoot(File oldRoot, File newRoot) {
        this.myRoots.remove(oldRoot);
        this.myRoots.add(newRoot);
    }

    private File splitRoot(@NotNull File oldRoot) {
        List<File> children;
        if (oldRoot == null) {
            GroupByPackages.$$$reportNull$$$0(1);
        }
        if ((children = this.getChildren(oldRoot)).size() == 1) {
            return this.splitRoot(children.get(0));
        }
        return oldRoot;
    }

    private void process(@NotNull File file) {
        if (file == null) {
            GroupByPackages.$$$reportNull$$$0(2);
        }
        File f = file;
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            Collection<File> files2 = this.myParentToChildrenMap.get(parent);
            if (files2 == null) {
                files2 = new HashSet<File>();
                this.myParentToChildrenMap.put(parent, files2);
            }
            files2.add(f);
            f = parent;
        }
        this.myRoots.add(f);
    }

    @NotNull
    public List<File> getRoots() {
        return new ArrayList<File>(this.myRoots);
    }

    @NotNull
    public List<File> getChildren(File file) {
        Collection<File> collection = this.myParentToChildrenMap.get(file);
        if (collection == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GroupByPackages.$$$reportNull$$$0(3);
            }
            return list;
        }
        return new ArrayList<File>(collection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/GroupByPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/GroupByPackages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

