/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.configurable.RecordInfo;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.UriUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a\u001d\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001d\u0010\r\u001a\u00070\t\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"RECORD_INFO_COMPARATOR", "Ljava/util/Comparator;", "Lcom/intellij/openapi/vcs/configurable/RecordInfo;", "collectDefaultMappedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "vcsName", "", "getAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "info", "getPresentablePath", "Lcom/intellij/openapi/util/NlsSafe;", "mapping", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "directory", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsDirectoryConfigurationPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,564:1\n766#2:565\n857#2,2:566\n1549#2:568\n1620#2,3:569\n*S KotlinDebug\n*F\n+ 1 VcsDirectoryConfigurationPanel.kt\ncom/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanelKt\n*L\n487#1:565\n487#1:566,2\n488#1:568\n488#1:569,3\n*E\n"})
public final class VcsDirectoryConfigurationPanelKt {
    @NotNull
    private static final Comparator<RecordInfo> RECORD_INFO_COMPARATOR;

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> collectDefaultMappedRoots(Project project, String vcsName) {
        void $this$mapTo$iv$iv;
        VcsRoot it;
        Iterable $this$filterTo$iv$iv;
        List<VcsRoot> list = ProjectLevelVcsManagerImpl.getInstanceImpl(project).getVcsRootObjectsForDefaultMapping();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVcsRootObjectsForDefaultMapping(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (VcsRoot)element$iv$iv;
            boolean bl = false;
            AbstractVcs abstractVcs = it.getVcs();
            if (!Intrinsics.areEqual((Object)(abstractVcs != null ? abstractVcs.getName() : null), (Object)vcsName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VcsRoot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    private static final String getPresentablePath(Project project, VcsDirectoryMapping mapping) {
        if (mapping.isDefaultMapping()) {
            Object t = VcsDirectoryMapping.PROJECT_CONSTANT.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return (String)t;
        }
        String string = mapping.getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDirectory(...)");
        return VcsDirectoryConfigurationPanelKt.getPresentablePath(project, string);
    }

    private static final String getPresentablePath(Project project, String directory) {
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            String string = new File(directory).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return string;
        }
        String string = UriUtil.trimTrailingSlashes((String)directory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTrailingSlashes(...)");
        File directoryFile = new File(StringsKt.removeSuffix((String)string, (CharSequence)"\\") + "/");
        File ioBase = new File(baseDir.getPath());
        if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
            String string2 = new File(directory).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            return string2;
        }
        String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
        if (Intrinsics.areEqual((Object)".", (Object)relativePath) || relativePath == null) {
            String string3 = ioBase.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            return string3;
        }
        return relativePath + " (" + ioBase + ")";
    }

    private static final SimpleTextAttributes getAttributes(RecordInfo info) {
        RecordInfo recordInfo = info;
        if (recordInfo instanceof RecordInfo.InvalidMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"ERROR_ATTRIBUTES");
            return simpleTextAttributes;
        }
        if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_BOLD_ATTRIBUTES");
            return simpleTextAttributes;
        }
        if (recordInfo instanceof RecordInfo.Header) {
            return new SimpleTextAttributes(129, null);
        }
        if (recordInfo instanceof RecordInfo.ValidMapping) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            return simpleTextAttributes;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final /* synthetic */ SimpleTextAttributes access$getAttributes(RecordInfo info) {
        return VcsDirectoryConfigurationPanelKt.getAttributes(info);
    }

    public static final /* synthetic */ String access$getPresentablePath(Project project, VcsDirectoryMapping mapping) {
        return VcsDirectoryConfigurationPanelKt.getPresentablePath(project, mapping);
    }

    public static final /* synthetic */ List access$collectDefaultMappedRoots(Project project, String vcsName) {
        return VcsDirectoryConfigurationPanelKt.collectDefaultMappedRoots(project, vcsName);
    }

    public static final /* synthetic */ Comparator access$getRECORD_INFO_COMPARATOR$p() {
        return RECORD_INFO_COMPARATOR;
    }

    static {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Comparable comparable;
                Comparable comparable2;
                RecordInfo info = (RecordInfo)a;
                boolean bl = false;
                RecordInfo recordInfo = info;
                if (recordInfo instanceof RecordInfo.ValidMapping) {
                    comparable2 = Integer.valueOf(0);
                } else if (recordInfo instanceof RecordInfo.InvalidMapping) {
                    comparable2 = Integer.valueOf(1);
                } else if (recordInfo instanceof RecordInfo.UnregisteredHeader) {
                    comparable2 = Integer.valueOf(2);
                } else if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
                    comparable2 = Integer.valueOf(3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                info = (RecordInfo)b;
                Comparable comparable3 = comparable2;
                bl = false;
                recordInfo = info;
                if (recordInfo instanceof RecordInfo.ValidMapping) {
                    comparable = Integer.valueOf(0);
                } else if (recordInfo instanceof RecordInfo.InvalidMapping) {
                    comparable = Integer.valueOf(1);
                } else if (recordInfo instanceof RecordInfo.UnregisteredHeader) {
                    comparable = Integer.valueOf(2);
                } else if (recordInfo instanceof RecordInfo.UnregisteredMapping) {
                    comparable = Integer.valueOf(3);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return ComparisonsKt.compareValues((Comparable)comparable3, (Comparable)comparable);
            }
        };
        Comparator comparator2 = FileNameComparator.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"getInstance(...)");
        Comparator comparator3 = comparator2;
        RECORD_INFO_COMPARATOR = new Comparator(comparator, comparator3){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    RecordInfo info;
                    RecordInfo recordInfo = (RecordInfo)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    RecordInfo.MappingInfo mappingInfo = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
                    String string = mappingInfo != null && (mappingInfo = mappingInfo.getMapping()) != null ? mappingInfo.getDirectory() : null;
                    info = (RecordInfo)b;
                    String string2 = string;
                    bl = false;
                    RecordInfo.MappingInfo mappingInfo2 = info instanceof RecordInfo.MappingInfo ? (RecordInfo.MappingInfo)info : null;
                    String string3 = mappingInfo2 != null && (mappingInfo2 = mappingInfo2.getMapping()) != null ? mappingInfo2.getDirectory() : null;
                    n = comparator.compare(string2, string3);
                }
                return n;
            }
        };
    }
}

