/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowEmptyStateKt;
import com.intellij.openapi.vcs.changes.ui.VcsToolWindowFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.ui.StatusText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/CommitToolWindowFactory;", "Lcom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "window", "isAvailable", "", "setEmptyState", "state", "Lcom/intellij/util/ui/StatusText;", "intellij.platform.vcs.impl"})
final class CommitToolWindowFactory
extends VcsToolWindowFactory {
    @Override
    public void init(@NotNull ToolWindow window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        super.init(window);
        AnAction anAction = ActionManager.getInstance().getAction("CommitView.GearActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        window.setAdditionalGearActions((ActionGroup)anAction);
    }

    @Override
    protected void setEmptyState(@NotNull Project project, @NotNull StatusText state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        VcsToolWindowEmptyStateKt.setCommitViewEmptyState(state, project);
    }

    @Override
    public boolean isAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectLevelVcsManager.getInstance((Project)project).hasAnyMappings() && ChangesViewContentManager.Companion.isCommitToolWindowShown(project) && TrustedProjects.isTrusted((Project)project);
    }

    @Override
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.createToolWindowContent(project, toolWindow);
        VcsToolWindowEmptyStateKt.hideCommitIdLabelIfNotEmptyState(toolWindow);
        if (toolWindow.getContentManager().isEmpty()) {
            ToolWindowEmptyStateAction.rebuildContentUi((ToolWindow)toolWindow);
        }
    }
}

