/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePath
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public RemoteFilePath(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            RemoteFilePath.$$$reportNull$$$0(0);
        }
        this.myPath = path2;
        this.myIsDirectory = isDirectory;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        return null;
    }

    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.getPath();
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            RemoteFilePath.$$$reportNull$$$0(3);
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project) {
        EncodingManager em = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        Charset charset = em.getDefaultCharset();
        if (charset == null) {
            RemoteFilePath.$$$reportNull$$$0(4);
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(this.getName());
        if (fileType == null) {
            RemoteFilePath.$$$reportNull$$$0(5);
        }
        return fileType;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            RemoteFilePath.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            RemoteFilePath.$$$reportNull$$$0(7);
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new RemoteFilePath(parent, true);
    }

    public boolean isNonLocal() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteFilePath other = (RemoteFilePath)o;
        return this.myIsDirectory == other.myIsDirectory && this.myPath.equals(other.myPath);
    }

    public int hashCode() {
        return 31 * this.myPath.hashCode() + (this.myIsDirectory ? 1 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/RemoteFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/RemoteFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

