/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.stack.SubFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eJ\u0006\u0010\u001e\u001a\u00020\u000eJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J\b\u0010$\u001a\u0004\u0018\u00010\"J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0016\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u001d\u0010*\u001a\u00020\u00162\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00160,H\u0082\bJ\u000e\u0010-\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\u0016\u0010.\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010/\u001a\u00020\"J\u000e\u00100\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'J\u000e\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00162\u0006\u00103\u001a\u000204J\u001a\u00105\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020)0706H\u0002J\b\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u000209J\b\u0010;\u001a\u000209H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "", "subFrameOwner", "Lorg/jetbrains/kotlin/ir/IrElement;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "innerStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "currentInstruction", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "currentFrame", "getCurrentFrame", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/SubFrame;", "currentSubFrameOwner", "getCurrentSubFrameOwner", "()Lorg/jetbrains/kotlin/ir/IrElement;", "addSubFrame", "", "removeSubFrame", "removeSubFrameWithoutDataPropagation", "hasNoSubFrames", "", "hasNoInstructions", "pushInstruction", "instruction", "popInstruction", "dropInstructions", "pushState", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "popState", "peekState", "storeState", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "variable", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "forEachSubFrame", "block", "Lkotlin/Function1;", "loadState", "rewriteState", "newState", "containsStateInMemory", "copyMemoryInto", "newFrame", "closure", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "getAll", "", "Lkotlin/Pair;", "getLineNumberForCurrentInstruction", "", "getFileAndPositionInfo", "toString", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Frame.kt\norg/jetbrains/kotlin/ir/interpreter/stack/Frame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n59#1:161\n60#1,2:163\n62#1:166\n59#1:167\n60#1,2:169\n62#1:172\n59#1:173\n60#1,2:175\n62#1:178\n1#2:158\n1863#3,2:159\n1863#3:162\n1864#3:165\n1863#3:168\n1864#3:171\n1863#3:174\n1864#3:177\n1863#3,2:179\n1863#3,2:181\n1368#3:183\n1454#3,5:184\n295#3,2:189\n*S KotlinDebug\n*F\n+ 1 Frame.kt\norg/jetbrains/kotlin/ir/interpreter/stack/Frame\n*L\n65#1:161\n65#1:163,2\n65#1:166\n70#1:167\n70#1:169,2\n70#1:172\n74#1:173\n74#1:175,2\n74#1:178\n59#1:159,2\n65#1:162\n65#1:165\n70#1:168\n70#1:171\n74#1:174\n74#1:177\n79#1:179,2\n83#1:181,2\n86#1:183\n86#1:184,5\n107#1:189,2\n*E\n"})
public final class Frame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final ArrayDeque<SubFrame> innerStack;
    @Nullable
    private Instruction currentInstruction;
    @NotNull
    public static final String NOT_DEFINED = "Not defined";

    /*
     * WARNING - void declaration
     */
    public Frame(@NotNull IrElement subFrameOwner, @Nullable IrFile irFile) {
        void $this$innerStack_u24lambda_u240;
        ArrayDeque arrayDeque;
        Intrinsics.checkNotNullParameter((Object)subFrameOwner, (String)"subFrameOwner");
        this.irFile = irFile;
        ArrayDeque arrayDeque2 = arrayDeque = new ArrayDeque();
        Frame frame = this;
        boolean bl = false;
        $this$innerStack_u24lambda_u240.add((Object)new SubFrame(subFrameOwner));
        frame.innerStack = arrayDeque;
    }

    public /* synthetic */ Frame(IrElement irElement, IrFile irFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        this(irElement, irFile);
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    private final SubFrame getCurrentFrame() {
        return (SubFrame)this.innerStack.last();
    }

    @NotNull
    public final IrElement getCurrentSubFrameOwner() {
        return this.getCurrentFrame().getOwner();
    }

    public final void addSubFrame(@NotNull IrElement subFrameOwner) {
        Intrinsics.checkNotNullParameter((Object)subFrameOwner, (String)"subFrameOwner");
        this.innerStack.add((Object)new SubFrame(subFrameOwner));
    }

    public final void removeSubFrame() {
        State state = this.getCurrentFrame().peekState();
        this.removeSubFrameWithoutDataPropagation();
        if (!this.hasNoSubFrames() && state != null) {
            this.getCurrentFrame().pushState(state);
        }
    }

    public final void removeSubFrameWithoutDataPropagation() {
        this.innerStack.removeLast();
    }

    public final boolean hasNoSubFrames() {
        return this.innerStack.isEmpty();
    }

    public final boolean hasNoInstructions() {
        return this.hasNoSubFrames() || this.innerStack.size() == 1 && ((SubFrame)this.innerStack.first()).isEmpty();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.getCurrentFrame().pushInstruction(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        Instruction instruction;
        Instruction $this$popInstruction_u24lambda_u241 = instruction = this.getCurrentFrame().popInstruction();
        boolean bl = false;
        this.currentInstruction = $this$popInstruction_u24lambda_u241;
        return instruction;
    }

    @Nullable
    public final Instruction dropInstructions() {
        return this.getCurrentFrame().dropInstructions();
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getCurrentFrame().pushState(state);
    }

    @NotNull
    public final State popState() {
        return this.getCurrentFrame().popState();
    }

    @Nullable
    public final State peekState() {
        return this.getCurrentFrame().peekState();
    }

    public final void storeState(@NotNull IrSymbol symbol, @Nullable State state) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.getCurrentFrame().storeState(symbol, state);
    }

    public final void storeState(@NotNull IrSymbol symbol, @NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.getCurrentFrame().storeState(symbol, variable);
    }

    private final void forEachSubFrame(Function1<? super SubFrame, Unit> block) {
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex((List)((List)this.innerStack)), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            block.invoke(this.innerStack.get(it));
        }
    }

    @NotNull
    public final State loadState(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex((List)((List)this_$iv.innerStack)), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            SubFrame it = (SubFrame)this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            State state = it.loadState(symbol);
            if (state == null) continue;
            State state2 = state;
            boolean bl3 = false;
            return state2;
        }
        throw new InterpreterError(symbol + " not found");
    }

    public final void rewriteState(@NotNull IrSymbol symbol, @NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex((List)((List)this_$iv.innerStack)), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            SubFrame it = (SubFrame)this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            if (!it.containsStateInMemory(symbol)) continue;
            it.rewriteState(symbol, newState);
            return;
        }
    }

    public final boolean containsStateInMemory(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Frame this_$iv = this;
        boolean $i$f$forEachSubFrame = false;
        Iterable $this$forEach$iv$iv = (Iterable)RangesKt.downTo((int)CollectionsKt.getLastIndex((List)((List)this_$iv.innerStack)), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it$iv = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            SubFrame it = (SubFrame)this_$iv.innerStack.get(it$iv);
            boolean bl2 = false;
            if (!it.containsStateInMemory(symbol)) continue;
            return true;
        }
        return false;
    }

    public final void copyMemoryInto(@NotNull Frame newFrame) {
        Intrinsics.checkNotNullParameter((Object)newFrame, (String)"newFrame");
        Iterable $this$forEach$iv = this.getAll();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IrSymbol symbol = (IrSymbol)pair.component1();
            Variable variable = (Variable)pair.component2();
            if (newFrame.containsStateInMemory(symbol)) continue;
            newFrame.storeState(symbol, variable);
        }
    }

    public final void copyMemoryInto(@NotNull StateWithClosure closure) {
        Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.getAll());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            IrSymbol symbol = (IrSymbol)pair.component1();
            Variable variable = (Variable)pair.component2();
            closure.getUpValues().put(symbol, variable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<IrSymbol, Variable>> getAll() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)this.innerStack;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SubFrame it = (SubFrame)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAll();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getLineNumberForCurrentInstruction() {
        if (this.irFile == null) {
            return "";
        }
        Instruction instruction = this.currentInstruction;
        IrElement frameOwner = instruction != null ? instruction.getElement() : null;
        return frameOwner instanceof IrExpression || frameOwner instanceof IrDeclaration && Intrinsics.areEqual((Object)((IrDeclaration)frameOwner).getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFINED()) ? "" + ':' + (this.irFile.getFileEntry().getLineNumber(((IrStatement)frameOwner).getStartOffset()) + 1) : "";
    }

    @NotNull
    public final String getFileAndPositionInfo() {
        if (this.irFile == null) {
            return NOT_DEFINED;
        }
        String lineNum = this.getLineNumberForCurrentInstruction();
        return IrDeclarationsKt.getName(this.irFile) + lineNum;
    }

    @NotNull
    public String toString() {
        Object v0;
        String fileNameCapitalized;
        block3: {
            if (this.irFile == null) {
                return NOT_DEFINED;
            }
            fileNameCapitalized = CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)StringsKt.replace$default((String)IrDeclarationsKt.getName(this.irFile), (String)".kt", (String)"Kt", (boolean)false, (int)4, null));
            Iterable $this$firstOrNull$iv = (Iterable)this.innerStack;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SubFrame it = (SubFrame)element$iv;
                boolean bl = false;
                if (!(it.getOwner() instanceof IrFunction)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        SubFrame subFrame = v0;
        IrElement irElement = subFrame != null ? subFrame.getOwner() : null;
        IrFunction entryPoint = irElement instanceof IrFunction ? (IrFunction)irElement : null;
        String lineNum = this.getLineNumberForCurrentInstruction();
        StringBuilder stringBuilder = new StringBuilder().append("at ").append(fileNameCapitalized).append('.');
        Object object = entryPoint;
        if (object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null) {
            object = "<clinit>";
        }
        return stringBuilder.append(object).append('(').append(IrDeclarationsKt.getName(this.irFile)).append(lineNum).append(')').toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame$Companion;", "", "<init>", "()V", "NOT_DEFINED", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

