/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LateinitLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/NullableFieldsDeclarationLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "withLocalDeclarations", "", "getWithLocalDeclarations", "()Z", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "transformGetter", "", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/NullableFieldsDeclarationLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1#2:232\n*E\n"})
public final class NullableFieldsDeclarationLowering
implements DeclarationTransformer {
    @NotNull
    private final CommonBackendContext backendContext;

    public NullableFieldsDeclarationLowering(@NotNull CommonBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        this.backendContext = backendContext;
    }

    @NotNull
    public final CommonBackendContext getBackendContext() {
        return this.backendContext;
    }

    @Override
    public boolean getWithLocalDeclarations() {
        return true;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        block3: {
            IrDeclaration irDeclaration;
            block2: {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                irDeclaration = declaration;
                if (!(irDeclaration instanceof IrProperty)) break block2;
                if (!LateinitLoweringKt.access$isRealLateinit((IrProperty)declaration)) break block3;
                IrProperty irProperty = (IrProperty)declaration;
                IrField irField = ((IrProperty)declaration).getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                irProperty.setBackingField(LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, irField));
                break block3;
            }
            if (!(irDeclaration instanceof IrSimpleFunction)) break block3;
            Object object = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            if (object != null && (object = (IrProperty)object.getOwner()) != null) {
                Object property = object;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)declaration, (Object)((IrProperty)property).getGetter()) && LateinitLoweringKt.access$isRealLateinit((IrProperty)property)) {
                    IrField irField = ((IrProperty)property).getBackingField();
                    Intrinsics.checkNotNull((Object)irField);
                    this.transformGetter(LateinitLoweringKt.access$buildOrGetNullableField(this.backendContext, irField), (IrFunction)declaration);
                }
            }
        }
        return null;
    }

    private final void transformGetter(IrField backingField, IrFunction getter2) {
        boolean bl;
        IrType type = backingField.getType();
        boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default(type, false, 1, null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-NullableFieldsDeclarationLowering$transformGetter$22 = false;
            String $i$a$-assert-NullableFieldsDeclarationLowering$transformGetter$22 = "'lateinit' modifier is not allowed on primitive types";
            throw new AssertionError((Object)$i$a$-assert-NullableFieldsDeclarationLowering$transformGetter$22);
        }
        int startOffset = getter2.getStartOffset();
        int endOffset = getter2.getEndOffset();
        getter2.setBody(IrFactoryHelpersKt.createBlockBody(this.backendContext.getIrFactory(), startOffset, endOffset, (Function1<? super IrBlockBody, Unit>)((Function1)arg_0 -> NullableFieldsDeclarationLowering.transformGetter$lambda$4(this, getter2, startOffset, endOffset, backingField, arg_0))));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit transformGetter$lambda$4(NullableFieldsDeclarationLowering this$0, IrFunction $getter, int $startOffset, int $endOffset, IrField $backingField, IrBlockBody $this$createBlockBody) {
        IrGetValueImpl irGetValueImpl;
        DeclarationIrBuilder irBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
        DeclarationIrBuilder $this$transformGetter_u24lambda_u244_u24lambda_u243 = irBuilder = LowerUtilsKt.createIrBuilder(this$0.backendContext, (IrSymbol)$getter.getSymbol(), $startOffset, $endOffset);
        boolean bl = false;
        Scope scope = $this$transformGetter_u24lambda_u244_u24lambda_u243.getScope();
        IrBuilderWithScope irBuilderWithScope = $this$transformGetter_u24lambda_u244_u24lambda_u243;
        IrValueParameter irValueParameter = $getter.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            void it;
            IrValueParameter irValueParameter2 = irValueParameter;
            IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
            Scope scope2 = scope;
            boolean bl2 = false;
            IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u244_u24lambda_u243, (IrValueDeclaration)it);
            scope = scope2;
            irBuilderWithScope = irBuilderWithScope2;
            irGetValueImpl = irGetValueImpl2;
        } else {
            irGetValueImpl = null;
        }
        IrVariable resultVar = IrBuilderKt.createTmpVariable$default(scope, (IrExpression)ExpressionHelpersKt.irGetField$default(irBuilderWithScope, irGetValueImpl, $backingField, null, 4, null), null, false, null, null, 30, null);
        resultVar.setParent($getter);
        $this$createBlockBody.getStatements().add(resultVar);
        IrBuilderWithScope irBuilderWithScope3 = $this$transformGetter_u24lambda_u244_u24lambda_u243;
        IrType irType = $this$transformGetter_u24lambda_u244_u24lambda_u243.getContext().getIrBuiltIns().getNothingType();
        IrExpression irExpression = ExpressionHelpersKt.irNotEquals($this$transformGetter_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u244_u24lambda_u243, resultVar), ExpressionHelpersKt.irNull($this$transformGetter_u24lambda_u244_u24lambda_u243));
        IrExpression irExpression2 = ExpressionHelpersKt.irReturn($this$transformGetter_u24lambda_u244_u24lambda_u243, ExpressionHelpersKt.irGet($this$transformGetter_u24lambda_u244_u24lambda_u243, resultVar));
        CommonBackendContext commonBackendContext = this$0.backendContext;
        IrBuilderWithScope irBuilderWithScope4 = $this$transformGetter_u24lambda_u244_u24lambda_u243;
        String string = $backingField.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default(irBuilderWithScope3, irType, irExpression, irExpression2, commonBackendContext.throwUninitializedPropertyAccessException(irBuilderWithScope4, string), null, 16, null);
        $this$createBlockBody.getStatements().add(throwIfNull);
        return Unit.INSTANCE;
    }
}

