/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J#\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001a2\b\u0010\u001e\u001a\u0004\u0018\u0001H\u0018H\u0016\u00a2\u0006\u0002\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/platform/impl/HashSuppliedIndexedFile;", "Lcom/intellij/util/indexing/FileContent;", "indexedFile", "Lcom/intellij/util/indexing/IndexedFile;", "hashId", "", "(Lcom/intellij/util/indexing/IndexedFile;J)V", "getHashId", "()J", "getContent", "", "getContentAsText", "", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileName", "", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getProject", "Lcom/intellij/openapi/project/Project;", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "intellij.indexing.shared"})
public final class HashSuppliedIndexedFile
implements FileContent {
    @NotNull
    private final IndexedFile indexedFile;
    private final long hashId;

    public HashSuppliedIndexedFile(@NotNull IndexedFile indexedFile, long hashId) {
        Intrinsics.checkNotNullParameter((Object)indexedFile, (String)"indexedFile");
        this.indexedFile = indexedFile;
        this.hashId = hashId;
    }

    public final long getHashId() {
        return this.hashId;
    }

    @NotNull
    public byte[] getContent() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public CharSequence getContentAsText() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiFile getPsiFile() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.indexedFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return fileType;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.indexedFile.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.indexedFile.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.indexedFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.indexedFile.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.indexedFile.putUserData(key, value);
    }
}

