/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download.permanentToken;

import com.intellij.indexing.shared.download.permanentToken.PermanentTokenConnectionTestKt;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenEnsureParams;
import com.intellij.indexing.shared.download.permanentToken.PermanentTokenWrapper;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/download/permanentToken/SharedIndexAuthPermanentNotifications;", "Lcom/intellij/openapi/Disposable;", "wrapper", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "(Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;)V", "myAllowToAsk", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myLatestCallback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenEnsureParams;", "myPendingNotification", "Lcom/intellij/notification/Notification;", "getWrapper", "()Lcom/intellij/indexing/shared/download/permanentToken/PermanentTokenWrapper;", "askForToken", "", "request", "dispose", "ensureNotificationPossible", "showNotification", "intellij.indexing.shared"})
public final class SharedIndexAuthPermanentNotifications
implements Disposable {
    @NotNull
    private final PermanentTokenWrapper wrapper;
    @NotNull
    private final AtomicBoolean myAllowToAsk;
    @NotNull
    private final AtomicReference<Notification> myPendingNotification;
    @NotNull
    private final AtomicReference<PermanentTokenEnsureParams> myLatestCallback;

    public SharedIndexAuthPermanentNotifications(@NotNull PermanentTokenWrapper wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        this.wrapper = wrapper;
        this.myAllowToAsk = new AtomicBoolean(true);
        this.myPendingNotification = new AtomicReference<Object>(null);
        this.myLatestCallback = new AtomicReference<Object>(null);
    }

    @NotNull
    public final PermanentTokenWrapper getWrapper() {
        return this.wrapper;
    }

    public void dispose() {
        Notification notification2 = this.myPendingNotification.getAndSet(null);
        if (notification2 != null) {
            notification2.expire();
        }
        this.myLatestCallback.set(null);
    }

    public final void ensureNotificationPossible() {
        this.myAllowToAsk.set(true);
    }

    public final void showNotification(@NotNull PermanentTokenEnsureParams request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (Disposer.isDisposed((Disposable)request.getLifetime())) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes User Action Response or Request");
        String string = SharedIndexesBundle.message("notification.title.permanent.auth", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{request.getPresentableUrl()};
        String string2 = SharedIndexesBundle.message("notification.content.permanent.auth", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification2 = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createExpiring((String)SharedIndexesBundle.message("notification.action.permanent.enter", new Object[0]), (arg_0, arg_1) -> SharedIndexAuthPermanentNotifications.showNotification$lambda$0((Function2)new Function2<AnActionEvent, Notification, Unit>(this, request){
            final /* synthetic */ SharedIndexAuthPermanentNotifications this$0;
            final /* synthetic */ PermanentTokenEnsureParams $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2);
            }

            public final void invoke(AnActionEvent anActionEvent, Notification notification2) {
                SharedIndexAuthPermanentNotifications.access$askForToken(this.this$0, this.$request);
            }
        }, arg_0, arg_1)));
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"addAction(...)");
        Notification notification3 = notification2;
        notification3.whenExpired(() -> SharedIndexAuthPermanentNotifications.showNotification$lambda$1(this, notification3));
        if (!this.myPendingNotification.compareAndSet(null, notification3)) {
            return;
        }
        if (!this.myAllowToAsk.compareAndSet(true, false)) {
            return;
        }
        this.myLatestCallback.set(request);
        Disposer.register((Disposable)request.getLifetime(), () -> SharedIndexAuthPermanentNotifications.showNotification$lambda$2(this, request));
        notification3.notify(null);
    }

    private final void askForToken(PermanentTokenEnsureParams request) {
        Object object;
        block5: {
            block4: {
                if (this.myLatestCallback.get() == null) {
                    return;
                }
                object = new Object[]{request.getPresentableUrl()};
                String string = Messages.showInputDialog((String)SharedIndexesBundle.message("message.text.permanent.enter", object), (String)SharedIndexesBundle.message("message.title.permanent.enter", new Object[0]), null);
                if (string == null) break block4;
                object = ((Object)StringsKt.trim((CharSequence)string)).toString();
                if (object != null) break block5;
            }
            return;
        }
        Object text = object;
        this.wrapper.resetToken();
        PermanentTokenConnectionTestKt.testConnectionUnderProgress(request, (String)text, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(request, this, (String)text){
            final /* synthetic */ PermanentTokenEnsureParams $request;
            final /* synthetic */ SharedIndexAuthPermanentNotifications this$0;
            final /* synthetic */ String $text;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                this.$text = $text;
                super(1);
            }

            public final void invoke(boolean result2) {
                block2: {
                    block1: {
                        if (result2) break block1;
                        Object[] objectArray = new Object[]{this.$request.getPresentableUrl()};
                        int retry = Messages.showYesNoDialog((String)SharedIndexesBundle.message("message.text.permanent.enter.error", objectArray), (String)SharedIndexesBundle.message("message.title.permanent.enter", new Object[0]), null);
                        if (retry == 0) {
                            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, this.$request){
                                final /* synthetic */ SharedIndexAuthPermanentNotifications this$0;
                                final /* synthetic */ PermanentTokenEnsureParams $request;
                                {
                                    this.this$0 = $receiver;
                                    this.$request = $request;
                                    super(0);
                                }

                                public final void invoke() {
                                    SharedIndexAuthPermanentNotifications.access$askForToken(this.this$0, this.$request);
                                }
                            }), (int)1, null);
                            return;
                        }
                        break block2;
                    }
                    SharedIndexAuthPermanentNotifications.access$getMyAllowToAsk$p(this.this$0).set(true);
                    this.this$0.getWrapper().setToken(this.$text);
                    PermanentTokenEnsureParams permanentTokenEnsureParams = SharedIndexAuthPermanentNotifications.access$getMyLatestCallback$p(this.this$0).getAndSet(null);
                    if (permanentTokenEnsureParams == null) break block2;
                    permanentTokenEnsureParams.notifyTokenUpdated();
                }
            }
        }));
    }

    private static final void showNotification$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void showNotification$lambda$1(SharedIndexAuthPermanentNotifications this$0, Notification $notification) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        this$0.myPendingNotification.compareAndSet($notification, null);
    }

    private static final void showNotification$lambda$2(SharedIndexAuthPermanentNotifications this$0, PermanentTokenEnsureParams $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        this$0.myLatestCallback.compareAndSet($request, null);
    }

    public static final /* synthetic */ void access$askForToken(SharedIndexAuthPermanentNotifications $this, PermanentTokenEnsureParams request) {
        $this.askForToken(request);
    }

    public static final /* synthetic */ AtomicBoolean access$getMyAllowToAsk$p(SharedIndexAuthPermanentNotifications $this) {
        return $this.myAllowToAsk;
    }

    public static final /* synthetic */ AtomicReference access$getMyLatestCallback$p(SharedIndexAuthPermanentNotifications $this) {
        return $this.myLatestCallback;
    }
}

