/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexSuggester;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexSuggestionService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dispose", "", "resolveSuggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexSuggestion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexSuggestion.kt\ncom/intellij/indexing/shared/download/SharedIndexSuggestionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n1360#2:117\n1446#2,5:118\n1360#2:123\n1446#2,5:124\n1477#2:129\n1502#2,3:130\n1505#2,3:140\n1238#2,4:145\n372#3,7:133\n453#3:143\n403#3:144\n*S KotlinDebug\n*F\n+ 1 SharedIndexSuggestion.kt\ncom/intellij/indexing/shared/download/SharedIndexSuggestionService\n*L\n96#1:117\n96#1:118,5\n101#1:123\n101#1:124,5\n106#1:129\n106#1:130,3\n106#1:140,3\n106#1:145,4\n106#1:133,7\n106#1:143\n106#1:144\n*E\n"})
public final class SharedIndexSuggestionService
implements Disposable {
    @NotNull
    private final Project project;

    public SharedIndexSuggestionService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        SharedIndexSuggestionKt.getSharedIndexSuggesterEP().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SharedIndexSuggester>(){

            public void extensionAdded(@NotNull SharedIndexSuggester extension, @NotNull PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    boolean $i$f$serviceIfCreated = false;
                    Application application = ApplicationManager.getApplication();
                    SharedIndexDownloadService sharedIndexDownloadService = (SharedIndexDownloadService)(application != null ? application.getServiceIfCreated(SharedIndexDownloadService.class) : null);
                    if (sharedIndexDownloadService == null) break block0;
                    sharedIndexDownloadService.rescanNow(this.getProject());
                }
            }

            public void extensionRemoved(@NotNull SharedIndexSuggester extension, @NotNull PluginDescriptor pluginDescriptor) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    boolean $i$f$serviceIfCreated = false;
                    Application application = ApplicationManager.getApplication();
                    SharedIndexLookup sharedIndexLookup = (SharedIndexLookup)(application != null ? application.getServiceIfCreated(SharedIndexLookup.class) : null);
                    if (sharedIndexLookup == null) break block0;
                    sharedIndexLookup.invalidateCaches();
                }
            }
        }, (Disposable)this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SharedIndexSuggestion> resolveSuggestions() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        List suggestions = new ArrayList();
        Collection collection = suggestions;
        Iterable $this$flatMap$iv = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SharedIndexSuggester it = (SharedIndexSuggester)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.suggestRequests(this.project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)$this$flatMap$iv);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexEx");
        FileBasedIndexEx fileBasedIndex2 = (FileBasedIndexEx)fileBasedIndex;
        List list = fileBasedIndex2.getIndexableFilesProviders(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIndexableFilesProviders(...)");
        List providers = list;
        for (IndexableFilesIterator provider : providers) {
            void $this$flatMapTo$iv$iv2;
            Object element$iv$iv;
            destination$iv$iv = suggestions;
            Iterable $this$flatMap$iv2 = SharedIndexSuggestionKt.getSharedIndexSuggesterEP().getExtensionList();
            boolean $i$f$flatMap2 = false;
            element$iv$iv = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                SharedIndexSuggester it = (SharedIndexSuggester)element$iv$iv2;
                boolean bl = false;
                IndexableSetOrigin indexableSetOrigin = provider.getOrigin();
                Intrinsics.checkNotNullExpressionValue((Object)indexableSetOrigin, (String)"getOrigin(...)");
                Iterable list$iv$iv = it.suggestRequests(indexableSetOrigin);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)$this$flatMap$iv2);
        }
        Object $this$groupBy$iv = suggestions;
        boolean $i$f$groupBy = false;
        Iterable $this$flatMap$iv2 = $this$groupBy$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getSharedIndexId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            if (((List)it.getValue()).size() > 1) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Several extensions reported the same kind/id for shared index. Only one will be used from: " + it.getValue());
            }
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)CollectionsKt.last((List)((List)it.getValue()));
            map2.put(k, sharedIndexSuggestion);
        }
        List candidates = CollectionsKt.toList((Iterable)destination$iv$iv3.values());
        return CollectionsKt.toList((Iterable)candidates);
    }
}

